/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.nio.ByteBuffer;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMutableData
extends NSData {
    public NSMutableData() {
    }

    protected NSMutableData(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSMutableData(@MachineSizedUInt long capacity) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(capacity));
    }

    @Property(selector="mutableBytes")
    @Pointer
    protected native long getMutableBytes();

    static void checkOffsetAndCount(int arrayLength, int offset, int count) {
        if ((offset | count) < 0 || offset > arrayLength || arrayLength - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + arrayLength + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    @Override
    public ByteBuffer asByteBuffer() {
        return VM.newDirectByteBuffer((long)this.getMutableBytes(), (long)this.getLength());
    }

    public NSMutableData append(ByteBuffer bytes) {
        long handle = NSMutableData.getEffectiveAddress(bytes) + (long)bytes.position();
        this.appendBytes(handle, bytes.remaining());
        return this;
    }

    public NSMutableData append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public NSMutableData append(byte[] bytes, int offset, int length) {
        NSMutableData.checkOffsetAndCount(bytes.length, offset, length);
        if (length == 0) {
            return this;
        }
        this.appendBytes(VM.getArrayValuesAddress((Object)bytes) + (long)offset, length);
        return this;
    }

    public NSMutableData insert(long location, ByteBuffer bytes) {
        return this.replace(new NSRange(location, 0L), bytes);
    }

    public NSMutableData insert(long location, byte[] bytes) {
        return this.replace(new NSRange(location, 0L), bytes, 0, bytes.length);
    }

    public NSMutableData insert(long location, byte[] bytes, int offset, int length) {
        return this.replace(new NSRange(location, 0L), bytes, offset, length);
    }

    public NSMutableData replace(NSRange range, ByteBuffer bytes) {
        long handle = NSMutableData.getEffectiveAddress(bytes) + (long)bytes.position();
        this.replaceBytes(range, handle, bytes.remaining());
        return this;
    }

    public NSMutableData replace(NSRange range, byte[] bytes) {
        return this.replace(range, bytes, 0, bytes.length);
    }

    public NSMutableData replace(NSRange range, byte[] bytes, int offset, int length) {
        NSMutableData.checkOffsetAndCount(bytes.length, offset, length);
        this.replaceBytes(range, VM.getArrayValuesAddress((Object)bytes) + (long)offset, length);
        return this;
    }

    public NSMutableData delete(NSRange range) {
        this.replaceBytes(range, 0L, 0L);
        return this;
    }

    @Method(selector="appendBytes:length:")
    protected native void appendBytes(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="appendData:")
    public native void append(NSData var1);

    @Method(selector="increaseLengthBy:")
    public native void increaseLength(@MachineSizedUInt long var1);

    @Method(selector="replaceBytesInRange:withBytes:")
    protected native void replaceBytes(@ByVal NSRange var1, @Pointer long var2);

    @Method(selector="resetBytesInRange:")
    public native void reset(@ByVal NSRange var1);

    @Method(selector="setData:")
    public native void setData(NSData var1);

    @Method(selector="replaceBytesInRange:withBytes:length:")
    protected native void replaceBytes(@ByVal NSRange var1, @Pointer long var2, @MachineSizedUInt long var4);

    @Method(selector="initWithCapacity:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    static {
        ObjCRuntime.bind(NSMutableData.class);
    }

    public static class NSMutableDataPtr
    extends Ptr<NSMutableData, NSMutableDataPtr> {
    }
}

