/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMutableArray<T extends NSObject>
extends NSArray<T> {
    public NSMutableArray() {
    }

    protected NSMutableArray(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSMutableArray(@MachineSizedUInt long numItems) {
        super((NSObject.SkipInit)null);
        this.initObject(this.init(numItems));
    }

    public NSMutableArray(Collection<T> c) {
        super(c);
    }

    public NSMutableArray(T ... objects) {
        super(objects);
    }

    @Override
    protected AbstractList<T> createAdapter() {
        return new ListAdapter(this);
    }

    public static NSArray<?> read(File file) {
        return NSMutableArray.read(file.getAbsolutePath());
    }

    public static NSMutableArray<NSString> toNSMutableArray(String ... strings) {
        int length = strings.length;
        NSObject[] nsStrings = new NSString[length];
        for (int i = 0; i < length; ++i) {
            nsStrings[i] = new NSString(strings[i]);
        }
        return new NSMutableArray(nsStrings);
    }

    public static NSMutableArray<NSString> toNSMutableArray(List<String> strings) {
        int size = strings.size();
        NSObject[] nsStrings = new NSString[size];
        for (int i = 0; i < size; ++i) {
            nsStrings[i] = new NSString(strings.get(i));
        }
        return new NSMutableArray(nsStrings);
    }

    @Method(selector="arrayWithContentsOfFile:")
    protected static native NSArray<? extends NSObject> read(String var0);

    @Method(selector="arrayWithContentsOfURL:")
    public static native NSArray<? extends NSObject> read(NSURL var0);

    @Method(selector="insertObject:atIndex:")
    protected native void insertObject(NSObject var1, @MachineSizedUInt long var2);

    @Method(selector="removeObjectAtIndex:")
    protected native void removeObject(@MachineSizedUInt long var1);

    @Method(selector="replaceObjectAtIndex:withObject:")
    protected native void replaceObject(@MachineSizedUInt long var1, NSObject var3);

    @Method(selector="initWithCapacity:")
    @Pointer
    protected native long init(@MachineSizedUInt long var1);

    @Method(selector="removeAllObjects")
    protected native void removeAllObjects();

    static {
        ObjCRuntime.bind(NSMutableArray.class);
    }

    static class ListAdapter<U extends NSObject>
    extends NSArray.ListAdapter<U> {
        ListAdapter(NSArray<U> array) {
            super(array);
        }

        @Override
        public void clear() {
            ((NSMutableArray)this.array).removeAllObjects();
        }

        @Override
        public U set(int index, U element) {
            NSArray.checkNull(element);
            this.checkIndex(index);
            Object old = this.array.getObjectAt(index);
            ((NSMutableArray)this.array).replaceObject(index, (NSObject)element);
            return (U)old;
        }

        @Override
        public void add(int index, U element) {
            NSArray.checkNull(element);
            if (index < 0 || (long)index > this.array.getCount()) {
                this.checkIndex(index);
            }
            ((NSMutableArray)this.array).insertObject((NSObject)element, index);
        }

        @Override
        public U remove(int index) {
            this.checkIndex(index);
            Object old = this.array.getObjectAt(index);
            ((NSMutableArray)this.array).removeObject(index);
            return (U)old;
        }
    }

    public static class NSMutableArrayPtr<T extends NSObject>
    extends Ptr<NSMutableArrayPtr<T>, NSMutableArrayPtr<T>> {
    }
}

