/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSEnumerationOptions;
import org.robovm.apple.foundation.NSMetadataItem;
import org.robovm.apple.foundation.NSMetadataItemAttribute;
import org.robovm.apple.foundation.NSMetadataQueryAttributeValueTuple;
import org.robovm.apple.foundation.NSMetadataQueryDelegate;
import org.robovm.apple.foundation.NSMetadataQueryResultGroup;
import org.robovm.apple.foundation.NSMetadataQueryScope;
import org.robovm.apple.foundation.NSMetadataQueryUpdatedItems;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSPredicate;
import org.robovm.apple.foundation.NSSortDescriptor;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSMetadataQuery
extends NSObject {
    public NSMetadataQuery() {
    }

    protected NSMetadataQuery(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="delegate")
    public native NSMetadataQueryDelegate getDelegate();

    @Property(selector="setDelegate:", strongRef=true)
    public native void setDelegate(NSMetadataQueryDelegate var1);

    @Property(selector="predicate")
    public native NSPredicate getPredicate();

    @Property(selector="setPredicate:")
    public native void setPredicate(NSPredicate var1);

    @Property(selector="sortDescriptors")
    public native NSArray<NSSortDescriptor> getSortDescriptors();

    @Property(selector="setSortDescriptors:")
    public native void setSortDescriptors(NSArray<NSSortDescriptor> var1);

    @Property(selector="valueListAttributes")
    @Marshaler(value=NSMetadataItemAttribute.AsListMarshaler.class)
    public native List<NSMetadataItemAttribute> getValueListAttributes();

    @Property(selector="setValueListAttributes:")
    public native void setValueListAttributes(@Marshaler(value=NSMetadataItemAttribute.AsListMarshaler.class) List<NSMetadataItemAttribute> var1);

    @Property(selector="groupingAttributes")
    @Marshaler(value=NSMetadataItemAttribute.AsListMarshaler.class)
    public native List<NSMetadataItemAttribute> getGroupingAttributes();

    @Property(selector="setGroupingAttributes:")
    public native void setGroupingAttributes(@Marshaler(value=NSMetadataItemAttribute.AsListMarshaler.class) List<NSMetadataItemAttribute> var1);

    @Property(selector="notificationBatchingInterval")
    public native double getNotificationBatchingInterval();

    @Property(selector="setNotificationBatchingInterval:")
    public native void setNotificationBatchingInterval(double var1);

    @Property(selector="searchScopes")
    protected native NSArray<?> getSearchScopes0();

    @Property(selector="setSearchScopes:")
    protected native void setSearchScopes0(NSArray<?> var1);

    @Property(selector="searchItems")
    protected native NSArray<?> getSearchItems0();

    @Property(selector="setSearchItems:")
    protected native void setSearchItems0(NSArray<?> var1);

    @Property(selector="operationQueue")
    public native NSOperationQueue getOperationQueue();

    @Property(selector="setOperationQueue:")
    public native void setOperationQueue(NSOperationQueue var1);

    @Property(selector="isStarted")
    public native boolean isStarted();

    @Property(selector="isGathering")
    public native boolean isGathering();

    @Property(selector="isStopped")
    public native boolean isStopped();

    @Property(selector="resultCount")
    @MachineSizedUInt
    public native long getResultCount();

    @Property(selector="results")
    public native NSArray<NSMetadataItem> getResults();

    @Property(selector="valueLists")
    protected native NSDictionary<NSString, NSMetadataQueryAttributeValueTuple> getValueLists0();

    @Property(selector="groupedResults")
    public native NSArray<NSMetadataQueryResultGroup> getGroupedResults();

    public void setSearchScopes(NSArray<NSURL> scopes) {
        this.setSearchScopes0(scopes);
    }

    public void setSearchScopes(List<String> scopes) {
        this.setSearchScopes0(NSArray.fromStrings(scopes));
    }

    public void setSearchScopes(NSMetadataQueryScope ... scopes) {
        NSMutableArray<NSString> array = new NSMutableArray<NSString>();
        for (NSMetadataQueryScope scope : scopes) {
            array.add(scope.value());
        }
        this.setSearchScopes0(array);
    }

    public List<String> getSearchScopes() {
        return this.getSearchScopes0().asStringList();
    }

    public void setSearchItems(NSArray<NSMetadataItem> items) {
        this.setSearchItems0(items);
    }

    public void setSearchItemURLs(NSArray<NSURL> urls) {
        this.setSearchItems0(urls);
    }

    public NSArray<NSObject> getSearchItems() {
        return this.getSearchItems0();
    }

    public Map<NSMetadataItemAttribute, NSMetadataQueryAttributeValueTuple> getValueLists() {
        HashMap<NSMetadataItemAttribute, NSMetadataQueryAttributeValueTuple> values = new HashMap<NSMetadataItemAttribute, NSMetadataQueryAttributeValueTuple>();
        NSDictionary<NSString, NSMetadataQueryAttributeValueTuple> valueLists = this.getValueLists0();
        for (Map.Entry<NSString, NSMetadataQueryAttributeValueTuple> entry : valueLists.entrySet()) {
            values.put(NSMetadataItemAttribute.valueOf(entry.getKey()), entry.getValue());
        }
        return values;
    }

    @GlobalValue(symbol="NSMetadataQueryDidStartGatheringNotification", optional=true)
    public static native NSString DidStartGatheringNotification();

    @GlobalValue(symbol="NSMetadataQueryGatheringProgressNotification", optional=true)
    public static native NSString GatheringProgressNotification();

    @GlobalValue(symbol="NSMetadataQueryDidFinishGatheringNotification", optional=true)
    public static native NSString DidFinishGatheringNotification();

    @GlobalValue(symbol="NSMetadataQueryDidUpdateNotification", optional=true)
    public static native NSString DidUpdateNotification();

    @Method(selector="startQuery")
    public native boolean startQuery();

    @Method(selector="stopQuery")
    public native void stopQuery();

    @Method(selector="disableUpdates")
    public native void disableUpdates();

    @Method(selector="enableUpdates")
    public native void enableUpdates();

    @Method(selector="resultAtIndex:")
    public native NSMetadataItem getResult(@MachineSizedUInt long var1);

    @Method(selector="enumerateResultsUsingBlock:")
    public native void enumerateResults(@Block(value="(,@MachineSizedUInt,)") VoidBlock3<NSMetadataItem, Long, BooleanPtr> var1);

    @Method(selector="enumerateResultsWithOptions:usingBlock:")
    public native void enumerateResults(NSEnumerationOptions var1, @Block(value="(,@MachineSizedUInt,)") VoidBlock3<NSMetadataItem, Long, BooleanPtr> var2);

    @Method(selector="indexOfResult:")
    @MachineSizedUInt
    public native long indexOfResult(NSMetadataItem var1);

    @Method(selector="valueOfAttribute:forResultAtIndex:")
    public native NSObject getValueForResult(NSMetadataItemAttribute var1, @MachineSizedUInt long var2);

    static {
        ObjCRuntime.bind(NSMetadataQuery.class);
    }

    public static class NSMetadataQueryPtr
    extends Ptr<NSMetadataQuery, NSMetadataQueryPtr> {
    }

    public static class Notifications {
        public static NSObject observeDidStartGathering(NSMetadataQuery object, final VoidBlock2<NSMetadataQuery, NSMetadataQueryUpdatedItems> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSMetadataQuery.DidStartGatheringNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSMetadataQuery)a.getObject()), (Object)new NSMetadataQueryUpdatedItems(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeGatheringProgress(NSMetadataQuery object, final VoidBlock2<NSMetadataQuery, NSMetadataQueryUpdatedItems> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSMetadataQuery.GatheringProgressNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSMetadataQuery)a.getObject()), (Object)new NSMetadataQueryUpdatedItems(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeDidFinishGathering(NSMetadataQuery object, final VoidBlock2<NSMetadataQuery, NSMetadataQueryUpdatedItems> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSMetadataQuery.DidFinishGatheringNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSMetadataQuery)a.getObject()), (Object)new NSMetadataQueryUpdatedItems(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeDidUpdate(NSMetadataQuery object, final VoidBlock2<NSMetadataQuery, NSMetadataQueryUpdatedItems> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSMetadataQuery.DidUpdateNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSMetadataQuery)a.getObject()), (Object)new NSMetadataQueryUpdatedItems(a.getUserInfo()));
                }
            });
        }
    }
}

