/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSMetadataItemAttribute;
import org.robovm.apple.foundation.NSMetadataItemDownloadingStatus;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSMetadataItemAttributes {
    private NSDictionary<NSString, NSObject> data;

    protected NSMetadataItemAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSObject get(String attribute) {
        return this.data.get(new NSString(attribute));
    }

    public NSObject get(NSMetadataItemAttribute attribute) {
        return this.data.get(attribute.value());
    }

    public boolean contains(String attribute) {
        return this.data.containsKey(new NSString(attribute));
    }

    public boolean contains(NSMetadataItemAttribute attribute) {
        return this.data.containsKey(attribute.value());
    }

    public String getFSName() {
        if (this.contains(NSMetadataItemAttribute.FSName)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.FSName);
            return val.toString();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.contains(NSMetadataItemAttribute.DisplayName)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.DisplayName);
            return val.toString();
        }
        return null;
    }

    public NSURL getURL() {
        if (this.contains(NSMetadataItemAttribute.URL)) {
            NSURL val = (NSURL)this.get(NSMetadataItemAttribute.URL);
            return val;
        }
        return null;
    }

    public String getPath() {
        if (this.contains(NSMetadataItemAttribute.Path)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.Path);
            return val.toString();
        }
        return null;
    }

    public long getFSSize() {
        if (this.contains(NSMetadataItemAttribute.FSSize)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.FSSize);
            return val.longValue();
        }
        return 0L;
    }

    public NSDate getFSCreationDate() {
        if (this.contains(NSMetadataItemAttribute.FSCreationDate)) {
            NSDate val = (NSDate)this.get(NSMetadataItemAttribute.FSCreationDate);
            return val;
        }
        return null;
    }

    public NSDate getFSContentChangeDate() {
        if (this.contains(NSMetadataItemAttribute.FSContentChangeDate)) {
            NSDate val = (NSDate)this.get(NSMetadataItemAttribute.FSContentChangeDate);
            return val;
        }
        return null;
    }

    public boolean isUbiquitous() {
        if (this.contains(NSMetadataItemAttribute.IsUbiquitous)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsUbiquitous);
            return val.booleanValue();
        }
        return false;
    }

    public boolean hasUnresolvedConflicts() {
        if (this.contains(NSMetadataItemAttribute.HasUnresolvedConflicts)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.HasUnresolvedConflicts);
            return val.booleanValue();
        }
        return false;
    }

    @Deprecated
    public boolean isDownloaded() {
        if (this.contains(NSMetadataItemAttribute.IsDownloaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsDownloaded);
            return val.booleanValue();
        }
        return false;
    }

    public NSMetadataItemDownloadingStatus getDownloadingStatus() {
        if (this.contains(NSMetadataItemAttribute.DownloadingStatus)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.DownloadingStatus);
            return NSMetadataItemDownloadingStatus.valueOf(val);
        }
        return null;
    }

    public boolean isDownloading() {
        if (this.contains(NSMetadataItemAttribute.IsDownloading)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsDownloading);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isUploaded() {
        if (this.contains(NSMetadataItemAttribute.IsUploaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsUploaded);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isUploading() {
        if (this.contains(NSMetadataItemAttribute.IsUploading)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsUploading);
            return val.booleanValue();
        }
        return false;
    }

    public double getPercentDownloaded() {
        if (this.contains(NSMetadataItemAttribute.PercentDownloaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.PercentDownloaded);
            return val.doubleValue();
        }
        return 0.0;
    }

    public double getPercentUploaded() {
        if (this.contains(NSMetadataItemAttribute.PercentUploaded)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.PercentUploaded);
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSError getDownloadingError() {
        if (this.contains(NSMetadataItemAttribute.DownloadingError)) {
            NSError val = (NSError)this.get(NSMetadataItemAttribute.DownloadingError);
            return val;
        }
        return null;
    }

    public NSError getUploadingError() {
        if (this.contains(NSMetadataItemAttribute.UploadingError)) {
            NSError val = (NSError)this.get(NSMetadataItemAttribute.UploadingError);
            return val;
        }
        return null;
    }

    public double getContentRelevance() {
        if (this.contains(NSMetadataItemAttribute.ContentRelevance)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.ContentRelevance);
            return val.doubleValue();
        }
        return 0.0;
    }

    public boolean isDownloadRequested() {
        if (this.contains(NSMetadataItemAttribute.DownloadRequested)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.DownloadRequested);
            return val.booleanValue();
        }
        return false;
    }

    public boolean isExternalDocument() {
        if (this.contains(NSMetadataItemAttribute.IsExternalDocument)) {
            NSNumber val = (NSNumber)this.get(NSMetadataItemAttribute.IsExternalDocument);
            return val.booleanValue();
        }
        return false;
    }

    public String getContainerDisplayName() {
        if (this.contains(NSMetadataItemAttribute.ContainerDisplayName)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.ContainerDisplayName);
            return val.toString();
        }
        return null;
    }

    public NSURL getURLInLocalContainer() {
        if (this.contains(NSMetadataItemAttribute.URLInLocalContainer)) {
            NSURL val = (NSURL)this.get(NSMetadataItemAttribute.URLInLocalContainer);
            return val;
        }
        return null;
    }

    public String getContentType() {
        if (this.contains(NSMetadataItemAttribute.ContentType)) {
            NSString val = (NSString)this.get(NSMetadataItemAttribute.ContentType);
            return val.toString();
        }
        return null;
    }

    public List<String> getContentTypeTree() {
        if (this.contains(NSMetadataItemAttribute.ContentTypeTree)) {
            NSArray val = (NSArray)this.get(NSMetadataItemAttribute.ContentTypeTree);
            return val.asStringList();
        }
        return null;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSMetadataItemAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSMetadataItemAttributes toObject(Class<NSMetadataItemAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSMetadataItemAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSMetadataItemAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

