/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import java.util.Locale;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCharacterSet;
import org.robovm.apple.foundation.NSLocaleComponent;
import org.robovm.apple.foundation.NSLocaleComponents;
import org.robovm.apple.foundation.NSLocaleLanguageDirection;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSLocale
extends NSObject {
    protected NSLocale(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSLocale(String string) {
        super(null);
        this.initObject(this.init(string));
    }

    public NSLocale(Locale locale) {
        super(null);
        this.initObject(this.init(locale.toString()));
    }

    @Property(selector="localeIdentifier")
    public native String getLocaleIdentifier();

    public Locale toLocale() {
        String language = this.getLanguageCode();
        String country = this.getCountryCode();
        String variant = this.getVariantCode();
        if (language != null && country != null && variant != null) {
            return new Locale(language, country, variant);
        }
        if (language != null && country != null) {
            return new Locale(language, country);
        }
        if (language != null) {
            return new Locale(language);
        }
        throw new IllegalArgumentException("Failed to convert NSLocale " + this.toString() + " to Java Locale");
    }

    public String getLanguageCode() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.LanguageCode);
        return val.toString();
    }

    public String getCountryCode() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CountryCode);
        return val.toString();
    }

    public String getScriptCode() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.ScriptCode);
        return val.toString();
    }

    public String getVariantCode() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.VariantCode);
        return val.toString();
    }

    public NSCharacterSet getExemplarCharacterSet() {
        NSCharacterSet val = (NSCharacterSet)this.getComponent(NSLocaleComponent.ExemplarCharacterSet);
        return val;
    }

    public String getCollationIdentifier() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CollationIdentifier);
        return val.toString();
    }

    public boolean isUsingMetricSystem() {
        NSNumber val = (NSNumber)this.getComponent(NSLocaleComponent.UsesMetricSystem);
        return val.booleanValue();
    }

    public String getMeasurementSystem() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.MeasurementSystem);
        return val.toString();
    }

    public String getDecimalSeparator() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.DecimalSeparator);
        return val.toString();
    }

    public String getGroupingSeparator() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.GroupingSeparator);
        return val.toString();
    }

    public String getCurrencySymbol() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CurrencySymbol);
        return val.toString();
    }

    public String getCurrencyCode() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CurrencyCode);
        return val.toString();
    }

    public String getCollatorIdentifier() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.CollatorIdentifier);
        return val.toString();
    }

    public String getQuotationBeginDelimiterKey() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.QuotationBeginDelimiterKey);
        return val.toString();
    }

    public String getQuotationEndDelimiterKey() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.QuotationEndDelimiterKey);
        return val.toString();
    }

    public String getAlternateQuotationBeginDelimiterKey() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.AlternateQuotationBeginDelimiterKey);
        return val.toString();
    }

    public String getAlternateQuotationEndDelimiterKey() {
        NSString val = (NSString)this.getComponent(NSLocaleComponent.AlternateQuotationEndDelimiterKey);
        return val.toString();
    }

    @GlobalValue(symbol="NSCurrentLocaleDidChangeNotification", optional=true)
    public static native NSString CurrentLocaleDidChangeNotification();

    @Method(selector="objectForKey:")
    public native NSObject getComponent(NSLocaleComponent var1);

    @Method(selector="displayNameForKey:value:")
    public native String getComponentDisplayName(NSLocaleComponent var1, NSObject var2);

    @Method(selector="initWithLocaleIdentifier:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="autoupdatingCurrentLocale")
    public static native NSLocale getAutoupdatingCurrentLocale();

    @Method(selector="currentLocale")
    public static native NSLocale getCurrentLocale();

    @Method(selector="systemLocale")
    public static native NSLocale getSystemLocale();

    @Method(selector="availableLocaleIdentifiers")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getAvailableLocaleIdentifiers();

    @Method(selector="ISOLanguageCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getISOLanguageCodes();

    @Method(selector="ISOCountryCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getISOCountryCodes();

    @Method(selector="ISOCurrencyCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getISOCurrencyCodes();

    @Method(selector="commonISOCurrencyCodes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getCommonISOCurrencyCodes();

    @Method(selector="preferredLanguages")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getPreferredLanguages();

    @Method(selector="componentsFromLocaleIdentifier:")
    public static native NSLocaleComponents getComponentsFromLocaleIdentifier(String var0);

    @Method(selector="localeIdentifierFromComponents:")
    public static native String getLocaleIdentifierFromComponents(NSLocaleComponents var0);

    @Method(selector="canonicalLocaleIdentifierFromString:")
    public static native String getCanonicalLocaleIdentifier(String var0);

    @Method(selector="canonicalLanguageIdentifierFromString:")
    public static native String getCanonicalLanguageIdentifier(String var0);

    @Method(selector="localeIdentifierFromWindowsLocaleCode:")
    public static native String getLocaleIdentifierFromWindowsLocaleCode(int var0);

    @Method(selector="windowsLocaleCodeFromLocaleIdentifier:")
    public static native int getWindowsLocaleCodeFromLocaleIdentifier(String var0);

    @Method(selector="characterDirectionForLanguage:")
    public static native NSLocaleLanguageDirection getCharacterDirection(String var0);

    @Method(selector="lineDirectionForLanguage:")
    public static native NSLocaleLanguageDirection getLineDirection(String var0);

    static {
        ObjCRuntime.bind(NSLocale.class);
    }

    public static class NSLocalePtr
    extends Ptr<NSLocale, NSLocalePtr> {
    }

    public static class Notifications {
        public static NSObject observeCurrentLocaleDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSLocale.CurrentLocaleDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

