/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSInputStream;
import org.robovm.apple.foundation.NSJSONReadingOptions;
import org.robovm.apple.foundation.NSJSONWritingOptions;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOutputStream;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSJSONSerialization
extends NSObject {
    public NSJSONSerialization() {
    }

    protected NSJSONSerialization(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="isValidJSONObject:")
    public static native boolean isValidJSONObject(NSObject var0);

    public static NSData createJSONData(NSObject obj, NSJSONWritingOptions opt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = NSJSONSerialization.createJSONData(obj, opt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="dataWithJSONObject:options:error:")
    private static native NSData createJSONData(NSObject var0, NSJSONWritingOptions var1, NSError.NSErrorPtr var2);

    public static NSObject createJSONObject(NSData data, NSJSONReadingOptions opt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSObject result = NSJSONSerialization.createJSONObject(data, opt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="JSONObjectWithData:options:error:")
    private static native NSObject createJSONObject(NSData var0, NSJSONReadingOptions var1, NSError.NSErrorPtr var2);

    @MachineSizedSInt
    public static long writeJSONObject(NSObject obj, NSOutputStream stream, NSJSONWritingOptions opt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long result = NSJSONSerialization.writeJSONObject(obj, stream, opt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeJSONObject:toStream:options:error:")
    @MachineSizedSInt
    private static native long writeJSONObject(NSObject var0, NSOutputStream var1, NSJSONWritingOptions var2, NSError.NSErrorPtr var3);

    public static NSObject readJSONObject(NSInputStream stream, NSJSONReadingOptions opt) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSObject result = NSJSONSerialization.readJSONObject(stream, opt, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="JSONObjectWithStream:options:error:")
    private static native NSObject readJSONObject(NSInputStream var0, NSJSONReadingOptions var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(NSJSONSerialization.class);
    }

    public static class NSJSONSerializationPtr
    extends Ptr<NSJSONSerialization, NSJSONSerializationPtr> {
    }
}

