/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSValue;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSItemProviderOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected NSItemProviderOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSItemProviderOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSObject get(String key) {
        if (this.contains(key)) {
            return this.data.get(new NSString(key));
        }
        return null;
    }

    public NSItemProviderOptions put(String key, NSObject value) {
        this.data.put(new NSString(key), value);
        return this;
    }

    public boolean contains(String key) {
        return this.data.containsKey(new NSString(key));
    }

    public CGSize getPreferredImageSize() {
        if (this.data.containsKey(NSItemProviderOptions.PreferredImageSizeKey())) {
            NSValue val = (NSValue)this.data.get(NSItemProviderOptions.PreferredImageSizeKey());
            return val.sizeValue();
        }
        return null;
    }

    public NSItemProviderOptions setPreferredImageSize(CGSize size) {
        this.data.put(NSItemProviderOptions.PreferredImageSizeKey(), NSValue.valueOf(size));
        return this;
    }

    @GlobalValue(symbol="NSItemProviderPreferredImageSizeKey", optional=true)
    protected static native NSString PreferredImageSizeKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSItemProviderOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSItemProviderOptions toObject(Class<NSItemProviderOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSItemProviderOptions(o);
        }

        @MarshalsPointer
        public static long toNative(NSItemProviderOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

