/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.nio.ByteBuffer;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSMutableData;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSStream;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.VM;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSInputStream
extends NSStream {
    public NSInputStream() {
    }

    protected NSInputStream(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSInputStream(NSData data) {
        super(null);
        this.initObject(this.init(data));
    }

    public NSInputStream(NSURL url) {
        super(null);
        this.initObject(this.init(url));
    }

    public NSInputStream(String path) {
        super(null);
        this.initObject(this.init(path));
    }

    @Property(selector="hasBytesAvailable")
    public native boolean hasBytesAvailable();

    public long read(BytePtr buffer, long len) {
        return this.read(buffer.getHandle(), len);
    }

    public long read(ByteBuffer bytes) {
        long handle = NSData.getEffectiveAddress(bytes) + (long)bytes.position();
        return this.read(handle, (long)bytes.remaining());
    }

    public long read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    public long read(byte[] bytes, int offset, int length) {
        NSMutableData.checkOffsetAndCount(bytes.length, offset, length);
        if (length == 0) {
            return 0L;
        }
        return this.read(VM.getArrayValuesAddress((Object)bytes) + (long)offset, (long)length);
    }

    @Method(selector="read:maxLength:")
    @MachineSizedSInt
    protected native long read(@Pointer long var1, @MachineSizedUInt long var3);

    @Method(selector="initWithData:")
    @Pointer
    protected native long init(NSData var1);

    @Method(selector="initWithURL:")
    @Pointer
    protected native long init(NSURL var1);

    @Method(selector="initWithFileAtPath:")
    @Pointer
    protected native long init(String var1);

    static {
        ObjCRuntime.bind(NSInputStream.class);
    }

    public static class NSInputStreamPtr
    extends Ptr<NSInputStream, NSInputStreamPtr> {
    }
}

