/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSCoding;
import org.robovm.apple.foundation.NSEnumerator;
import org.robovm.apple.foundation.NSFastEnumeration;
import org.robovm.apple.foundation.NSHashTableOptions;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSHashTable<T extends NSObject>
extends NSObject
implements NSCoding,
NSFastEnumeration,
Set<T> {
    private AbstractSet<T> adapter = this.createAdapter();

    public NSHashTable() {
    }

    protected NSHashTable(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSHashTable(NSHashTableOptions options, @MachineSizedUInt long initialCapacity) {
        super(null);
        this.initObject(this.init(options, initialCapacity));
    }

    public NSHashTable(NSCoder aDecoder) {
        super(null);
        this.initObject(this.init(aDecoder));
    }

    private static void checkNull(Object o) {
        if (o == null) {
            throw new NullPointerException("null values are not allowed in NSHashTable. Use NSNull instead.");
        }
    }

    public NSHashTable(Collection<T> c) {
        this.addAll((Collection<? extends T>)c);
    }

    public NSHashTable(T ... objects) {
        for (T obj : objects) {
            this.add(obj);
        }
    }

    public NSHashTable(Collection<T> c, NSHashTableOptions options, @MachineSizedUInt long initialCapacity) {
        super(null);
        this.initObject(this.init(options, initialCapacity));
        this.addAll((Collection<? extends T>)c);
    }

    @Property(selector="count")
    @MachineSizedUInt
    protected native long getCount();

    @Property(selector="allObjects")
    public native NSArray<T> getValues();

    @Property(selector="anyObject")
    public native T any();

    @Property(selector="setRepresentation")
    public native NSSet<T> asSet();

    protected AbstractSet<T> createAdapter() {
        return new SetAdapter(this);
    }

    @Override
    protected void afterMarshaled(int flags) {
        if (this.adapter == null) {
            this.adapter = this.createAdapter();
        }
        super.afterMarshaled(flags);
    }

    @Override
    public boolean add(T e) {
        return this.adapter.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.adapter.addAll(c);
    }

    @Override
    public void clear() {
        this.adapter.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.adapter.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.adapter.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.adapter.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.adapter.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.adapter.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.adapter.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.adapter.retainAll(c);
    }

    @Override
    public int size() {
        return this.adapter.size();
    }

    @Override
    public Object[] toArray() {
        return this.adapter.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.adapter.toArray(a);
    }

    @Method(selector="initWithOptions:capacity:")
    @Pointer
    protected native long init(NSHashTableOptions var1, @MachineSizedUInt long var2);

    @Method(selector="member:")
    protected native NSObject isMember(NSObject var1);

    @Method(selector="objectEnumerator")
    private native NSEnumerator<T> getObjectEnumerator();

    @Method(selector="addObject:")
    private native void addObject(NSObject var1);

    @Method(selector="removeObject:")
    private native void removeObject(NSObject var1);

    @Method(selector="removeAllObjects")
    private native void removeAllObjects();

    @Method(selector="containsObject:")
    private native boolean containsObject(NSObject var1);

    @Method(selector="intersectsHashTable:")
    public native boolean intersects(NSHashTable<T> var1);

    @Method(selector="isEqualToHashTable:")
    public native boolean equalsTo(NSHashTable<T> var1);

    @Method(selector="isSubsetOfHashTable:")
    public native boolean isSubsetOf(NSHashTable<T> var1);

    @Method(selector="intersectHashTable:")
    public native void intersect(NSHashTable<T> var1);

    @Method(selector="unionHashTable:")
    public native void union(NSHashTable<T> var1);

    @Method(selector="minusHashTable:")
    public native void minus(NSHashTable<T> var1);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    static {
        ObjCRuntime.bind(NSHashTable.class);
    }

    static class SetAdapter<U extends NSObject>
    extends AbstractSet<U> {
        protected final NSHashTable<U> set;

        SetAdapter(NSHashTable<U> set) {
            this.set = set;
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof NSObject) {
                return this.set.isMember((NSObject)o) != null;
            }
            return false;
        }

        @Override
        public Iterator<U> iterator() {
            return new NSEnumerator.Iterator<U>(((NSHashTable)this.set).getObjectEnumerator()){

                @Override
                void remove(int index, U o) {
                    SetAdapter.this.set.removeObject(o);
                }
            };
        }

        @Override
        public int size() {
            return (int)this.set.getCount();
        }

        @Override
        public boolean add(U e) {
            NSHashTable.checkNull(e);
            boolean replaced = this.contains(e);
            ((NSHashTable)this.set).addObject(e);
            return replaced;
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                ((NSHashTable)this.set).removeObject((NSObject)o);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            ((NSHashTable)this.set).removeAllObjects();
        }
    }

    public static class NSHashTablePtr<T extends NSObject>
    extends Ptr<NSHashTable<T>, NSHashTablePtr<T>> {
    }
}

