/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSHTTPCookieAttribute;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSHTTPCookieAttributes {
    private NSDictionary<NSString, NSObject> data;

    protected NSHTTPCookieAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSHTTPCookieAttributes() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSHTTPCookieAttributes set(NSHTTPCookieAttribute attribute, NSObject value) {
        this.data.put(attribute.value(), value);
        return this;
    }

    public NSObject get(NSHTTPCookieAttribute attribute) {
        return this.data.get(attribute.value());
    }

    public boolean contains(NSHTTPCookieAttribute attribute) {
        return this.data.containsKey(attribute.value());
    }

    public String getComment() {
        if (this.contains(NSHTTPCookieAttribute.Comment)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Comment);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setComment(String comment) {
        this.set(NSHTTPCookieAttribute.Comment, new NSString(comment));
        return this;
    }

    public NSURL getCommentURL() {
        if (this.contains(NSHTTPCookieAttribute.CommentURL)) {
            NSURL val = (NSURL)this.get(NSHTTPCookieAttribute.CommentURL);
            return val;
        }
        return null;
    }

    public NSHTTPCookieAttributes setCommentURL(NSURL url) {
        this.set(NSHTTPCookieAttribute.CommentURL, url);
        return this;
    }

    public boolean isDiscard() {
        if (this.contains(NSHTTPCookieAttribute.Discard)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Discard);
            return val.toString().equals("TRUE");
        }
        return this.getVersion() >= 1 && this.getMaximumAge() == 0;
    }

    public NSHTTPCookieAttributes setDiscard(boolean discard) {
        this.set(NSHTTPCookieAttribute.Discard, discard ? new NSString("TRUE") : new NSString("FALSE"));
        return this;
    }

    public String getDomain() {
        if (this.contains(NSHTTPCookieAttribute.Domain)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Domain);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setDomain(String domain) {
        this.set(NSHTTPCookieAttribute.Domain, new NSString(domain));
        return this;
    }

    public NSDate getExpireDate() {
        if (this.contains(NSHTTPCookieAttribute.Expires)) {
            NSDate val = (NSDate)this.get(NSHTTPCookieAttribute.Expires);
            return val;
        }
        return null;
    }

    public NSHTTPCookieAttributes setExpireDate(NSDate expires) {
        this.set(NSHTTPCookieAttribute.Expires, expires);
        return this;
    }

    public int getMaximumAge() {
        if (this.contains(NSHTTPCookieAttribute.MaximumAge)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.MaximumAge);
            return Integer.valueOf(val.toString());
        }
        return 0;
    }

    public NSHTTPCookieAttributes setMaximumAge(int age) {
        this.set(NSHTTPCookieAttribute.MaximumAge, new NSString(String.valueOf(age)));
        return this;
    }

    public String getName() {
        if (this.contains(NSHTTPCookieAttribute.Name)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Name);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setName(String name) {
        this.set(NSHTTPCookieAttribute.Name, new NSString(name));
        return this;
    }

    public NSURL getOriginURL() {
        if (this.contains(NSHTTPCookieAttribute.OriginURL)) {
            NSURL val = (NSURL)this.get(NSHTTPCookieAttribute.OriginURL);
            return val;
        }
        return null;
    }

    public NSHTTPCookieAttributes setOriginURL(NSURL url) {
        this.set(NSHTTPCookieAttribute.OriginURL, url);
        return this;
    }

    public String getPath() {
        if (this.contains(NSHTTPCookieAttribute.Path)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Path);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setPath(String path) {
        this.set(NSHTTPCookieAttribute.Path, new NSString(path));
        return this;
    }

    public String getPort() {
        if (this.contains(NSHTTPCookieAttribute.Port)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Port);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setPort(String port) {
        this.set(NSHTTPCookieAttribute.Port, new NSString(port));
        return this;
    }

    public boolean isSecure() {
        return this.contains(NSHTTPCookieAttribute.Secure);
    }

    public NSHTTPCookieAttributes setSecure(boolean secure) {
        this.set(NSHTTPCookieAttribute.Secure, secure ? new NSString("secure") : null);
        return this;
    }

    public String getValue() {
        if (this.contains(NSHTTPCookieAttribute.Value)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Value);
            return val.toString();
        }
        return null;
    }

    public NSHTTPCookieAttributes setValue(String value) {
        this.set(NSHTTPCookieAttribute.Value, new NSString(value));
        return this;
    }

    public int getVersion() {
        if (this.contains(NSHTTPCookieAttribute.Version)) {
            NSString val = (NSString)this.get(NSHTTPCookieAttribute.Version);
            return Integer.valueOf(val.toString());
        }
        return 0;
    }

    public NSHTTPCookieAttributes setVersion(int version) {
        this.set(NSHTTPCookieAttribute.Version, new NSString(String.valueOf(version)));
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSHTTPCookieAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSHTTPCookieAttributes toObject(Class<NSHTTPCookieAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSHTTPCookieAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSHTTPCookieAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

