/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSFileSystemAttribute;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSFileSystemAttributes {
    private NSDictionary<NSString, NSObject> data;

    protected NSFileSystemAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSFileSystemAttributes() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSFileSystemAttributes set(NSFileSystemAttribute attribute, NSObject value) {
        this.data.put(attribute.value(), value);
        return this;
    }

    public NSObject get(NSFileSystemAttribute attribute) {
        return this.data.get(attribute.value());
    }

    public boolean contains(NSFileSystemAttribute attribute) {
        return this.data.containsKey(attribute.value());
    }

    public long getSize() {
        if (this.contains(NSFileSystemAttribute.Size)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.Size);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setSize(long size) {
        this.set(NSFileSystemAttribute.Size, NSNumber.valueOf(size));
        return this;
    }

    public long getFreeSize() {
        if (this.contains(NSFileSystemAttribute.FreeSize)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.FreeSize);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setFreeSize(long size) {
        this.set(NSFileSystemAttribute.FreeSize, NSNumber.valueOf(size));
        return this;
    }

    public long getNodes() {
        if (this.contains(NSFileSystemAttribute.Nodes)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.Nodes);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setNodes(long nodes) {
        this.set(NSFileSystemAttribute.Nodes, NSNumber.valueOf(nodes));
        return this;
    }

    public long getFreeNodes() {
        if (this.contains(NSFileSystemAttribute.FreeNodes)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.FreeNodes);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setFreeNodes(long nodes) {
        this.set(NSFileSystemAttribute.FreeNodes, NSNumber.valueOf(nodes));
        return this;
    }

    public long getSystemNumber() {
        if (this.contains(NSFileSystemAttribute.Number)) {
            NSNumber val = (NSNumber)this.get(NSFileSystemAttribute.Number);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileSystemAttributes setSystemNumber(long number) {
        this.set(NSFileSystemAttribute.Number, NSNumber.valueOf(number));
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSFileSystemAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSFileSystemAttributes toObject(Class<NSFileSystemAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSFileSystemAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSFileSystemAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

