/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSFileAttribute;
import org.robovm.apple.foundation.NSFileProtection;
import org.robovm.apple.foundation.NSFileType;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSFileAttributes {
    private NSDictionary<NSString, NSObject> data;

    protected NSFileAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSFileAttributes() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSFileAttributes set(NSFileAttribute attribute, NSObject value) {
        this.data.put(attribute.value(), value);
        return this;
    }

    public NSObject get(NSFileAttribute attribute) {
        return this.data.get(attribute.value());
    }

    public boolean contains(NSFileAttribute attribute) {
        return this.data.containsKey(attribute.value());
    }

    public NSFileType getType() {
        if (this.contains(NSFileAttribute.Type)) {
            NSString val = (NSString)this.get(NSFileAttribute.Type);
            return NSFileType.valueOf(val);
        }
        return null;
    }

    public NSFileAttributes setType(NSFileType type) {
        this.set(NSFileAttribute.Type, type.value());
        return this;
    }

    public long getSize() {
        if (this.contains(NSFileAttribute.Size)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.Size);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setSize(long size) {
        this.set(NSFileAttribute.Size, NSNumber.valueOf(size));
        return this;
    }

    public NSDate getModificationDate() {
        if (this.contains(NSFileAttribute.ModificationDate)) {
            NSDate val = (NSDate)this.get(NSFileAttribute.ModificationDate);
            return val;
        }
        return null;
    }

    public NSFileAttributes setModificationDate(NSDate date) {
        this.set(NSFileAttribute.ModificationDate, date);
        return this;
    }

    public long getReferenceCount() {
        if (this.contains(NSFileAttribute.ReferenceCount)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.ReferenceCount);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setReferenceCount(long count) {
        this.set(NSFileAttribute.ReferenceCount, NSNumber.valueOf(count));
        return this;
    }

    public long getDeviceIdentifier() {
        if (this.contains(NSFileAttribute.DeviceIdentifier)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.DeviceIdentifier);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setDeviceIdentifier(long id) {
        this.set(NSFileAttribute.DeviceIdentifier, NSNumber.valueOf(id));
        return this;
    }

    public String getOwnerAccountName() {
        if (this.contains(NSFileAttribute.OwnerAccountName)) {
            NSString val = (NSString)this.get(NSFileAttribute.OwnerAccountName);
            return val.toString();
        }
        return null;
    }

    public NSFileAttributes setOwnerAccountName(String name) {
        this.set(NSFileAttribute.OwnerAccountName, new NSString(name));
        return this;
    }

    public String getGroupOwnerAccountName() {
        if (this.contains(NSFileAttribute.GroupOwnerAccountName)) {
            NSString val = (NSString)this.get(NSFileAttribute.GroupOwnerAccountName);
            return val.toString();
        }
        return null;
    }

    public NSFileAttributes setGroupOwnerAccountName(String name) {
        this.set(NSFileAttribute.GroupOwnerAccountName, new NSString(name));
        return this;
    }

    public short getPosixPermissions() {
        if (this.contains(NSFileAttribute.PosixPermissions)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.PosixPermissions);
            return val.shortValue();
        }
        return 0;
    }

    public NSFileAttributes setPosixPermissions(short permissions) {
        this.set(NSFileAttribute.PosixPermissions, NSNumber.valueOf(permissions));
        return this;
    }

    public long getSystemFileNumber() {
        if (this.contains(NSFileAttribute.SystemFileNumber)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.SystemFileNumber);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setSystemFileNumber(long number) {
        this.set(NSFileAttribute.SystemFileNumber, NSNumber.valueOf(number));
        return this;
    }

    public boolean isExtensionHidden() {
        if (this.contains(NSFileAttribute.ExtensionHidden)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.ExtensionHidden);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setExtensionHidden(boolean hideExtension) {
        this.set(NSFileAttribute.ExtensionHidden, NSNumber.valueOf(hideExtension));
        return this;
    }

    public long getHFSCreatorCode() {
        if (this.contains(NSFileAttribute.HFSCreatorCode)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.HFSCreatorCode);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setHFSCreatorCode(long code) {
        this.set(NSFileAttribute.HFSCreatorCode, NSNumber.valueOf(code));
        return this;
    }

    public long getHFSTypeCode() {
        if (this.contains(NSFileAttribute.HFSTypeCode)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.HFSTypeCode);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setHFSTypeCode(long code) {
        this.set(NSFileAttribute.HFSTypeCode, NSNumber.valueOf(code));
        return this;
    }

    public boolean isImmutable() {
        if (this.contains(NSFileAttribute.Immutable)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.Immutable);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setImmutable(boolean immutable) {
        this.set(NSFileAttribute.Immutable, NSNumber.valueOf(immutable));
        return this;
    }

    public boolean isAppendOnly() {
        if (this.contains(NSFileAttribute.AppendOnly)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.AppendOnly);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setAppendOnly(boolean appendOnly) {
        this.set(NSFileAttribute.AppendOnly, NSNumber.valueOf(appendOnly));
        return this;
    }

    public NSDate getCreationDate() {
        if (this.contains(NSFileAttribute.CreationDate)) {
            NSDate val = (NSDate)this.get(NSFileAttribute.CreationDate);
            return val;
        }
        return null;
    }

    public NSFileAttributes setCreationDate(NSDate date) {
        this.set(NSFileAttribute.CreationDate, date);
        return this;
    }

    public long getOwnerAccountID() {
        if (this.contains(NSFileAttribute.OwnerAccountID)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.OwnerAccountID);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setOwnerAccountID(long id) {
        this.set(NSFileAttribute.OwnerAccountID, NSNumber.valueOf(id));
        return this;
    }

    public long getGroupOwnerAccountID() {
        if (this.contains(NSFileAttribute.GroupOwnerAccountID)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.GroupOwnerAccountID);
            return val.longValue();
        }
        return 0L;
    }

    public NSFileAttributes setGroupOwnerAccountID(long id) {
        this.set(NSFileAttribute.GroupOwnerAccountID, NSNumber.valueOf(id));
        return this;
    }

    public boolean isBusy() {
        if (this.contains(NSFileAttribute.Busy)) {
            NSNumber val = (NSNumber)this.get(NSFileAttribute.Busy);
            return val.booleanValue();
        }
        return false;
    }

    public NSFileAttributes setBusy(boolean busy) {
        this.set(NSFileAttribute.Busy, NSNumber.valueOf(busy));
        return this;
    }

    public NSFileProtection getProtection() {
        if (this.contains(NSFileAttribute.ProtectionKey)) {
            NSString val = (NSString)this.get(NSFileAttribute.ProtectionKey);
            return NSFileProtection.valueOf(val);
        }
        return null;
    }

    public NSFileAttributes setProtection(NSFileProtection protection) {
        this.set(NSFileAttribute.ProtectionKey, protection.value());
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSFileAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSFileAttributes toObject(Class<NSFileAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSFileAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(NSFileAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

