/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCocoaErrorUserInfoKey;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorRecoveryAttempting;
import org.robovm.apple.foundation.NSErrorUserInfoKey;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSStringEncoding;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="Foundation")
public class NSErrorUserInfo {
    private CFDictionary data;

    protected NSErrorUserInfo(CFDictionary data) {
        this.data = data;
    }

    public NSErrorUserInfo() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public NSErrorUserInfo set(String attribute, NSObject value) {
        this.data.put((NativeObject)new NSString(attribute), (NativeObject)value);
        return this;
    }

    public NSErrorUserInfo set(NSErrorUserInfoKey attribute, NSObject value) {
        this.data.put((NativeObject)attribute.value(), (NativeObject)value);
        return this;
    }

    public NSObject get(String attribute) {
        return this.data.get((NativeObject)new NSString(attribute), NSObject.class);
    }

    public <T extends NativeObject> T get(String attribute, Class<T> type) {
        return this.data.get((NativeObject)new NSString(attribute), type);
    }

    public NSObject get(NSErrorUserInfoKey attribute) {
        return this.data.get((NativeObject)attribute.value(), NSObject.class);
    }

    public <T extends NativeObject> T get(NSErrorUserInfoKey attribute, Class<T> type) {
        return this.data.get((NativeObject)attribute.value(), type);
    }

    public boolean contains(String attribute) {
        return this.data.containsKey((NativeObject)new NSString(attribute));
    }

    public boolean contains(NSErrorUserInfoKey attribute) {
        return this.data.containsKey((NativeObject)attribute.value());
    }

    public NSError getUnderlyingError() {
        if (this.contains(NSCocoaErrorUserInfoKey.UnderlyingError)) {
            NSError val = (NSError)this.get(NSCocoaErrorUserInfoKey.UnderlyingError);
            return val;
        }
        return null;
    }

    public NSErrorUserInfo setUnderlyingError(NSError error) {
        this.set(NSCocoaErrorUserInfoKey.UnderlyingError, (NSObject)error);
        return this;
    }

    public String getLocalizedDescription() {
        if (this.contains(NSCocoaErrorUserInfoKey.LocalizedDescription)) {
            NSString val = (NSString)this.get(NSCocoaErrorUserInfoKey.LocalizedDescription);
            return val.toString();
        }
        return null;
    }

    public NSErrorUserInfo setLocalizedDescription(String description) {
        this.set(NSCocoaErrorUserInfoKey.LocalizedDescription, (NSObject)new NSString(description));
        return this;
    }

    public String getLocalizedFailureReason() {
        if (this.contains(NSCocoaErrorUserInfoKey.LocalizedFailureReason)) {
            NSString val = (NSString)this.get(NSCocoaErrorUserInfoKey.LocalizedFailureReason);
            return val.toString();
        }
        return null;
    }

    public NSErrorUserInfo setLocalizedFailureReason(String reason) {
        this.set(NSCocoaErrorUserInfoKey.LocalizedFailureReason, (NSObject)new NSString(reason));
        return this;
    }

    public String getLocalizedRecoverySuggestion() {
        if (this.contains(NSCocoaErrorUserInfoKey.LocalizedRecoverySuggestion)) {
            NSString val = (NSString)this.get(NSCocoaErrorUserInfoKey.LocalizedRecoverySuggestion);
            return val.toString();
        }
        return null;
    }

    public NSErrorUserInfo setLocalizedRecoverySuggestion(String suggestion) {
        this.set(NSCocoaErrorUserInfoKey.LocalizedRecoverySuggestion, (NSObject)new NSString(suggestion));
        return this;
    }

    public List<String> getLocalizedRecoveryOptions() {
        if (this.contains(NSCocoaErrorUserInfoKey.LocalizedRecoveryOptions)) {
            NSArray val = (NSArray)this.get(NSCocoaErrorUserInfoKey.LocalizedRecoveryOptions);
            return val.asStringList();
        }
        return null;
    }

    public NSErrorUserInfo setLocalizedRecoveryOptions(List<String> options) {
        this.set(NSCocoaErrorUserInfoKey.LocalizedRecoveryOptions, NSArray.fromStrings(options));
        return this;
    }

    public NSErrorRecoveryAttempting getRecoveryAttempter() {
        if (this.contains(NSCocoaErrorUserInfoKey.RecoveryAttempter)) {
            NSErrorRecoveryAttempting val = (NSErrorRecoveryAttempting)((Object)this.get(NSCocoaErrorUserInfoKey.RecoveryAttempter));
            return val;
        }
        return null;
    }

    public NSErrorUserInfo setRecoveryAttempter(NSErrorRecoveryAttempting recovery) {
        this.set(NSCocoaErrorUserInfoKey.RecoveryAttempter, (NSObject)((Object)recovery));
        return this;
    }

    public String getHelpAnchor() {
        if (this.contains(NSCocoaErrorUserInfoKey.HelpAnchor)) {
            NSString val = (NSString)this.get(NSCocoaErrorUserInfoKey.HelpAnchor);
            return val.toString();
        }
        return null;
    }

    public NSErrorUserInfo setHelpAnchor(String help) {
        this.set(NSCocoaErrorUserInfoKey.LocalizedRecoverySuggestion, (NSObject)new NSString(help));
        return this;
    }

    public NSStringEncoding getStringEncoding() {
        if (this.contains(NSCocoaErrorUserInfoKey.StringEncoding)) {
            NSNumber val = (NSNumber)this.get(NSCocoaErrorUserInfoKey.StringEncoding);
            return NSStringEncoding.valueOf(val.longValue());
        }
        return null;
    }

    public NSErrorUserInfo setStringEncoding(NSStringEncoding encoding) {
        this.set(NSCocoaErrorUserInfoKey.StringEncoding, (NSObject)NSNumber.valueOf(encoding.value()));
        return this;
    }

    public String getFilePath() {
        if (this.contains(NSCocoaErrorUserInfoKey.FilePath)) {
            NSString val = (NSString)this.get(NSCocoaErrorUserInfoKey.FilePath);
            return val.toString();
        }
        return null;
    }

    public NSErrorUserInfo setFilePath(String path) {
        this.set(NSCocoaErrorUserInfoKey.FilePath, (NSObject)new NSString(path));
        return this;
    }

    public NSURL getURL() {
        if (this.contains(NSCocoaErrorUserInfoKey.URL)) {
            NSURL val = (NSURL)this.get(NSCocoaErrorUserInfoKey.URL);
            return val;
        }
        return null;
    }

    public NSErrorUserInfo setURL(NSURL url) {
        this.set(NSCocoaErrorUserInfoKey.URL, (NSObject)url);
        return this;
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSErrorUserInfo.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSErrorUserInfo toObject(Class<NSErrorUserInfo> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSErrorUserInfo(o);
        }

        @MarshalsPointer
        public static long toNative(NSErrorUserInfo o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

