/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.io.File;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSBundleExecutableArchitectureType;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.NSBundleExtensions;
import org.robovm.apple.uikit.UINibLoadingOptions;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSBundle
extends NSObject {
    public NSBundle() {
    }

    protected NSBundle(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSBundle(NSURL url) {
        super(null);
        this.initObject(this.init(url));
    }

    public NSBundle(File file) {
        super(null);
        this.initObject(this.init(file.getAbsolutePath()));
    }

    @Property(selector="isLoaded")
    public native boolean isLoaded();

    @Property(selector="bundleURL")
    public native NSURL getBundleURL();

    @Property(selector="resourceURL")
    public native NSURL getResourceURL();

    @Property(selector="executableURL")
    public native NSURL getExecutableURL();

    @Property(selector="privateFrameworksURL")
    public native NSURL getPrivateFrameworksURL();

    @Property(selector="sharedFrameworksURL")
    public native NSURL getSharedFrameworksURL();

    @Property(selector="sharedSupportURL")
    public native NSURL getSharedSupportURL();

    @Property(selector="builtInPlugInsURL")
    public native NSURL getBuiltInPlugInsURL();

    @Property(selector="appStoreReceiptURL")
    public native NSURL getAppStoreReceiptURL();

    @Property(selector="bundlePath")
    public native String getBundlePath();

    @Property(selector="resourcePath")
    public native String getResourcePath();

    @Property(selector="executablePath")
    public native String getExecutablePath();

    @Property(selector="privateFrameworksPath")
    public native String getPrivateFrameworksPath();

    @Property(selector="sharedFrameworksPath")
    public native String getSharedFrameworksPath();

    @Property(selector="sharedSupportPath")
    public native String getSharedSupportPath();

    @Property(selector="builtInPlugInsPath")
    public native String getBuiltInPlugInsPath();

    @Property(selector="bundleIdentifier")
    public native String getBundleIdentifier();

    @Property(selector="infoDictionary")
    public native NSDictionary<?, ?> getInfoDictionary();

    @Property(selector="localizedInfoDictionary")
    public native NSDictionary<?, ?> getLocalizedInfoDictionary();

    @Property(selector="principalClass")
    public native Class<?> getPrincipalClass();

    @Property(selector="preferredLocalizations")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getPreferredLocalizations();

    @Property(selector="localizations")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getLocalizations();

    @Property(selector="developmentLocalization")
    public native String getDevelopmentLocalization();

    @Property(selector="executableArchitectures")
    @Marshaler(value=NSBundleExecutableArchitectureType.AsListMarshaler.class)
    public native List<NSBundleExecutableArchitectureType> getExecutableArchitectures();

    @WeaklyLinked
    public NSArray<?> loadNib(String name, NSObject owner, UINibLoadingOptions options) {
        return NSBundleExtensions.loadNib(this, name, owner, options);
    }

    @GlobalValue(symbol="NSBundleDidLoadNotification", optional=true)
    public static native NSString DidLoadNotification();

    @GlobalValue(symbol="NSLoadedClasses", optional=true)
    protected static native NSString LoadedClassesKey();

    @Method(selector="initWithPath:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="initWithURL:")
    @Pointer
    protected native long init(NSURL var1);

    public boolean preflight() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.preflight(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="preflightAndReturnError:")
    private native boolean preflight(NSError.NSErrorPtr var1);

    public boolean load() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.load(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="loadAndReturnError:")
    private native boolean load(NSError.NSErrorPtr var1);

    @Method(selector="URLForAuxiliaryExecutable:")
    public native NSURL findAuxiliaryExecutableURL(String var1);

    @Method(selector="pathForAuxiliaryExecutable:")
    public native String findAuxiliaryExecutablePath(String var1);

    @Method(selector="URLForResource:withExtension:")
    public native NSURL findResourceURL(String var1, String var2);

    @Method(selector="URLForResource:withExtension:subdirectory:")
    public native NSURL findResourceURL(String var1, String var2, String var3);

    @Method(selector="URLForResource:withExtension:subdirectory:localization:")
    public native NSURL findResourceURL(String var1, String var2, String var3, String var4);

    @Method(selector="URLsForResourcesWithExtension:subdirectory:")
    public native NSArray<NSURL> findResourceURLs(String var1, String var2);

    @Method(selector="URLsForResourcesWithExtension:subdirectory:localization:")
    public native NSArray<NSURL> findResourceURLs(String var1, String var2, String var3);

    @Method(selector="pathForResource:ofType:")
    public native String findResourcePath(String var1, String var2);

    @Method(selector="pathForResource:ofType:inDirectory:")
    public native String findResourcePath(String var1, String var2, String var3);

    @Method(selector="pathForResource:ofType:inDirectory:forLocalization:")
    public native String findResourcePath(String var1, String var2, String var3, String var4);

    @Method(selector="pathsForResourcesOfType:inDirectory:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> findResourcesPaths(String var1, String var2);

    @Method(selector="pathsForResourcesOfType:inDirectory:forLocalization:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> findResourcesPaths(String var1, String var2, String var3);

    @Method(selector="localizedStringForKey:value:table:")
    public native String getLocalizedString(String var1, String var2, String var3);

    @Method(selector="objectForInfoDictionaryKey:")
    public native NSObject getInfoDictionaryObject(String var1);

    @Method(selector="classNamed:")
    public native Class<?> getClassNamed(String var1);

    @Method(selector="mainBundle")
    public static native NSBundle getMainBundle();

    @Method(selector="bundleForClass:")
    public static native NSBundle getBundle(Class<?> var0);

    @Method(selector="bundleWithIdentifier:")
    public static native NSBundle getBundle(String var0);

    @Method(selector="allBundles")
    public static native NSArray<NSBundle> getAllBundles();

    @Method(selector="allFrameworks")
    public static native NSArray<NSBundle> getAllFrameworks();

    @Method(selector="URLForResource:withExtension:subdirectory:inBundleWithURL:")
    public static native NSURL findResourceURLInBundle(String var0, String var1, String var2, NSURL var3);

    @Method(selector="URLsForResourcesWithExtension:subdirectory:inBundleWithURL:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> findResourceURLsInBundle(String var0, String var1, NSURL var2);

    @Method(selector="pathForResource:ofType:inDirectory:")
    public static native String findResourcePathInBundle(String var0, String var1, String var2);

    @Method(selector="pathsForResourcesOfType:inDirectory:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> findResourcesPathsInBundle(String var0, String var1);

    @Method(selector="preferredLocalizationsFromArray:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getPreferredLocalizations(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var0);

    @Method(selector="preferredLocalizationsFromArray:forPreferences:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getPreferredLocalizations(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var0, @Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    static {
        ObjCRuntime.bind(NSBundle.class);
    }

    public static class NSBundlePtr
    extends Ptr<NSBundle, NSBundlePtr> {
    }

    public static class Notifications {
        public static NSObject observeDidLoad(NSBundle object, final VoidBlock2<NSBundle, List<String>> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSBundle.DidLoadNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    List<String> classes = null;
                    NSDictionary<NSString, NSObject> data = a.getUserInfo();
                    if (data.containsKey(NSBundle.LoadedClassesKey())) {
                        NSArray val = (NSArray)data.get(NSBundle.LoadedClassesKey());
                        classes = val.asStringList();
                    }
                    block.invoke((Object)((NSBundle)a.getObject()), classes);
                }
            });
        }
    }
}

