/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMTextMarkupAttribute;
import org.robovm.apple.coremedia.CMTextMarkupAttributes;
import org.robovm.apple.coretext.CTAttributedStringAttribute;
import org.robovm.apple.coretext.CTAttributedStringAttributes;
import org.robovm.apple.foundation.NSAttributedStringEnumerationOptions;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSFileWrapper;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRange;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.NSAttributedStringAttribute;
import org.robovm.apple.uikit.NSAttributedStringAttributes;
import org.robovm.apple.uikit.NSAttributedStringDocumentAttributes;
import org.robovm.apple.uikit.NSAttributedStringExtensions;
import org.robovm.apple.uikit.NSStringDrawingContext;
import org.robovm.apple.uikit.NSStringDrawingOptions;
import org.robovm.apple.uikit.NSTextAttachment;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.annotation.WeaklyLinked;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSAttributedString
extends NSObject {
    public NSAttributedString() {
    }

    protected NSAttributedString(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSAttributedString(String str) {
        super(null);
        this.initObject(this.init(str));
    }

    public NSAttributedString(String str, NSDictionary<NSString, NSObject> attrs) {
        super(null);
        this.initObject(this.init(str, attrs));
    }

    public NSAttributedString(NSAttributedString attrStr) {
        super(null);
        this.initObject(this.init(attrStr));
    }

    public NSAttributedString(String str, NSAttributedStringAttributes attrs) {
        super(null);
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        this.initObject(this.init(str, attrs.getDictionary()));
    }

    public NSAttributedString(String str, CMTextMarkupAttributes attrs) {
        super(null);
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        this.initObject(this.init(str, (NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
    }

    public NSAttributedString(String str, CTAttributedStringAttributes attrs) {
        super(null);
        if (attrs == null) {
            throw new NullPointerException("attrs");
        }
        this.initObject(this.init(str, (NSDictionary)attrs.getDictionary().as(NSDictionary.class)));
    }

    @Property(selector="string")
    public native String getString();

    @Property(selector="length")
    @MachineSizedUInt
    public native long length();

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NSAttributedString)) {
            return false;
        }
        return this.equalsTo((NSAttributedString)obj);
    }

    public NSObject getAttribute(String name, @MachineSizedUInt long location, NSRange range) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getAttribute(new NSString(name), location, range);
    }

    public NSObject getAttribute(NSAttributedStringAttribute attribute, @MachineSizedUInt long location, NSRange range) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        return this.getAttribute(attribute.value(), location, range);
    }

    public NSObject getAttribute(CMTextMarkupAttribute attribute, @MachineSizedUInt long location, NSRange range) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        return this.getAttribute((NSString)((CFString)attribute.value()).as(NSString.class), location, range);
    }

    public NSObject getAttribute(CTAttributedStringAttribute attribute, @MachineSizedUInt long location, NSRange range) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        return this.getAttribute((NSString)((CFString)attribute.value()).as(NSString.class), location, range);
    }

    public NSObject getAttribute(String name, @MachineSizedUInt long location, NSRange range, @ByVal NSRange rangeLimit) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getAttribute(new NSString(name), location, range, rangeLimit);
    }

    public NSObject getAttribute(NSAttributedStringAttribute attribute, @MachineSizedUInt long location, NSRange range, @ByVal NSRange rangeLimit) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        return this.getAttribute(attribute.value(), location, range, rangeLimit);
    }

    public NSObject getAttribute(CMTextMarkupAttribute attribute, @MachineSizedUInt long location, NSRange range, @ByVal NSRange rangeLimit) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        return this.getAttribute((NSString)((CFString)attribute.value()).as(NSString.class), location, range, rangeLimit);
    }

    public NSObject getAttribute(CTAttributedStringAttribute attribute, @MachineSizedUInt long location, NSRange range, @ByVal NSRange rangeLimit) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        return this.getAttribute((NSString)((CFString)attribute.value()).as(NSString.class), location, range, rangeLimit);
    }

    public NSAttributedStringAttributes getAttributes(long location, NSRange range) {
        return new NSAttributedStringAttributes(this.getAttributesDictionary(location, range));
    }

    public NSAttributedStringAttributes getAttributes(long location, NSRange range, NSRange rangeLimit) {
        return new NSAttributedStringAttributes(this.getAttributesDictionary(location, range, rangeLimit));
    }

    public CMTextMarkupAttributes getTextMarkupAttributes(long location, NSRange range) {
        return new CMTextMarkupAttributes((CFDictionary)this.getAttributesDictionary(location, range).as(CFDictionary.class));
    }

    public CMTextMarkupAttributes getTextMarkupAttributes(long location, NSRange range, NSRange rangeLimit) {
        return new CMTextMarkupAttributes((CFDictionary)this.getAttributesDictionary(location, range, rangeLimit).as(CFDictionary.class));
    }

    public CTAttributedStringAttributes getCoreTextAttributes(long location, NSRange range) {
        return new CTAttributedStringAttributes((CFDictionary)this.getAttributesDictionary(location, range).as(CFDictionary.class));
    }

    public CTAttributedStringAttributes getCoreTextAttributes(long location, NSRange range, NSRange rangeLimit) {
        return new CTAttributedStringAttributes((CFDictionary)this.getAttributesDictionary(location, range, rangeLimit).as(CFDictionary.class));
    }

    public void enumerateAttribute(String name, @ByVal NSRange enumerationRange, NSAttributedStringEnumerationOptions opts, VoidBlock3<NSObject, NSRange, BooleanPtr> block) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.enumerateAttribute(new NSString(name), enumerationRange, opts, block);
    }

    public void enumerateAttribute(NSAttributedStringAttribute attribute, @ByVal NSRange enumerationRange, NSAttributedStringEnumerationOptions opts, VoidBlock3<NSObject, NSRange, BooleanPtr> block) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.enumerateAttribute(attribute.value(), enumerationRange, opts, block);
    }

    public void enumerateAttribute(CMTextMarkupAttribute attribute, @ByVal NSRange enumerationRange, NSAttributedStringEnumerationOptions opts, VoidBlock3<NSObject, NSRange, BooleanPtr> block) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.enumerateAttribute((NSString)((CFString)attribute.value()).as(NSString.class), enumerationRange, opts, block);
    }

    public void enumerateAttribute(CTAttributedStringAttribute attribute, @ByVal NSRange enumerationRange, NSAttributedStringEnumerationOptions opts, VoidBlock3<NSObject, NSRange, BooleanPtr> block) {
        if (attribute == null) {
            throw new NullPointerException("attribute");
        }
        this.enumerateAttribute((NSString)((CFString)attribute.value()).as(NSString.class), enumerationRange, opts, block);
    }

    @WeaklyLinked
    public static NSAttributedString create(NSURL url, NSAttributedStringDocumentAttributes options) throws NSErrorException {
        return NSAttributedStringExtensions.createFromURL(url, options);
    }

    @WeaklyLinked
    public static NSAttributedString create(NSData data, NSAttributedStringDocumentAttributes options) throws NSErrorException {
        return NSAttributedStringExtensions.createFromData(data, options);
    }

    @WeaklyLinked
    public NSData getData(NSRange range, NSAttributedStringDocumentAttributes dict) throws NSErrorException {
        return NSAttributedStringExtensions.getData(this, range, dict);
    }

    @WeaklyLinked
    public NSFileWrapper getFileWrapper(NSRange range, NSAttributedStringDocumentAttributes dict) throws NSErrorException {
        return NSAttributedStringExtensions.getFileWrapper(this, range, dict);
    }

    @WeaklyLinked
    public CGSize getSize() {
        return NSAttributedStringExtensions.getSize(this);
    }

    @WeaklyLinked
    public void draw(CGPoint point) {
        NSAttributedStringExtensions.draw(this, point);
    }

    @WeaklyLinked
    public void draw(CGRect rect) {
        NSAttributedStringExtensions.draw(this, rect);
    }

    @WeaklyLinked
    public void draw(@ByVal CGRect rect, NSStringDrawingOptions options, NSStringDrawingContext context) {
        NSAttributedStringExtensions.draw(this, rect, options, context);
    }

    @WeaklyLinked
    public CGRect getBoundingRect(@ByVal CGSize size, NSStringDrawingOptions options, NSStringDrawingContext context) {
        return NSAttributedStringExtensions.getBoundingRect(this, size, options, context);
    }

    @WeaklyLinked
    public static NSAttributedString create(NSTextAttachment attachment) {
        return NSAttributedStringExtensions.create(attachment);
    }

    @Method(selector="attributesAtIndex:effectiveRange:")
    public native NSDictionary<NSString, NSObject> getAttributesDictionary(@MachineSizedUInt long var1, NSRange var3);

    @Method(selector="attribute:atIndex:effectiveRange:")
    public native NSObject getAttribute(NSString var1, @MachineSizedUInt long var2, NSRange var4);

    @Method(selector="attributedSubstringFromRange:")
    public native NSAttributedString substring(@ByVal NSRange var1);

    @Method(selector="attributesAtIndex:longestEffectiveRange:inRange:")
    public native NSDictionary<NSString, NSObject> getAttributesDictionary(@MachineSizedUInt long var1, NSRange var3, @ByVal NSRange var4);

    @Method(selector="attribute:atIndex:longestEffectiveRange:inRange:")
    public native NSObject getAttribute(NSString var1, @MachineSizedUInt long var2, NSRange var4, @ByVal NSRange var5);

    @Method(selector="isEqualToAttributedString:")
    public native boolean equalsTo(NSAttributedString var1);

    @Method(selector="initWithString:")
    @Pointer
    protected native long init(String var1);

    @Method(selector="initWithString:attributes:")
    @Pointer
    protected native long init(String var1, NSDictionary<NSString, NSObject> var2);

    @Method(selector="initWithAttributedString:")
    @Pointer
    protected native long init(NSAttributedString var1);

    @Method(selector="enumerateAttributesInRange:options:usingBlock:")
    public native void enumerateAttributes(@ByVal NSRange var1, NSAttributedStringEnumerationOptions var2, @Block(value="(,@ByVal,)") VoidBlock3<NSDictionary<NSString, NSObject>, NSRange, BooleanPtr> var3);

    @Method(selector="enumerateAttribute:inRange:options:usingBlock:")
    public native void enumerateAttribute(NSString var1, @ByVal NSRange var2, NSAttributedStringEnumerationOptions var3, @Block(value="(,@ByVal,)") VoidBlock3<NSObject, NSRange, BooleanPtr> var4);

    static {
        ObjCRuntime.bind(NSAttributedString.class);
    }

    public static class NSAttributedStringPtr
    extends Ptr<NSAttributedString, NSAttributedStringPtr> {
    }
}

