/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corevideo;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.corevideo.CVFillExtendedPixelsCallBackData;
import org.robovm.apple.corevideo.CVPixelBuffer;
import org.robovm.apple.corevideo.CVPixelFormatType;
import org.robovm.apple.foundation.NSData;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.ptr.FunctionPtr;

@Library(value="CoreVideo")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CVPixelFormatDescription
extends CFDictionaryWrapper {
    private static AtomicLong refconId = new AtomicLong();
    private static LongMap<FillExtendedPixelsCallback> callbacks = new LongMap();
    private static final Method cbFillExtendedPixels;
    private long refcon = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static boolean cbFillExtendedPixels(CVPixelBuffer pixelBuffer, long refcon) {
        FillExtendedPixelsCallback callback = null;
        LongMap<FillExtendedPixelsCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (FillExtendedPixelsCallback)callbacks.get(refcon);
        }
        return callback.fillExtendedPixels(pixelBuffer);
    }

    CVPixelFormatDescription(CFDictionary data) {
        super(data);
    }

    public CVPixelFormatDescription() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CVPixelFormatDescription set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public String getName() {
        if (this.has(Keys.Name())) {
            CFString val = this.get(Keys.Name(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CVPixelFormatDescription setName(String name) {
        this.set(Keys.Name(), new CFString(name));
        return this;
    }

    public long getConstant() {
        if (this.has(Keys.Constant())) {
            CFNumber val = this.get(Keys.Constant(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CVPixelFormatDescription setConstant(long constant) {
        this.set(Keys.Constant(), CFNumber.valueOf(constant));
        return this;
    }

    public String getCodecType() {
        if (this.has(Keys.CodecType())) {
            CFString val = this.get(Keys.CodecType(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CVPixelFormatDescription setCodecType(String codecType) {
        this.set(Keys.CodecType(), new CFString(codecType));
        return this;
    }

    public String getFourCC() {
        if (this.has(Keys.FourCC())) {
            CFString val = this.get(Keys.FourCC(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CVPixelFormatDescription setFourCC(String fourCC) {
        this.set(Keys.FourCC(), new CFString(fourCC));
        return this;
    }

    public boolean containsAlpha() {
        if (this.has(Keys.ContainsAlpha())) {
            CFBoolean val = this.get(Keys.ContainsAlpha(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setContainsAlpha(boolean containsAlpha) {
        this.set(Keys.ContainsAlpha(), CFBoolean.valueOf(containsAlpha));
        return this;
    }

    public boolean containsYCbCr() {
        if (this.has(Keys.ContainsYCbCr())) {
            CFBoolean val = this.get(Keys.ContainsYCbCr(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setContainsYCbCr(boolean containsYCbCr) {
        this.set(Keys.ContainsYCbCr(), CFBoolean.valueOf(containsYCbCr));
        return this;
    }

    public boolean containsRGB() {
        if (this.has(Keys.ContainsRGB())) {
            CFBoolean val = this.get(Keys.ContainsRGB(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setContainsRGB(boolean containsRGB) {
        this.set(Keys.ContainsRGB(), CFBoolean.valueOf(containsRGB));
        return this;
    }

    public int getPlanes() {
        if (this.has(Keys.Planes())) {
            CFNumber val = this.get(Keys.Planes(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVPixelFormatDescription setPlanes(int planes) {
        this.set(Keys.Planes(), CFNumber.valueOf(planes));
        return this;
    }

    public int getBlockWidth() {
        if (this.has(Keys.BlockWidth())) {
            CFNumber val = this.get(Keys.BlockWidth(), CFNumber.class);
            return val.intValue();
        }
        return 1;
    }

    public CVPixelFormatDescription setBlockWidth(int blockWidth) {
        this.set(Keys.BlockWidth(), CFNumber.valueOf(blockWidth));
        return this;
    }

    public int getBlockHeight() {
        if (this.has(Keys.BlockHeight())) {
            CFNumber val = this.get(Keys.BlockHeight(), CFNumber.class);
            return val.intValue();
        }
        return 1;
    }

    public CVPixelFormatDescription setBlockHeight(int blockHeight) {
        this.set(Keys.BlockHeight(), CFNumber.valueOf(blockHeight));
        return this;
    }

    public int getBitsPerBlock() {
        if (this.has(Keys.BitsPerBlock())) {
            CFNumber val = this.get(Keys.BitsPerBlock(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVPixelFormatDescription setBitsPerBlock(int bitsPerBlock) {
        this.set(Keys.BitsPerBlock(), CFNumber.valueOf(bitsPerBlock));
        return this;
    }

    public int getBlockHorizontalAlignment() {
        if (this.has(Keys.BlockHorizontalAlignment())) {
            CFNumber val = this.get(Keys.BlockHorizontalAlignment(), CFNumber.class);
            return val.intValue();
        }
        return 1;
    }

    public CVPixelFormatDescription setBlockHorizontalAlignment(int blockHorizontalAlignment) {
        this.set(Keys.BlockHorizontalAlignment(), CFNumber.valueOf(blockHorizontalAlignment));
        return this;
    }

    public int getBlockVerticalAlignment() {
        if (this.has(Keys.BlockVerticalAlignment())) {
            CFNumber val = this.get(Keys.BlockVerticalAlignment(), CFNumber.class);
            return val.intValue();
        }
        return 1;
    }

    public CVPixelFormatDescription setBlockVerticalAlignment(int blockVerticalAlignment) {
        this.set(Keys.BlockVerticalAlignment(), CFNumber.valueOf(blockVerticalAlignment));
        return this;
    }

    public NSData getBlackBlock() {
        if (this.has(Keys.BlackBlock())) {
            NSData val = this.get(Keys.BlackBlock(), NSData.class);
            return val;
        }
        return null;
    }

    public CVPixelFormatDescription setBlackBlock(NSData blackBlock) {
        this.set(Keys.BlackBlock(), (NativeObject)blackBlock);
        return this;
    }

    public int getHorizontalSubsampling() {
        if (this.has(Keys.HorizontalSubsampling())) {
            CFNumber val = this.get(Keys.HorizontalSubsampling(), CFNumber.class);
            return val.intValue();
        }
        return 1;
    }

    public CVPixelFormatDescription setHorizontalSubsampling(int horizontalSubsampling) {
        this.set(Keys.HorizontalSubsampling(), CFNumber.valueOf(horizontalSubsampling));
        return this;
    }

    public int getVerticalSubsampling() {
        if (this.has(Keys.VerticalSubsampling())) {
            CFNumber val = this.get(Keys.VerticalSubsampling(), CFNumber.class);
            return val.intValue();
        }
        return 1;
    }

    public CVPixelFormatDescription setVerticalSubsampling(int verticalSubsampling) {
        this.set(Keys.VerticalSubsampling(), CFNumber.valueOf(verticalSubsampling));
        return this;
    }

    public int getOpenGLFormat() {
        if (this.has(Keys.OpenGLFormat())) {
            CFNumber val = this.get(Keys.OpenGLFormat(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVPixelFormatDescription setOpenGLFormat(int openGLFormat) {
        this.set(Keys.OpenGLFormat(), CFNumber.valueOf(openGLFormat));
        return this;
    }

    public int getOpenGLType() {
        if (this.has(Keys.OpenGLType())) {
            CFNumber val = this.get(Keys.OpenGLType(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVPixelFormatDescription setOpenGLType(int openGLType) {
        this.set(Keys.OpenGLType(), CFNumber.valueOf(openGLType));
        return this;
    }

    public int getOpenGLInternalFormat() {
        if (this.has(Keys.OpenGLInternalFormat())) {
            CFNumber val = this.get(Keys.OpenGLInternalFormat(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CVPixelFormatDescription setOpenGLInternalFormat(int openGLInternalFormat) {
        this.set(Keys.OpenGLInternalFormat(), CFNumber.valueOf(openGLInternalFormat));
        return this;
    }

    public CGBitmapInfo getCGBitmapInfo() {
        if (this.has(Keys.CGBitmapInfo())) {
            CFNumber val = this.get(Keys.CGBitmapInfo(), CFNumber.class);
            return new CGBitmapInfo(val.longValue());
        }
        return null;
    }

    public CVPixelFormatDescription setCGBitmapInfo(CGBitmapInfo cGBitmapInfo) {
        this.set(Keys.CGBitmapInfo(), CFNumber.valueOf(cGBitmapInfo.value()));
        return this;
    }

    public boolean isCompatibleWithQD() {
        if (this.has(Keys.QDCompatibility())) {
            CFBoolean val = this.get(Keys.QDCompatibility(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setCompatibleWithQD(boolean compatibleWithQD) {
        this.set(Keys.QDCompatibility(), CFBoolean.valueOf(compatibleWithQD));
        return this;
    }

    public boolean isCompatibleWithCGBitmapContext() {
        if (this.has(Keys.CGBitmapContextCompatibility())) {
            CFBoolean val = this.get(Keys.CGBitmapContextCompatibility(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setCompatibleWithCGBitmapContext(boolean compatibleWithCGBitmapContext) {
        this.set(Keys.CGBitmapContextCompatibility(), CFBoolean.valueOf(compatibleWithCGBitmapContext));
        return this;
    }

    public boolean isCompatibleWithCGImage() {
        if (this.has(Keys.CGImageCompatibility())) {
            CFBoolean val = this.get(Keys.CGImageCompatibility(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setCompatibleWithCGImage(boolean compatibleWithCGImage) {
        this.set(Keys.CGImageCompatibility(), CFBoolean.valueOf(compatibleWithCGImage));
        return this;
    }

    public boolean isCompatibleWithOpenGL() {
        if (this.has(Keys.OpenGLCompatibility())) {
            CFBoolean val = this.get(Keys.OpenGLCompatibility(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setCompatibleWithOpenGL(boolean compatibleWithOpenGL) {
        this.set(Keys.OpenGLCompatibility(), CFBoolean.valueOf(compatibleWithOpenGL));
        return this;
    }

    public boolean isCompatibleWithOpenGLES() {
        if (this.has(Keys.OpenGLESCompatibility())) {
            CFBoolean val = this.get(Keys.OpenGLESCompatibility(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CVPixelFormatDescription setCompatibleWithOpenGLES(boolean compatibleWithOpenGLES) {
        this.set(Keys.OpenGLESCompatibility(), CFBoolean.valueOf(compatibleWithOpenGLES));
        return this;
    }

    @Bridge(symbol="CVPixelFormatDescriptionCreateWithPixelFormatType", optional=true)
    public static native CVPixelFormatDescription create(CFAllocator var0, CVPixelFormatType var1);

    @Bridge(symbol="CVPixelFormatDescriptionArrayCreateWithAllPixelFormatTypes", optional=true)
    @org.robovm.rt.bro.annotation.Marshaler(value=CVPixelFormatType.AsListMarshaler.class)
    public static native List<CVPixelFormatType> getAllPixelFormatTypes(CFAllocator var0);

    @Bridge(symbol="CVPixelFormatDescriptionRegisterDescriptionWithPixelFormatType", optional=true)
    public static native void registerDescription(CVPixelFormatDescription var0, CVPixelFormatType var1);

    public static CVPixelFormatDescription create(CVPixelFormatType pixelFormat) {
        return CVPixelFormatDescription.create(null, pixelFormat);
    }

    public static List<CVPixelFormatType> getAllPixelFormatTypes() {
        return CVPixelFormatDescription.getAllPixelFormatTypes(null);
    }

    public void register(CVPixelFormatType pixelFormat) {
        CVPixelFormatDescription.registerDescription(this, pixelFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CVPixelFormatDescription setFillExtendedPixelsCallback(FillExtendedPixelsCallback callback) {
        if (this.refcon == -1L) {
            this.refcon = refconId.getAndIncrement();
        }
        CVFillExtendedPixelsCallBackData data = new CVFillExtendedPixelsCallBackData(1L, new FunctionPtr(cbFillExtendedPixels), this.refcon);
        NSData val = new NSData(data);
        this.set(Keys.FillExtendedPixelsCallback(), (NativeObject)val);
        LongMap<FillExtendedPixelsCallback> longMap = callbacks;
        synchronized (longMap) {
            callbacks.put(this.refcon, (Object)callback);
        }
        return this;
    }

    static {
        try {
            cbFillExtendedPixels = CVPixelFormatDescription.class.getDeclaredMethod("cbFillExtendedPixels", CVPixelBuffer.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    @Library(value="CoreVideo")
    public static class Keys {
        @GlobalValue(symbol="kCVPixelFormatName", optional=true)
        public static native CFString Name();

        @GlobalValue(symbol="kCVPixelFormatConstant", optional=true)
        public static native CFString Constant();

        @GlobalValue(symbol="kCVPixelFormatCodecType", optional=true)
        public static native CFString CodecType();

        @GlobalValue(symbol="kCVPixelFormatFourCC", optional=true)
        public static native CFString FourCC();

        @GlobalValue(symbol="kCVPixelFormatContainsAlpha", optional=true)
        public static native CFString ContainsAlpha();

        @GlobalValue(symbol="kCVPixelFormatContainsYCbCr", optional=true)
        public static native CFString ContainsYCbCr();

        @GlobalValue(symbol="kCVPixelFormatContainsRGB", optional=true)
        public static native CFString ContainsRGB();

        @GlobalValue(symbol="kCVPixelFormatPlanes", optional=true)
        public static native CFString Planes();

        @GlobalValue(symbol="kCVPixelFormatBlockWidth", optional=true)
        public static native CFString BlockWidth();

        @GlobalValue(symbol="kCVPixelFormatBlockHeight", optional=true)
        public static native CFString BlockHeight();

        @GlobalValue(symbol="kCVPixelFormatBitsPerBlock", optional=true)
        public static native CFString BitsPerBlock();

        @GlobalValue(symbol="kCVPixelFormatBlockHorizontalAlignment", optional=true)
        public static native CFString BlockHorizontalAlignment();

        @GlobalValue(symbol="kCVPixelFormatBlockVerticalAlignment", optional=true)
        public static native CFString BlockVerticalAlignment();

        @GlobalValue(symbol="kCVPixelFormatBlackBlock", optional=true)
        public static native CFString BlackBlock();

        @GlobalValue(symbol="kCVPixelFormatHorizontalSubsampling", optional=true)
        public static native CFString HorizontalSubsampling();

        @GlobalValue(symbol="kCVPixelFormatVerticalSubsampling", optional=true)
        public static native CFString VerticalSubsampling();

        @GlobalValue(symbol="kCVPixelFormatOpenGLFormat", optional=true)
        public static native CFString OpenGLFormat();

        @GlobalValue(symbol="kCVPixelFormatOpenGLType", optional=true)
        public static native CFString OpenGLType();

        @GlobalValue(symbol="kCVPixelFormatOpenGLInternalFormat", optional=true)
        public static native CFString OpenGLInternalFormat();

        @GlobalValue(symbol="kCVPixelFormatCGBitmapInfo", optional=true)
        public static native CFString CGBitmapInfo();

        @GlobalValue(symbol="kCVPixelFormatQDCompatibility", optional=true)
        public static native CFString QDCompatibility();

        @GlobalValue(symbol="kCVPixelFormatCGBitmapContextCompatibility", optional=true)
        public static native CFString CGBitmapContextCompatibility();

        @GlobalValue(symbol="kCVPixelFormatCGImageCompatibility", optional=true)
        public static native CFString CGImageCompatibility();

        @GlobalValue(symbol="kCVPixelFormatOpenGLCompatibility", optional=true)
        public static native CFString OpenGLCompatibility();

        @GlobalValue(symbol="kCVPixelFormatOpenGLESCompatibility", optional=true)
        public static native CFString OpenGLESCompatibility();

        @GlobalValue(symbol="kCVPixelFormatFillExtendedPixelsCallback", optional=true)
        public static native CFString FillExtendedPixelsCallback();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static interface FillExtendedPixelsCallback {
        public boolean fillExtendedPixels(CVPixelBuffer var1);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CVPixelFormatDescription> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CVPixelFormatDescription> list = new ArrayList<CVPixelFormatDescription>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CVPixelFormatDescription(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CVPixelFormatDescription> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CVPixelFormatDescription i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CVPixelFormatDescription toObject(Class<CVPixelFormatDescription> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CVPixelFormatDescription(o);
        }

        @MarshalsPointer
        public static long toNative(CVPixelFormatDescription o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

