/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corevideo;

import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.corevideo.CVAttachmentMode;
import org.robovm.apple.corevideo.CVBuffer;
import org.robovm.apple.corevideo.CVImageBufferAttribute;
import org.robovm.apple.corevideo.CVImageBufferAttributes;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;

@Library(value="CoreVideo")
public class CVImageBuffer
extends CVBuffer {
    public void setAttribute(CVImageBufferAttribute attribute, CFType value, CVAttachmentMode attachmentMode) {
        this.setAttachment((CFString)attribute.value(), value, attachmentMode);
    }

    public CFType getAttribute(CVImageBufferAttribute attribute) {
        return this.getAttachment((CFString)attribute.value());
    }

    public CVAttachmentMode getAttributeMode(CVImageBufferAttribute attribute) {
        return this.getAttachmentMode((CFString)attribute.value());
    }

    public void removeAttribute(CVImageBufferAttribute attribute) {
        this.removeAttachment((CFString)attribute.value());
    }

    public void removeAllAttributes() {
        this.removeAllAttachments();
    }

    public CVImageBufferAttributes getAttributes(CVAttachmentMode attachmentMode) {
        return new CVImageBufferAttributes((CFDictionary)this.getAttachments(attachmentMode).as(CFDictionary.class));
    }

    public void setAttributes(CVImageBufferAttributes attributes, CVAttachmentMode attachmentMode) {
        this.setAttachments((NSDictionary)attributes.getDictionary().as(NSDictionary.class), attachmentMode);
    }

    public void propagateAttributes(CVImageBuffer destinationBuffer) {
        this.propagateAttachments(destinationBuffer);
    }

    @Bridge(symbol="CVImageBufferGetEncodedSize", optional=true)
    @ByVal
    public native CGSize getEncodedSize();

    @Bridge(symbol="CVImageBufferGetDisplaySize", optional=true)
    @ByVal
    public native CGSize getDisplaySize();

    @Bridge(symbol="CVImageBufferGetCleanRect", optional=true)
    @ByVal
    public native CGRect getCleanRect();

    @Bridge(symbol="CVImageBufferIsFlipped", optional=true)
    public native boolean isFlipped();

    static {
        Bro.bind(CVImageBuffer.class);
    }
}

