/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTRubyAlignment;
import org.robovm.apple.coretext.CTRubyOverhang;
import org.robovm.apple.coretext.CTRubyPosition;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreText")
public class CTRubyAnnotation
extends CFType {
    protected CTRubyAnnotation() {
    }

    public static CTRubyAnnotation create(CTRubyAlignment alignment, CTRubyOverhang overhang, @MachineSizedFloat double sizeFactor, String ... text) {
        int n = CTRubyPosition.values().length;
        if (text.length != n) {
            throw new IllegalArgumentException(String.format("array 'text' needs to have exactly %d elements", n));
        }
        NativeObject[] strings = new CFString[n];
        for (int i = 0; i < n; ++i) {
            strings[i] = new CFString(text[i]);
        }
        CFString.CFStringPtr ptr = new CFString.CFStringPtr();
        ptr.set(strings);
        return CTRubyAnnotation.create(alignment, overhang, sizeFactor, ptr);
    }

    @Bridge(symbol="CTRubyAnnotationGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTRubyAnnotationCreate", optional=true)
    private static native CTRubyAnnotation create(CTRubyAlignment var0, CTRubyOverhang var1, @MachineSizedFloat double var2, CFString.CFStringPtr var4);

    @Bridge(symbol="CTRubyAnnotationCreateCopy", optional=true)
    public static native CTRubyAnnotation createCopy(CTRubyAnnotation var0);

    @Bridge(symbol="CTRubyAnnotationGetAlignment", optional=true)
    public native CTRubyAlignment getAlignment();

    @Bridge(symbol="CTRubyAnnotationGetOverhang", optional=true)
    public native CTRubyOverhang getOverhang();

    @Bridge(symbol="CTRubyAnnotationGetSizeFactor", optional=true)
    @MachineSizedFloat
    public native double getSizeFactor();

    @Bridge(symbol="CTRubyAnnotationGetTextForPosition", optional=true)
    public native String getTextForPosition(CTRubyPosition var1);

    static {
        Bro.bind(CTRubyAnnotation.class);
    }

    public static class CTRubyAnnotationPtr
    extends Ptr<CTRubyAnnotation, CTRubyAnnotationPtr> {
    }
}

