/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coretext.CTLineBoundsOptions;
import org.robovm.apple.coretext.CTLineTruncationType;
import org.robovm.apple.coretext.CTRun;
import org.robovm.apple.foundation.NSAttributedString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreText")
public class CTLine
extends CFType {
    protected CTLine() {
    }

    @MachineSizedFloat
    public double getWidth() {
        return this.getTypographicBounds(null, null, null);
    }

    @MachineSizedFloat
    public double getAscent() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getTypographicBounds(ptr, null, null);
        return ptr.get();
    }

    @MachineSizedFloat
    public double getDescent() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getTypographicBounds(null, ptr, null);
        return ptr.get();
    }

    @MachineSizedFloat
    public double getLeading() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getTypographicBounds(null, null, ptr);
        return ptr.get();
    }

    @MachineSizedFloat
    public double getPrimaryOffset(@MachineSizedSInt long charIndex) {
        return this.getOffset(charIndex, null);
    }

    @MachineSizedFloat
    public double getSecondaryOffset(@MachineSizedSInt long charIndex) {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getOffset(charIndex, ptr);
        return ptr.get();
    }

    @Bridge(symbol="CTLineGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTLineCreateWithAttributedString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTLine create(NSAttributedString var0);

    @Bridge(symbol="CTLineCreateTruncatedLine", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTLine createTruncatedLine(double var1, CTLineTruncationType var3, CTLine var4);

    @Bridge(symbol="CTLineCreateJustifiedLine", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTLine createJustifiedLine(@MachineSizedFloat double var1, double var3);

    @Bridge(symbol="CTLineGetGlyphCount", optional=true)
    @MachineSizedSInt
    public native long getGlyphCount();

    @Bridge(symbol="CTLineGetGlyphRuns", optional=true)
    @Marshaler(value=CTRun.AsListMarshaler.class)
    public native List<CTRun> getGlyphRuns();

    @Bridge(symbol="CTLineGetStringRange", optional=true)
    @ByVal
    public native CFRange getStringRange();

    @Bridge(symbol="CTLineGetPenOffsetForFlush", optional=true)
    public native double getPenOffset(@MachineSizedFloat double var1, double var3);

    @Bridge(symbol="CTLineDraw", optional=true)
    public native void draw(CGContext var1);

    @Bridge(symbol="CTLineGetTypographicBounds", optional=true)
    protected native double getTypographicBounds(MachineSizedFloatPtr var1, MachineSizedFloatPtr var2, MachineSizedFloatPtr var3);

    @Bridge(symbol="CTLineGetBoundsWithOptions", optional=true)
    @ByVal
    public native CGRect getBounds(CTLineBoundsOptions var1);

    @Bridge(symbol="CTLineGetTrailingWhitespaceWidth", optional=true)
    public native double getTrailingWhitespaceWidth();

    @Bridge(symbol="CTLineGetImageBounds", optional=true)
    @ByVal
    public native CGRect getImageBounds(CGContext var1);

    @Bridge(symbol="CTLineGetStringIndexForPosition", optional=true)
    @MachineSizedSInt
    public native long getStringIndex(@ByVal CGPoint var1);

    @Bridge(symbol="CTLineGetOffsetForStringIndex", optional=true)
    @MachineSizedFloat
    protected native double getOffset(@MachineSizedSInt long var1, MachineSizedFloatPtr var3);

    static {
        Bro.bind(CTLine.class);
    }

    public static class CTLinePtr
    extends Ptr<CTLine, CTLinePtr> {
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<?> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.toList(CTLine.class);
        }

        @MarshalsPointer
        public static long toNative(List<? extends CFType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray o = null;
            o = l instanceof CFArray ? (CFArray)((Object)l) : CFArray.create(l);
            return CFType.Marshaler.toNative(o, flags);
        }
    }
}

