/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTFrameClippingPath;
import org.robovm.apple.coretext.CTFramePathFillRule;
import org.robovm.apple.coretext.CTFrameProgression;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreText")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CTFrameAttributes
extends CFDictionaryWrapper {
    CTFrameAttributes(CFDictionary data) {
        super(data);
    }

    public CTFrameAttributes() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CTFrameAttributes set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public CTFrameProgression getProgression() {
        if (this.has(Keys.Progression())) {
            CFNumber val = this.get(Keys.Progression(), CFNumber.class);
            return CTFrameProgression.valueOf(val.longValue());
        }
        return null;
    }

    public CTFrameAttributes setProgression(CTFrameProgression progression) {
        this.set(Keys.Progression(), CFNumber.valueOf(progression.value()));
        return this;
    }

    public CTFramePathFillRule getPathFillRule() {
        if (this.has(Keys.PathFillRule())) {
            CFNumber val = this.get(Keys.PathFillRule(), CFNumber.class);
            return CTFramePathFillRule.valueOf(val.longValue());
        }
        return null;
    }

    public CTFrameAttributes setPathFillRule(CTFramePathFillRule pathFillRule) {
        this.set(Keys.PathFillRule(), CFNumber.valueOf(pathFillRule.value()));
        return this;
    }

    public double getPathWidth() {
        if (this.has(Keys.PathWidth())) {
            CFNumber val = this.get(Keys.PathWidth(), CFNumber.class);
            return val.doubleValue();
        }
        return 0.0;
    }

    public CTFrameAttributes setPathWidth(double pathWidth) {
        this.set(Keys.PathWidth(), CFNumber.valueOf(pathWidth));
        return this;
    }

    public List<CTFrameClippingPath> getClippingPaths() {
        if (this.has(Keys.ClippingPaths())) {
            CFDictionary[] array;
            CFArray val = this.get(Keys.ClippingPaths(), CFArray.class);
            ArrayList<CTFrameClippingPath> list = new ArrayList<CTFrameClippingPath>();
            for (CFDictionary d : array = (CFDictionary[])val.toArray(CFDictionary.class)) {
                list.add(new CTFrameClippingPath(d));
            }
            return list;
        }
        return null;
    }

    public CTFrameAttributes setClippingPaths(List<CTFrameClippingPath> clippingPaths) {
        CFMutableArray val = CFMutableArray.create();
        for (CTFrameClippingPath e : clippingPaths) {
            ((CFArray)val).add(e.getDictionary());
        }
        this.set(Keys.ClippingPaths(), val);
        return this;
    }

    @Library(value="CoreText")
    public static class Keys {
        @GlobalValue(symbol="kCTFrameProgressionAttributeName", optional=true)
        public static native CFString Progression();

        @GlobalValue(symbol="kCTFramePathFillRuleAttributeName", optional=true)
        public static native CFString PathFillRule();

        @GlobalValue(symbol="kCTFramePathWidthAttributeName", optional=true)
        public static native CFString PathWidth();

        @GlobalValue(symbol="kCTFrameClippingPathsAttributeName", optional=true)
        public static native CFString ClippingPaths();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CTFrameAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CTFrameAttributes> list = new ArrayList<CTFrameAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CTFrameAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CTFrameAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CTFrameAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CTFrameAttributes toObject(Class<CTFrameAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CTFrameAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CTFrameAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

