/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTFontSymbolicTraits;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreText")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CTFontTraits
extends CFDictionaryWrapper {
    CTFontTraits(CFDictionary data) {
        super(data);
    }

    public CTFontTraits() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CTFontTraits set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public CTFontSymbolicTraits getSymbolicTrait() {
        if (this.has(Keys.SymbolicTrait())) {
            CFNumber val = this.get(Keys.SymbolicTrait(), CFNumber.class);
            return new CTFontSymbolicTraits(val.longValue());
        }
        return null;
    }

    public CTFontTraits setSymbolicTrait(CTFontSymbolicTraits symbolicTrait) {
        this.set(Keys.SymbolicTrait(), CFNumber.valueOf(symbolicTrait.value()));
        return this;
    }

    public float getWeightTrait() {
        if (this.has(Keys.WeightTrait())) {
            CFNumber val = this.get(Keys.WeightTrait(), CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTFontTraits setWeightTrait(float weightTrait) {
        this.set(Keys.WeightTrait(), CFNumber.valueOf(weightTrait));
        return this;
    }

    public float getWidthTrait() {
        if (this.has(Keys.WidthTrait())) {
            CFNumber val = this.get(Keys.WidthTrait(), CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTFontTraits setWidthTrait(float widthTrait) {
        this.set(Keys.WidthTrait(), CFNumber.valueOf(widthTrait));
        return this;
    }

    public float getSlantTrait() {
        if (this.has(Keys.SlantTrait())) {
            CFNumber val = this.get(Keys.SlantTrait(), CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTFontTraits setSlantTrait(float slantTrait) {
        this.set(Keys.SlantTrait(), CFNumber.valueOf(slantTrait));
        return this;
    }

    @Library(value="CoreText")
    public static class Keys {
        @GlobalValue(symbol="kCTFontSymbolicTrait", optional=true)
        public static native CFString SymbolicTrait();

        @GlobalValue(symbol="kCTFontWeightTrait", optional=true)
        public static native CFString WeightTrait();

        @GlobalValue(symbol="kCTFontWidthTrait", optional=true)
        public static native CFString WidthTrait();

        @GlobalValue(symbol="kCTFontSlantTrait", optional=true)
        public static native CFString SlantTrait();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CTFontTraits> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CTFontTraits> list = new ArrayList<CTFontTraits>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CTFontTraits(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CTFontTraits> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CTFontTraits i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CTFontTraits toObject(Class<CTFontTraits> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CTFontTraits(o);
        }

        @MarshalsPointer
        public static long toNative(CTFontTraits o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

