/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.Collection;
import java.util.List;
import org.robovm.apple.coregraphics.CGFont;
import org.robovm.apple.coretext.CTFontDescriptor;
import org.robovm.apple.coretext.CTFontManagerScope;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Library(value="CoreText")
public class CTFontManager
extends CocoaUtility {
    public static boolean registerFonts(List<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.registerFonts(new NSArray<NSURL>((Collection<NSURL>)fontURLs), scope, null);
    }

    public static boolean registerFonts(NSArray<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.registerFonts(fontURLs, scope, null);
    }

    public static boolean unregisterFonts(List<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.unregisterFonts(new NSArray<NSURL>((Collection<NSURL>)fontURLs), scope, null);
    }

    public static boolean unregisterFonts(NSArray<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.unregisterFonts(fontURLs, scope, null);
    }

    @GlobalValue(symbol="kCTFontManagerRegisteredFontsChangedNotification", optional=true)
    public static native NSString RegisteredFontsChangedNotification();

    @Bridge(symbol="CTFontManagerCreateFontDescriptorsFromURL", optional=true)
    @Marshaler(value=CTFontDescriptor.AsListMarshaler.class)
    public static native List<CTFontDescriptor> createFontDescriptors(NSURL var0);

    @Bridge(symbol="CTFontManagerCreateFontDescriptorFromData", optional=true)
    public static native CTFontDescriptor createFontDescriptor(NSData var0);

    public static boolean registerFonts(NSURL fontURL, CTFontManagerScope scope) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.registerFonts(fontURL, scope, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerRegisterFontsForURL", optional=true)
    private static native boolean registerFonts(NSURL var0, CTFontManagerScope var1, NSError.NSErrorPtr var2);

    public static boolean unregisterFonts(NSURL fontURL, CTFontManagerScope scope) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.unregisterFonts(fontURL, scope, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerUnregisterFontsForURL", optional=true)
    private static native boolean unregisterFonts(NSURL var0, CTFontManagerScope var1, NSError.NSErrorPtr var2);

    public static boolean registerGraphicsFont(CGFont font) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.registerGraphicsFont(font, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerRegisterGraphicsFont", optional=true)
    private static native boolean registerGraphicsFont(CGFont var0, NSError.NSErrorPtr var1);

    public static boolean unregisterGraphicsFont(CGFont font) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.unregisterGraphicsFont(font, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerUnregisterGraphicsFont", optional=true)
    private static native boolean unregisterGraphicsFont(CGFont var0, NSError.NSErrorPtr var1);

    @Bridge(symbol="CTFontManagerRegisterFontsForURLs", optional=true)
    protected static native boolean registerFonts(NSArray<NSURL> var0, CTFontManagerScope var1, NSArray.NSArrayPtr var2);

    @Bridge(symbol="CTFontManagerUnregisterFontsForURLs", optional=true)
    protected static native boolean unregisterFonts(NSArray<NSURL> var0, CTFontManagerScope var1, NSArray.NSArrayPtr var2);

    static {
        Bro.bind(CTFontManager.class);
    }

    public static class Notifications {
        public static NSObject observeRegisteredFontsChanged(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CTFontManager.RegisteredFontsChangedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

