/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.lang.reflect.Method;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableSet;
import org.robovm.apple.corefoundation.CFSet;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTFontAttribute;
import org.robovm.apple.coretext.CTFontAttributes;
import org.robovm.apple.coretext.CTFontDescriptorMatchingState;
import org.robovm.apple.coretext.CTFontDescriptorProgressData;
import org.robovm.apple.coretext.CTFontSymbolicTraits;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreText")
public class CTFontDescriptor
extends CFType {
    private static final Method cbProgress;
    private static ProgressHandler progressHandler;

    protected CTFontDescriptor() {
    }

    @Callback
    private static boolean cbProgress(CTFontDescriptorMatchingState state, CFDictionary data) {
        return progressHandler.invoke(state, new CTFontDescriptorProgressData(data));
    }

    public List<CTFontDescriptor> createMatchingFontDescriptors(List<CTFontAttribute> mandatoryAttributes) {
        CFMutableSet set = CFMutableSet.create();
        for (CTFontAttribute attr : mandatoryAttributes) {
            ((CFSet)set).add((NativeObject)attr.value());
        }
        return this.createMatchingFontDescriptors(set).toList(CTFontDescriptor.class);
    }

    public CTFontDescriptor createMatchingFontDescriptor(List<CTFontAttribute> mandatoryAttributes) {
        CFMutableSet set = CFMutableSet.create();
        for (CTFontAttribute attr : mandatoryAttributes) {
            ((CFSet)set).add((NativeObject)attr.value());
        }
        return this.createMatchingFontDescriptor(set);
    }

    public static boolean matchFontDescriptors(List<CTFontDescriptor> descriptors, List<CTFontAttribute> mandatoryAttributes, ProgressHandler progressHandler) {
        CTFontDescriptor.progressHandler = progressHandler;
        CFMutableSet set = CFMutableSet.create();
        for (CTFontAttribute attr : mandatoryAttributes) {
            ((CFSet)set).add((NativeObject)attr.value());
        }
        return CTFontDescriptor.matchFontDescriptors(CFArray.create(descriptors), set, new FunctionPtr(cbProgress));
    }

    public CFType getLocalizedAttribute(CTFontAttribute attribute) {
        return this.getLocalizedAttribute(attribute, null);
    }

    @Bridge(symbol="CTFontDescriptorGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTFontDescriptorCreateWithNameAndSize", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFontDescriptor create(String var0, @MachineSizedFloat double var1);

    @Bridge(symbol="CTFontDescriptorCreateWithAttributes", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTFontDescriptor create(CTFontAttributes var0);

    @Bridge(symbol="CTFontDescriptorCreateCopyWithAttributes", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTFontDescriptor createCopy(CTFontAttributes var1);

    @Bridge(symbol="CTFontDescriptorCreateCopyWithFamily", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTFontDescriptor createCopy(String var1);

    @Bridge(symbol="CTFontDescriptorCreateCopyWithSymbolicTraits", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CTFontDescriptor createCopy(CTFontSymbolicTraits var1, CTFontSymbolicTraits var2);

    @Bridge(symbol="CTFontDescriptorCreateMatchingFontDescriptors", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected native CFArray createMatchingFontDescriptors(CFSet var1);

    @Bridge(symbol="CTFontDescriptorCreateMatchingFontDescriptor", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected native CTFontDescriptor createMatchingFontDescriptor(CFSet var1);

    @Bridge(symbol="CTFontDescriptorMatchFontDescriptorsWithProgressHandler", optional=true)
    protected static native boolean matchFontDescriptors(CFArray var0, CFSet var1, FunctionPtr var2);

    @Bridge(symbol="CTFontDescriptorCopyAttributes", optional=true)
    public native CTFontAttributes getAttributes();

    @Bridge(symbol="CTFontDescriptorCopyAttribute", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFType getAttribute(CTFontAttribute var1);

    @Bridge(symbol="CTFontDescriptorCopyLocalizedAttribute", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected native CFType getLocalizedAttribute(CTFontAttribute var1, CFString.CFStringPtr var2);

    static {
        try {
            cbProgress = CTFontDescriptor.class.getDeclaredMethod("cbProgress", CTFontDescriptorMatchingState.class, CFDictionary.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CTFontDescriptor.class);
    }

    public static class CTFontDescriptorPtr
    extends Ptr<CTFontDescriptor, CTFontDescriptorPtr> {
    }

    public static interface ProgressHandler {
        public boolean invoke(CTFontDescriptorMatchingState var1, CTFontDescriptorProgressData var2);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<?> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            return o.toList(CTFontDescriptor.class);
        }

        @MarshalsPointer
        public static long toNative(List<? extends CFType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray o = null;
            o = l instanceof CFArray ? (CFArray)((Object)l) : CFArray.create(l);
            return CFType.Marshaler.toNative(o, flags);
        }
    }
}

