/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coretext.CTFontAttribute;
import org.robovm.apple.coretext.CTFontDescriptor;
import org.robovm.apple.coretext.CTFontFormat;
import org.robovm.apple.coretext.CTFontManagerScope;
import org.robovm.apple.coretext.CTFontOrientation;
import org.robovm.apple.coretext.CTFontPriority;
import org.robovm.apple.coretext.CTFontTraits;
import org.robovm.apple.coretext.CTFontVariationAxes;
import org.robovm.apple.foundation.NSCharacterSet;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSURL;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreText")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CTFontAttributes
extends CFDictionaryWrapper {
    CTFontAttributes(CFDictionary data) {
        super(data);
    }

    public CTFontAttributes() {
    }

    public boolean has(CTFontAttribute key) {
        return this.data.containsKey((NativeObject)key.value());
    }

    public <T extends NativeObject> T get(CTFontAttribute key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get((NativeObject)key.value(), type);
        }
        return null;
    }

    public CTFontAttributes set(CTFontAttribute key, NativeObject value) {
        this.data.put((NativeObject)key.value(), value);
        return this;
    }

    public NSURL getURL() {
        if (this.has(CTFontAttribute.URL)) {
            NSURL val = this.get(CTFontAttribute.URL, NSURL.class);
            return val;
        }
        return null;
    }

    public CTFontAttributes setURL(NSURL uRL) {
        this.set(CTFontAttribute.URL, (NativeObject)uRL);
        return this;
    }

    public String getName() {
        if (this.has(CTFontAttribute.Name)) {
            CFString val = this.get(CTFontAttribute.Name, CFString.class);
            return val.toString();
        }
        return null;
    }

    public CTFontAttributes setName(String name) {
        this.set(CTFontAttribute.Name, new CFString(name));
        return this;
    }

    public String getDisplayName() {
        if (this.has(CTFontAttribute.DisplayName)) {
            CFString val = this.get(CTFontAttribute.DisplayName, CFString.class);
            return val.toString();
        }
        return null;
    }

    public CTFontAttributes setDisplayName(String displayName) {
        this.set(CTFontAttribute.DisplayName, new CFString(displayName));
        return this;
    }

    public String getStyleName() {
        if (this.has(CTFontAttribute.StyleName)) {
            CFString val = this.get(CTFontAttribute.StyleName, CFString.class);
            return val.toString();
        }
        return null;
    }

    public CTFontAttributes setStyleName(String styleName) {
        this.set(CTFontAttribute.StyleName, new CFString(styleName));
        return this;
    }

    public CTFontTraits getTraits() {
        if (this.has(CTFontAttribute.Traits)) {
            CFDictionary val = this.get(CTFontAttribute.Traits, CFDictionary.class);
            return new CTFontTraits(val);
        }
        return null;
    }

    public CTFontAttributes setTraits(CTFontTraits traits) {
        this.set(CTFontAttribute.Traits, traits.getDictionary());
        return this;
    }

    public CTFontVariationAxes getVariationAxes() {
        if (this.has(CTFontAttribute.Variation)) {
            CFDictionary val = this.get(CTFontAttribute.Variation, CFDictionary.class);
            return new CTFontVariationAxes(val);
        }
        return null;
    }

    public CTFontAttributes setVariationAxes(CTFontVariationAxes variationAxes) {
        this.set(CTFontAttribute.Variation, variationAxes.getDictionary());
        return this;
    }

    public float getSize() {
        if (this.has(CTFontAttribute.Size)) {
            CFNumber val = this.get(CTFontAttribute.Size, CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTFontAttributes setSize(float size) {
        this.set(CTFontAttribute.Size, CFNumber.valueOf(size));
        return this;
    }

    public CGAffineTransform getMatrix() {
        if (this.has(CTFontAttribute.Matrix)) {
            NSData val = this.get(CTFontAttribute.Matrix, NSData.class);
            return val.getStructData(CGAffineTransform.class);
        }
        return null;
    }

    public CTFontAttributes setMatrix(CGAffineTransform matrix) {
        this.set(CTFontAttribute.Matrix, (NativeObject)new NSData(matrix));
        return this;
    }

    public List<CTFontDescriptor> getCascadeList() {
        if (this.has(CTFontAttribute.CascadeList)) {
            CFArray val = this.get(CTFontAttribute.CascadeList, CFArray.class);
            return val.toList(CTFontDescriptor.class);
        }
        return null;
    }

    public CTFontAttributes setCascadeList(List<CTFontDescriptor> cascadeList) {
        this.set(CTFontAttribute.CascadeList, CFArray.create(cascadeList));
        return this;
    }

    public NSCharacterSet getCharacterSet() {
        if (this.has(CTFontAttribute.CharacterSet)) {
            NSCharacterSet val = this.get(CTFontAttribute.CharacterSet, NSCharacterSet.class);
            return val;
        }
        return null;
    }

    public CTFontAttributes setCharacterSet(NSCharacterSet characterSet) {
        this.set(CTFontAttribute.CharacterSet, (NativeObject)characterSet);
        return this;
    }

    public List<String> getLanguages() {
        if (this.has(CTFontAttribute.Languages)) {
            CFArray val = this.get(CTFontAttribute.Languages, CFArray.class);
            return val.asStringList();
        }
        return null;
    }

    public CTFontAttributes setLanguages(List<String> languages) {
        this.set(CTFontAttribute.Languages, CFArray.fromStrings(languages));
        return this;
    }

    public float getBaselineAdjust() {
        if (this.has(CTFontAttribute.BaselineAdjust)) {
            CFNumber val = this.get(CTFontAttribute.BaselineAdjust, CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTFontAttributes setBaselineAdjust(float baselineAdjust) {
        this.set(CTFontAttribute.BaselineAdjust, CFNumber.valueOf(baselineAdjust));
        return this;
    }

    public long getMacintoshEncodings() {
        if (this.has(CTFontAttribute.MacintoshEncodings)) {
            CFNumber val = this.get(CTFontAttribute.MacintoshEncodings, CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public CTFontAttributes setMacintoshEncodings(long macintoshEncodings) {
        this.set(CTFontAttribute.MacintoshEncodings, CFNumber.valueOf(macintoshEncodings));
        return this;
    }

    public float getFixedAdvance() {
        if (this.has(CTFontAttribute.FixedAdvance)) {
            CFNumber val = this.get(CTFontAttribute.FixedAdvance, CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTFontAttributes setFixedAdvance(float fixedAdvance) {
        this.set(CTFontAttribute.FixedAdvance, CFNumber.valueOf(fixedAdvance));
        return this;
    }

    public CTFontOrientation getOrientation() {
        if (this.has(CTFontAttribute.Orientation)) {
            CFNumber val = this.get(CTFontAttribute.Orientation, CFNumber.class);
            return CTFontOrientation.valueOf(val.longValue());
        }
        return null;
    }

    public CTFontAttributes setOrientation(CTFontOrientation orientation) {
        this.set(CTFontAttribute.Orientation, CFNumber.valueOf(orientation.value()));
        return this;
    }

    public CTFontFormat getFormat() {
        if (this.has(CTFontAttribute.Format)) {
            CFNumber val = this.get(CTFontAttribute.Format, CFNumber.class);
            return CTFontFormat.valueOf(val.longValue());
        }
        return null;
    }

    public CTFontAttributes setFormat(CTFontFormat format) {
        this.set(CTFontAttribute.Format, CFNumber.valueOf(format.value()));
        return this;
    }

    public CTFontManagerScope getRegistrationScope() {
        if (this.has(CTFontAttribute.RegistrationScope)) {
            CFNumber val = this.get(CTFontAttribute.RegistrationScope, CFNumber.class);
            return CTFontManagerScope.valueOf(val.longValue());
        }
        return null;
    }

    public CTFontAttributes setRegistrationScope(CTFontManagerScope registrationScope) {
        this.set(CTFontAttribute.RegistrationScope, CFNumber.valueOf(registrationScope.value()));
        return this;
    }

    public CTFontPriority getPriority() {
        if (this.has(CTFontAttribute.Priority)) {
            CFNumber val = this.get(CTFontAttribute.Priority, CFNumber.class);
            return CTFontPriority.valueOf(val.longValue());
        }
        return null;
    }

    public CTFontAttributes setPriority(CTFontPriority priority) {
        this.set(CTFontAttribute.Priority, CFNumber.valueOf(priority.value()));
        return this;
    }

    public boolean isEnabled() {
        if (this.has(CTFontAttribute.Enabled)) {
            CFBoolean val = this.get(CTFontAttribute.Enabled, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CTFontAttributes setEnabled(boolean enabled) {
        this.set(CTFontAttribute.Enabled, CFBoolean.valueOf(enabled));
        return this;
    }

    public boolean isDownloadable() {
        if (this.has(CTFontAttribute.Downloadable)) {
            CFBoolean val = this.get(CTFontAttribute.Downloadable, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CTFontAttributes setDownloadable(boolean downloadable) {
        this.set(CTFontAttribute.Downloadable, CFBoolean.valueOf(downloadable));
        return this;
    }

    public boolean isDownloaded() {
        if (this.has(CTFontAttribute.Downloaded)) {
            CFBoolean val = this.get(CTFontAttribute.Downloaded, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CTFontAttributes setDownloaded(boolean downloaded) {
        this.set(CTFontAttribute.Downloaded, CFBoolean.valueOf(downloaded));
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CTFontAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CTFontAttributes> list = new ArrayList<CTFontAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CTFontAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CTFontAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CTFontAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CTFontAttributes toObject(Class<CTFontAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CTFontAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CTFontAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

