/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.coretext.CTAttributedStringAttribute;
import org.robovm.apple.coretext.CTBaselineClass;
import org.robovm.apple.coretext.CTFont;
import org.robovm.apple.coretext.CTGlyphInfo;
import org.robovm.apple.coretext.CTParagraphStyle;
import org.robovm.apple.coretext.CTRubyAnnotation;
import org.robovm.apple.coretext.CTUnderlineStyle;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreText")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CTAttributedStringAttributes
extends CFDictionaryWrapper {
    public CTAttributedStringAttributes(CFDictionary data) {
        super(data);
    }

    public CTAttributedStringAttributes() {
    }

    public boolean has(CTAttributedStringAttribute key) {
        return this.data.containsKey((NativeObject)key.value());
    }

    public <T extends NativeObject> T get(CTAttributedStringAttribute key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get((NativeObject)key.value(), type);
        }
        return null;
    }

    public CTAttributedStringAttributes set(CTAttributedStringAttribute key, NativeObject value) {
        this.data.put((NativeObject)key.value(), value);
        return this;
    }

    public CTFont getFont() {
        if (this.has(CTAttributedStringAttribute.Font)) {
            CTFont val = this.get(CTAttributedStringAttribute.Font, CTFont.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setFont(CTFont font) {
        this.set(CTAttributedStringAttribute.Font, font);
        return this;
    }

    public boolean usesForegroundColorFromContext() {
        if (this.has(CTAttributedStringAttribute.ForegroundColorFromContext)) {
            CFBoolean val = this.get(CTAttributedStringAttribute.ForegroundColorFromContext, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CTAttributedStringAttributes setUsesForegroundColorFromContext(boolean usesForegroundColorFromContext) {
        this.set(CTAttributedStringAttribute.ForegroundColorFromContext, CFBoolean.valueOf(usesForegroundColorFromContext));
        return this;
    }

    public float getKern() {
        if (this.has(CTAttributedStringAttribute.Kern)) {
            CFNumber val = this.get(CTAttributedStringAttribute.Kern, CFNumber.class);
            return val.floatValue();
        }
        return 0.0f;
    }

    public CTAttributedStringAttributes setKern(float kern) {
        this.set(CTAttributedStringAttribute.Kern, CFNumber.valueOf(kern));
        return this;
    }

    public int getLigature() {
        if (this.has(CTAttributedStringAttribute.Ligature)) {
            CFNumber val = this.get(CTAttributedStringAttribute.Ligature, CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CTAttributedStringAttributes setLigature(int ligature) {
        this.set(CTAttributedStringAttribute.Ligature, CFNumber.valueOf(ligature));
        return this;
    }

    public CGColor getForegroundColor() {
        if (this.has(CTAttributedStringAttribute.ForegroundColor)) {
            CGColor val = this.get(CTAttributedStringAttribute.ForegroundColor, CGColor.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setForegroundColor(CGColor foregroundColor) {
        this.set(CTAttributedStringAttribute.ForegroundColor, foregroundColor);
        return this;
    }

    public CTParagraphStyle getParagraphStyle() {
        if (this.has(CTAttributedStringAttribute.ParagraphStyle)) {
            CTParagraphStyle val = this.get(CTAttributedStringAttribute.ParagraphStyle, CTParagraphStyle.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setParagraphStyle(CTParagraphStyle paragraphStyle) {
        this.set(CTAttributedStringAttribute.ParagraphStyle, paragraphStyle);
        return this;
    }

    public double getStrokeWidth() {
        if (this.has(CTAttributedStringAttribute.StrokeWidth)) {
            CFNumber val = this.get(CTAttributedStringAttribute.StrokeWidth, CFNumber.class);
            return val.doubleValue();
        }
        return 0.0;
    }

    public CTAttributedStringAttributes setStrokeWidth(double strokeWidth) {
        this.set(CTAttributedStringAttribute.StrokeWidth, CFNumber.valueOf(strokeWidth));
        return this;
    }

    public CGColor getStrokeColor() {
        if (this.has(CTAttributedStringAttribute.StrokeColor)) {
            CGColor val = this.get(CTAttributedStringAttribute.StrokeColor, CGColor.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setStrokeColor(CGColor strokeColor) {
        this.set(CTAttributedStringAttribute.StrokeColor, strokeColor);
        return this;
    }

    public CTUnderlineStyle getUnderlineStyle() {
        if (this.has(CTAttributedStringAttribute.UnderlineStyle)) {
            CFNumber val = this.get(CTAttributedStringAttribute.UnderlineStyle, CFNumber.class);
            return new CTUnderlineStyle(val.longValue());
        }
        return null;
    }

    public CTAttributedStringAttributes setUnderlineStyle(CTUnderlineStyle underlineStyle) {
        this.set(CTAttributedStringAttribute.UnderlineStyle, CFNumber.valueOf(underlineStyle.value()));
        return this;
    }

    public int getSuperscript() {
        if (this.has(CTAttributedStringAttribute.Superscript)) {
            CFNumber val = this.get(CTAttributedStringAttribute.Superscript, CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public CTAttributedStringAttributes setSuperscript(int superscript) {
        this.set(CTAttributedStringAttribute.Superscript, CFNumber.valueOf(superscript));
        return this;
    }

    public CGColor getUnderlineColor() {
        if (this.has(CTAttributedStringAttribute.UnderlineColor)) {
            CGColor val = this.get(CTAttributedStringAttribute.UnderlineColor, CGColor.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setUnderlineColor(CGColor underlineColor) {
        this.set(CTAttributedStringAttribute.UnderlineColor, underlineColor);
        return this;
    }

    public boolean usesVerticalForms() {
        if (this.has(CTAttributedStringAttribute.VerticalForms)) {
            CFBoolean val = this.get(CTAttributedStringAttribute.VerticalForms, CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CTAttributedStringAttributes setUsesVerticalForms(boolean usesVerticalForms) {
        this.set(CTAttributedStringAttribute.VerticalForms, CFBoolean.valueOf(usesVerticalForms));
        return this;
    }

    public CTGlyphInfo getGlyphInfo() {
        if (this.has(CTAttributedStringAttribute.GlyphInfo)) {
            CTGlyphInfo val = this.get(CTAttributedStringAttribute.GlyphInfo, CTGlyphInfo.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setGlyphInfo(CTGlyphInfo glyphInfo) {
        this.set(CTAttributedStringAttribute.GlyphInfo, glyphInfo);
        return this;
    }

    public String getLanguage() {
        if (this.has(CTAttributedStringAttribute.Language)) {
            CFString val = this.get(CTAttributedStringAttribute.Language, CFString.class);
            return val.toString();
        }
        return null;
    }

    public CTAttributedStringAttributes setLanguage(String language) {
        this.set(CTAttributedStringAttribute.Language, new CFString(language));
        return this;
    }

    public CTBaselineClass getBaselineClass() {
        if (this.has(CTAttributedStringAttribute.BaselineClass)) {
            CFString val = this.get(CTAttributedStringAttribute.BaselineClass, CFString.class);
            return CTBaselineClass.valueOf(val);
        }
        return null;
    }

    public CTAttributedStringAttributes setBaselineClass(CTBaselineClass baselineClass) {
        this.set(CTAttributedStringAttribute.BaselineClass, (NativeObject)baselineClass.value());
        return this;
    }

    public CTRubyAnnotation getRubyAnnotation() {
        if (this.has(CTAttributedStringAttribute.RubyAnnotation)) {
            CTRubyAnnotation val = this.get(CTAttributedStringAttribute.RubyAnnotation, CTRubyAnnotation.class);
            return val;
        }
        return null;
    }

    public CTAttributedStringAttributes setRubyAnnotation(CTRubyAnnotation rubyAnnotation) {
        this.set(CTAttributedStringAttribute.RubyAnnotation, rubyAnnotation);
        return this;
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CTAttributedStringAttributes> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CTAttributedStringAttributes> list = new ArrayList<CTAttributedStringAttributes>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CTAttributedStringAttributes(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CTAttributedStringAttributes> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CTAttributedStringAttributes i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CTAttributedStringAttributes toObject(Class<CTAttributedStringAttributes> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CTAttributedStringAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CTAttributedStringAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

