/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CFNetwork")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CFSystemProxySettings
extends CFDictionaryWrapper {
    CFSystemProxySettings(CFDictionary data) {
        super(data);
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public boolean isHTTPProxyEnabled() {
        if (this.has(Keys.HTTPEnable())) {
            CFBoolean val = this.get(Keys.HTTPEnable(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public int getHTTPProxyPort() {
        if (this.has(Keys.HTTPPort())) {
            CFNumber val = this.get(Keys.HTTPPort(), CFNumber.class);
            return val.intValue();
        }
        return 0;
    }

    public String getHTTPProxyHost() {
        if (this.has(Keys.HTTPProxy())) {
            CFString val = this.get(Keys.HTTPProxy(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public boolean isAutoConfigurationEnabled() {
        if (this.has(Keys.ProxyAutoConfigEnable())) {
            CFBoolean val = this.get(Keys.ProxyAutoConfigEnable(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public String getAutoConfigurationURL() {
        if (this.has(Keys.ProxyAutoConfigURLString())) {
            CFString val = this.get(Keys.ProxyAutoConfigURLString(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getAutoConfigurationJavaScript() {
        if (this.has(Keys.ProxyAutoConfigJavaScript())) {
            CFString val = this.get(Keys.ProxyAutoConfigJavaScript(), CFString.class);
            return val.toString();
        }
        return null;
    }

    @Library(value="CFNetwork")
    public static class Keys {
        @GlobalValue(symbol="kCFNetworkProxiesHTTPEnable", optional=true)
        public static native CFString HTTPEnable();

        @GlobalValue(symbol="kCFNetworkProxiesHTTPPort", optional=true)
        public static native CFString HTTPPort();

        @GlobalValue(symbol="kCFNetworkProxiesHTTPProxy", optional=true)
        public static native CFString HTTPProxy();

        @GlobalValue(symbol="kCFNetworkProxiesProxyAutoConfigEnable", optional=true)
        public static native CFString ProxyAutoConfigEnable();

        @GlobalValue(symbol="kCFNetworkProxiesProxyAutoConfigURLString", optional=true)
        public static native CFString ProxyAutoConfigURLString();

        @GlobalValue(symbol="kCFNetworkProxiesProxyAutoConfigJavaScript", optional=true)
        public static native CFString ProxyAutoConfigJavaScript();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFSystemProxySettings> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFSystemProxySettings> list = new ArrayList<CFSystemProxySettings>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CFSystemProxySettings(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFSystemProxySettings> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFSystemProxySettings i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFSystemProxySettings toObject(Class<CFSystemProxySettings> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CFSystemProxySettings(o);
        }

        @MarshalsPointer
        public static long toNative(CFSystemProxySettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

