/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreservices.CFStreamSocketSecurityLevel;
import org.robovm.apple.foundation.NSArray;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CFNetwork")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CFStreamSSLSettings
extends CFDictionaryWrapper {
    CFStreamSSLSettings(CFDictionary data) {
        super(data);
    }

    public CFStreamSSLSettings() {
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public CFStreamSSLSettings set(CFString key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public boolean isValidatesCertificateChain() {
        if (this.has(Keys.ValidatesCertificateChain())) {
            CFBoolean val = this.get(Keys.ValidatesCertificateChain(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CFStreamSSLSettings setValidatesCertificateChain(boolean validatesCertificateChain) {
        this.set(Keys.ValidatesCertificateChain(), CFBoolean.valueOf(validatesCertificateChain));
        return this;
    }

    public CFStreamSocketSecurityLevel getSecurityLevel() {
        if (this.has(Keys.Level())) {
            CFString val = this.get(Keys.Level(), CFString.class);
            return CFStreamSocketSecurityLevel.valueOf(val);
        }
        return null;
    }

    public CFStreamSSLSettings setSecurityLevel(CFStreamSocketSecurityLevel securityLevel) {
        this.set(Keys.Level(), (NativeObject)securityLevel.value());
        return this;
    }

    public String getPeerName() {
        if (this.has(Keys.PeerName())) {
            CFString val = this.get(Keys.PeerName(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public CFStreamSSLSettings setPeerName(String peerName) {
        this.set(Keys.PeerName(), new CFString(peerName));
        return this;
    }

    public NSArray<?> getCertificates() {
        if (this.has(Keys.Certificates())) {
            NSArray val = this.get(Keys.Certificates(), NSArray.class);
            return val;
        }
        return null;
    }

    public CFStreamSSLSettings setCertificates(NSArray<?> certificates) {
        this.set(Keys.Certificates(), (NativeObject)certificates);
        return this;
    }

    public boolean isServer() {
        if (this.has(Keys.IsServer())) {
            CFBoolean val = this.get(Keys.IsServer(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CFStreamSSLSettings setIsServer(boolean isServer) {
        this.set(Keys.IsServer(), CFBoolean.valueOf(isServer));
        return this;
    }

    @Library(value="CFNetwork")
    public static class Keys {
        @GlobalValue(symbol="kCFStreamSSLValidatesCertificateChain", optional=true)
        public static native CFString ValidatesCertificateChain();

        @GlobalValue(symbol="kCFStreamSSLLevel", optional=true)
        public static native CFString Level();

        @GlobalValue(symbol="kCFStreamSSLPeerName", optional=true)
        public static native CFString PeerName();

        @GlobalValue(symbol="kCFStreamSSLCertificates", optional=true)
        public static native CFString Certificates();

        @GlobalValue(symbol="kCFStreamSSLIsServer", optional=true)
        public static native CFString IsServer();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFStreamSSLSettings> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFStreamSSLSettings> list = new ArrayList<CFStreamSSLSettings>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CFStreamSSLSettings(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFStreamSSLSettings> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFStreamSSLSettings i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFStreamSSLSettings toObject(Class<CFStreamSSLSettings> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CFStreamSSLSettings(o);
        }

        @MarshalsPointer
        public static long toNative(CFStreamSSLSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

