/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFRunLoop;
import org.robovm.apple.corefoundation.CFRunLoopMode;
import org.robovm.apple.corefoundation.CFStreamError;
import org.robovm.apple.corefoundation.CFStreamErrorException;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreservices.CFNetServiceClientContext;
import org.robovm.apple.coreservices.CFNetServiceOptions;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSInputStream;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOutputStream;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CFNetwork")
public class CFNetService
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static final LongMap<ClientCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    protected CFNetService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(CFNetService service, CFStreamError.CFStreamErrorPtr error, @Pointer long refcon) {
        ClientCallback callback = null;
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (ClientCallback)callbacks.get(refcon);
        }
        CFStreamError err = null;
        if (error != null) {
            err = (CFStreamError)error.get();
        }
        callback.invoke(service, err);
    }

    public static CFNetService create(String domain, String serviceType, String name, int port) {
        long refconId = CFNetService.refconId.getAndIncrement();
        CFNetService host = CFNetService.create(null, domain, serviceType, name, port);
        if (host != null) {
            host.localRefconId = refconId;
        }
        return host;
    }

    public static CFNetService createCopy(CFNetService service) {
        CFNetService s = CFNetService.createCopy(null, service);
        if (service != null) {
            s.localRefconId = service.localRefconId;
        }
        return s;
    }

    public static NSDictionary<NSString, NSData> parseTXTData(NSData txtRecord) {
        return CFNetService.parseTXTData(null, txtRecord);
    }

    public static NSData createTXTData(NSDictionary<NSString, NSData> keyValuePairs) {
        return CFNetService.createTXTData(null, keyValuePairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCallback(ClientCallback callback) {
        CFNetServiceClientContext context = new CFNetServiceClientContext();
        context.setInfo(this.localRefconId);
        LongMap<ClientCallback> longMap = callbacks;
        synchronized (longMap) {
            callbacks.put(this.localRefconId, (Object)callback);
        }
        this.setCallback(new FunctionPtr(cbInvoke), context);
    }

    public NSInputStream createSocketReadStream() {
        NSInputStream.NSInputStreamPtr ptr = new NSInputStream.NSInputStreamPtr();
        CFNetService.createSocketStreamPair(null, this, ptr, null);
        return (NSInputStream)ptr.get();
    }

    public NSOutputStream createSocketWriteStream() {
        NSOutputStream.NSOutputStreamPtr ptr = new NSOutputStream.NSOutputStreamPtr();
        CFNetService.createSocketStreamPair(null, this, null, ptr);
        return (NSOutputStream)ptr.get();
    }

    public void scheduleInRunLoop(CFRunLoop runLoop, CFRunLoopMode runLoopMode) {
        this.scheduleInRunLoop(runLoop, runLoopMode.value());
    }

    public void removeFromRunLoop(CFRunLoop runLoop, CFRunLoopMode runLoopMode) {
        this.scheduleInRunLoop(runLoop, runLoopMode.value());
    }

    @Bridge(symbol="CFNetServiceGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFNetServiceCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFNetService create(CFAllocator var0, String var1, String var2, String var3, int var4);

    @Bridge(symbol="CFNetServiceCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFNetService createCopy(CFAllocator var0, CFNetService var1);

    @Bridge(symbol="CFNetServiceGetDomain", optional=true)
    public native String getDomain();

    @Bridge(symbol="CFNetServiceGetType", optional=true)
    public native String getType();

    @Bridge(symbol="CFNetServiceGetName", optional=true)
    public native String getName();

    public boolean register(CFNetServiceOptions options) throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        boolean result = this.register(options, ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFNetServiceRegisterWithOptions", optional=true)
    private native boolean register(CFNetServiceOptions var1, CFStreamError.CFStreamErrorPtr var2);

    public boolean resolve(double timeout) throws CFStreamErrorException {
        CFStreamError.CFStreamErrorPtr ptr = new CFStreamError.CFStreamErrorPtr();
        boolean result = this.resolve(timeout, ptr);
        if (ptr.get() != null) {
            throw new CFStreamErrorException((CFStreamError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CFNetServiceResolveWithTimeout", optional=true)
    private native boolean resolve(double var1, CFStreamError.CFStreamErrorPtr var3);

    @Bridge(symbol="CFNetServiceCancel", optional=true)
    public native void cancel();

    @Bridge(symbol="CFNetServiceGetTargetHost", optional=true)
    public native String getTargetHost();

    @Bridge(symbol="CFNetServiceGetPortNumber", optional=true)
    public native int getPortNumber();

    @Bridge(symbol="CFNetServiceGetAddressing", optional=true)
    public native NSArray<NSData> getAddressing();

    @Bridge(symbol="CFNetServiceGetTXTData", optional=true)
    public native NSData getTXTData();

    @Bridge(symbol="CFNetServiceSetTXTData", optional=true)
    public native boolean setTXTData(NSData var1);

    @Bridge(symbol="CFNetServiceCreateDictionaryWithTXTData", optional=true)
    protected static native NSDictionary<NSString, NSData> parseTXTData(CFAllocator var0, NSData var1);

    @Bridge(symbol="CFNetServiceCreateTXTDataWithDictionary", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    protected static native NSData createTXTData(CFAllocator var0, NSDictionary<NSString, NSData> var1);

    @Bridge(symbol="CFNetServiceSetClient", optional=true)
    private native boolean setCallback(FunctionPtr var1, CFNetServiceClientContext var2);

    @Bridge(symbol="CFNetServiceScheduleWithRunLoop", optional=true)
    public native void scheduleInRunLoop(CFRunLoop var1, String var2);

    @Bridge(symbol="CFNetServiceUnscheduleFromRunLoop", optional=true)
    public native void unscheduleFromRunLoop(CFRunLoop var1, String var2);

    @Bridge(symbol="CFStreamCreatePairWithSocketToNetService", optional=true)
    private static native void createSocketStreamPair(CFAllocator var0, CFNetService var1, NSInputStream.NSInputStreamPtr var2, NSOutputStream.NSOutputStreamPtr var3);

    static {
        try {
            cbInvoke = CFNetService.class.getDeclaredMethod("cbInvoke", CFNetService.class, CFStreamError.CFStreamErrorPtr.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFNetService.class);
    }

    public static interface ClientCallback {
        public void invoke(CFNetService var1, CFStreamError var2);
    }

    public static class CFNetServicePtr
    extends Ptr<CFNetService, CFNetServicePtr> {
    }
}

