/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CFNetwork")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CFFTPResource
extends CFDictionaryWrapper {
    CFFTPResource(CFDictionary data) {
        super(data);
    }

    public boolean has(CFString key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFString key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public long getMode() {
        if (this.has(Keys.Mode())) {
            CFNumber val = this.get(Keys.Mode(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public String getName() {
        if (this.has(Keys.Name())) {
            CFString val = this.get(Keys.Name(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getOwner() {
        if (this.has(Keys.Owner())) {
            CFString val = this.get(Keys.Owner(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getGroup() {
        if (this.has(Keys.Group())) {
            CFString val = this.get(Keys.Group(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public String getLink() {
        if (this.has(Keys.Link())) {
            CFString val = this.get(Keys.Link(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public long getSize() {
        if (this.has(Keys.Size())) {
            CFNumber val = this.get(Keys.Size(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public long getType() {
        if (this.has(Keys.Type())) {
            CFNumber val = this.get(Keys.Type(), CFNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    @Library(value="CFNetwork")
    public static class Keys {
        @GlobalValue(symbol="kCFFTPResourceMode", optional=true)
        public static native CFString Mode();

        @GlobalValue(symbol="kCFFTPResourceName", optional=true)
        public static native CFString Name();

        @GlobalValue(symbol="kCFFTPResourceOwner", optional=true)
        public static native CFString Owner();

        @GlobalValue(symbol="kCFFTPResourceGroup", optional=true)
        public static native CFString Group();

        @GlobalValue(symbol="kCFFTPResourceLink", optional=true)
        public static native CFString Link();

        @GlobalValue(symbol="kCFFTPResourceSize", optional=true)
        public static native CFString Size();

        @GlobalValue(symbol="kCFFTPResourceType", optional=true)
        public static native CFString Type();

        @GlobalValue(symbol="kCFFTPResourceModDate", optional=true)
        public static native CFString ModDate();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFFTPResource> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFFTPResource> list = new ArrayList<CFFTPResource>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new CFFTPResource(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFFTPResource> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFFTPResource i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFFTPResource toObject(Class<CFFTPResource> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CFFTPResource(o);
        }

        @MarshalsPointer
        public static long toNative(CFFTPResource o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

