/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremidi;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coremidi.MIDIClient;
import org.robovm.apple.coremidi.MIDIEndpoint;
import org.robovm.apple.coremidi.MIDIError;
import org.robovm.apple.coremidi.MIDIObject;
import org.robovm.apple.coremidi.MIDIPacketList;
import org.robovm.apple.coremidi.MIDIReadProc;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMIDI")
public class MIDIPort
extends MIDIObject {
    private static AtomicLong refconId = new AtomicLong();
    protected long localRefconId;
    private static LongMap<MIDIReadProc> readProcs = new LongMap();
    private static final Method cbReadProc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReadProc(MIDIPacketList pktlist, @Pointer long readProcRefCon, @Pointer long srcConnRefCon) {
        MIDIReadProc callback = null;
        LongMap<MIDIReadProc> longMap = readProcs;
        synchronized (longMap) {
            callback = (MIDIReadProc)readProcs.get(readProcRefCon);
        }
        callback.read(pktlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MIDIPort createInputPort(MIDIClient client, String portName, MIDIReadProc readProc) {
        MIDIPortPtr ptr;
        long refconId = MIDIPort.refconId.getAndIncrement();
        MIDIError err = MIDIPort.createInputPort(client, portName, new FunctionPtr(cbReadProc), refconId, ptr = new MIDIPortPtr());
        if (err == MIDIError.No) {
            LongMap<MIDIReadProc> longMap = readProcs;
            synchronized (longMap) {
                readProcs.put(refconId, (Object)readProc);
            }
            MIDIPort port = (MIDIPort)ptr.get();
            port.localRefconId = refconId;
            return port;
        }
        return null;
    }

    public static MIDIPort createOutputPort(MIDIClient client, String portName) {
        long refconId = MIDIPort.refconId.getAndIncrement();
        MIDIPortPtr ptr = new MIDIPortPtr();
        MIDIPort.createOutputPort(client, portName, ptr);
        MIDIPort port = (MIDIPort)ptr.get();
        port.localRefconId = refconId;
        return port;
    }

    public MIDIError connectSource(MIDIEndpoint source) {
        return this.connectSource(source, this.localRefconId);
    }

    @Bridge(symbol="MIDIInputPortCreate", optional=true)
    protected static native MIDIError createInputPort(MIDIClient var0, String var1, FunctionPtr var2, @Pointer long var3, MIDIPortPtr var5);

    @Bridge(symbol="MIDIOutputPortCreate", optional=true)
    protected static native MIDIError createOutputPort(MIDIClient var0, String var1, MIDIPortPtr var2);

    @Bridge(symbol="MIDIPortDispose", optional=true)
    public native MIDIError dispose();

    @Bridge(symbol="MIDIPortConnectSource", optional=true)
    protected native MIDIError connectSource(MIDIEndpoint var1, @Pointer long var2);

    @Bridge(symbol="MIDIPortDisconnectSource", optional=true)
    public native MIDIError disconnectSource(MIDIEndpoint var1);

    static {
        try {
            cbReadProc = MIDIPort.class.getDeclaredMethod("cbReadProc", MIDIPacketList.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(MIDIPort.class);
    }

    public static class MIDIPortPtr
    extends Ptr<MIDIPort, MIDIPortPtr> {
    }
}

