/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.util.List;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMBlockBuffer;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMVideoCodecType;
import org.robovm.apple.coremedia.CMVideoDimensions;
import org.robovm.apple.coremedia.CMVideoFormatDescriptionExtension;
import org.robovm.apple.corevideo.CVImageBuffer;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMedia")
public class CMVideoFormatDescription
extends CMFormatDescription {
    public static CMVideoFormatDescription create(CMVideoCodecType codecType, int width, int height, CMVideoFormatDescriptionExtension extensions) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.create0(null, codecType, width, height, extensions, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMVideoFormatDescription create(CVImageBuffer imageBuffer) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.create0(null, imageBuffer, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMVideoFormatDescription createFromBigEndianImageDescriptionData(BytePtr imageDescriptionData, @MachineSizedUInt long imageDescriptionSize, int imageDescriptionStringEncoding, String imageDescriptionFlavor) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.createFromBigEndianImageDescriptionData0(null, imageDescriptionData, imageDescriptionSize, imageDescriptionStringEncoding, imageDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMVideoFormatDescription createFromBigEndianImageDescriptionBlockBuffer(CMBlockBuffer imageDescriptionBlockBuffer, int imageDescriptionStringEncoding, String imageDescriptionFlavor) throws OSStatusException {
        CMVideoFormatDescriptionPtr ptr = new CMVideoFormatDescriptionPtr();
        OSStatus status = CMVideoFormatDescription.createFromBigEndianImageDescriptionBlockBuffer0(null, imageDescriptionBlockBuffer, imageDescriptionStringEncoding, imageDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMVideoFormatDescription)ptr.get();
    }

    public static CMBlockBuffer copyAsBigEndianImageDescriptionBlockBuffer(CFAllocator allocator, CMVideoFormatDescription videoFormatDescription, int imageDescriptionStringEncoding, String imageDescriptionFlavor) throws OSStatusException {
        CMBlockBuffer.CMBlockBufferPtr ptr = new CMBlockBuffer.CMBlockBufferPtr();
        OSStatus status = CMVideoFormatDescription.copyAsBigEndianImageDescriptionBlockBuffer0(null, videoFormatDescription, imageDescriptionStringEncoding, imageDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    @Bridge(symbol="CMVideoFormatDescriptionCreate", optional=true)
    private static native OSStatus create0(CFAllocator var0, CMVideoCodecType var1, int var2, int var3, CMVideoFormatDescriptionExtension var4, CMVideoFormatDescriptionPtr var5);

    @Bridge(symbol="CMVideoFormatDescriptionCreateForImageBuffer", optional=true)
    private static native OSStatus create0(CFAllocator var0, CVImageBuffer var1, CMVideoFormatDescriptionPtr var2);

    @Bridge(symbol="CMVideoFormatDescriptionGetDimensions", optional=true)
    @ByVal
    public native CMVideoDimensions getDimensions();

    @Bridge(symbol="CMVideoFormatDescriptionGetPresentationDimensions", optional=true)
    @ByVal
    public native CGSize getPresentationDimensions(boolean var1, boolean var2);

    @Bridge(symbol="CMVideoFormatDescriptionGetCleanAperture", optional=true)
    @ByVal
    public native CGRect getCleanAperture(boolean var1);

    @Bridge(symbol="CMVideoFormatDescriptionGetExtensionKeysCommonWithImageBuffers", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    public static native List<String> getExtensionKeysCommonWithImageBuffers();

    @Bridge(symbol="CMVideoFormatDescriptionMatchesImageBuffer", optional=true)
    public native boolean matchesImageBuffer(CVImageBuffer var1);

    @Bridge(symbol="CMVideoFormatDescriptionCreateFromBigEndianImageDescriptionData", optional=true)
    private static native OSStatus createFromBigEndianImageDescriptionData0(CFAllocator var0, BytePtr var1, @MachineSizedUInt long var2, int var4, String var5, CMVideoFormatDescriptionPtr var6);

    @Bridge(symbol="CMVideoFormatDescriptionCreateFromBigEndianImageDescriptionBlockBuffer", optional=true)
    private static native OSStatus createFromBigEndianImageDescriptionBlockBuffer0(CFAllocator var0, CMBlockBuffer var1, int var2, String var3, CMVideoFormatDescriptionPtr var4);

    @Bridge(symbol="CMVideoFormatDescriptionCopyAsBigEndianImageDescriptionBlockBuffer", optional=true)
    private static native OSStatus copyAsBigEndianImageDescriptionBlockBuffer0(CFAllocator var0, CMVideoFormatDescription var1, int var2, String var3, CMBlockBuffer.CMBlockBufferPtr var4);

    static {
        Bro.bind(CMVideoFormatDescription.class);
    }

    public static class CMVideoFormatDescriptionPtr
    extends Ptr<CMVideoFormatDescription, CMVideoFormatDescriptionPtr> {
    }
}

