/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coremedia.CMBlockBuffer;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMMediaType;
import org.robovm.apple.coremedia.CMTextDisplayFlags;
import org.robovm.apple.coremedia.CMTextFormatDescriptionExtension;
import org.robovm.apple.coremedia.CMTextFormatType;
import org.robovm.apple.coremedia.CMTextJustification;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;

@Library(value="CoreMedia")
public class CMTextFormatDescription
extends CMFormatDescription {
    public static CMTextFormatDescription create(CMMediaType mediaType, CMTextFormatType mediaSubtype, CMTextFormatDescriptionExtension extensions) throws OSStatusException {
        CMFormatDescription.CMFormatDescriptionPtr ptr = new CMFormatDescription.CMFormatDescriptionPtr();
        OSStatus status = CMTextFormatDescription.create0(null, mediaType, (int)mediaSubtype.value(), extensions.getDictionary(), ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            return (CMTextFormatDescription)((CMFormatDescription)ptr.get()).as(CMTextFormatDescription.class);
        }
        return null;
    }

    public CMTextFormatDescriptionExtension getExtensions() {
        return new CMTextFormatDescriptionExtension(this.getExtensionDictionary());
    }

    public CMTextFormatType getTextFormatType() {
        return CMTextFormatType.valueOf(this.getMediaSubType());
    }

    public static CMTextFormatDescription createFromBigEndianTextDescriptionData(BytePtr textDescriptionData, @MachineSizedUInt long textDescriptionSize, String textDescriptionFlavor, CMMediaType mediaType) throws OSStatusException {
        CMTextFormatDescriptionPtr ptr = new CMTextFormatDescriptionPtr();
        OSStatus status = CMTextFormatDescription.createFromBigEndianTextDescriptionData0(null, textDescriptionData, textDescriptionSize, textDescriptionFlavor, mediaType, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMTextFormatDescription)ptr.get();
    }

    public static CMTextFormatDescription createFromBigEndianTextDescriptionBlockBuffer(CMBlockBuffer textDescriptionBlockBuffer, String textDescriptionFlavor, CMMediaType mediaType) throws OSStatusException {
        CMTextFormatDescriptionPtr ptr = new CMTextFormatDescriptionPtr();
        OSStatus status = CMTextFormatDescription.createFromBigEndianTextDescriptionBlockBuffer0(null, textDescriptionBlockBuffer, textDescriptionFlavor, mediaType, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMTextFormatDescription)ptr.get();
    }

    public CMTextDisplayFlags getDisplayFlags() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getDisplayFlags0(ptr);
        OSStatusException.throwIfNecessary(status);
        return new CMTextDisplayFlags(ptr.get());
    }

    public CMTextJustification getHorizontalJustification() throws OSStatusException {
        BytePtr ptr = new BytePtr();
        OSStatus status = this.getJustification0(ptr, null);
        OSStatusException.throwIfNecessary(status);
        return CMTextJustification.valueOf(ptr.get());
    }

    public CMTextJustification getVerticalJustification() throws OSStatusException {
        BytePtr ptr = new BytePtr();
        OSStatus status = this.getJustification0(null, ptr);
        OSStatusException.throwIfNecessary(status);
        return CMTextJustification.valueOf(ptr.get());
    }

    @ByVal
    public CGRect getDefaultTextBox(boolean originIsAtTopLeft, @MachineSizedFloat double heightOfTextTrack) throws OSStatusException {
        CGRect.CGRectPtr ptr = new CGRect.CGRectPtr();
        OSStatus status = this.getDefaultTextBox0(originIsAtTopLeft, heightOfTextTrack, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CGRect)ptr.get();
    }

    public short getDefaultStyleLocalFontID() throws OSStatusException {
        ShortPtr ptr = new ShortPtr();
        OSStatus status = this.getDefaultStyle0(ptr, null, null, null, null, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isDefaultStyleBold() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getDefaultStyle0(null, ptr, null, null, null, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isDefaultStyleItalic() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getDefaultStyle0(null, null, ptr, null, null, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isDefaultStyleUnderline() throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getDefaultStyle0(null, null, null, ptr, null, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    @MachineSizedFloat
    public double getDefaultStyleFontSize() throws OSStatusException {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        OSStatus status = this.getDefaultStyle0(null, null, null, null, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public CMBlockBuffer copyAsBigEndianTextDescriptionBlockBuffer(String textDescriptionFlavor) throws OSStatusException {
        CMBlockBuffer.CMBlockBufferPtr ptr = new CMBlockBuffer.CMBlockBufferPtr();
        OSStatus status = CMTextFormatDescription.copyAsBigEndianTextDescriptionBlockBuffer0(null, this, textDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    @Bridge(symbol="CMTextFormatDescriptionGetDisplayFlags", optional=true)
    protected native OSStatus getDisplayFlags0(IntPtr var1);

    @Bridge(symbol="CMTextFormatDescriptionGetJustification", optional=true)
    protected native OSStatus getJustification0(BytePtr var1, BytePtr var2);

    @Bridge(symbol="CMTextFormatDescriptionGetDefaultTextBox", optional=true)
    protected native OSStatus getDefaultTextBox0(boolean var1, @MachineSizedFloat double var2, CGRect.CGRectPtr var4);

    @Bridge(symbol="CMTextFormatDescriptionGetDefaultStyle", optional=true)
    protected native OSStatus getDefaultStyle0(ShortPtr var1, BooleanPtr var2, BooleanPtr var3, BooleanPtr var4, MachineSizedFloatPtr var5, MachineSizedFloatPtr var6);

    @Bridge(symbol="CMTextFormatDescriptionGetFontName", optional=true)
    protected native OSStatus getFontName0(short var1, CFString.CFStringPtr var2);

    @Bridge(symbol="CMTextFormatDescriptionCreateFromBigEndianTextDescriptionData", optional=true)
    private static native OSStatus createFromBigEndianTextDescriptionData0(CFAllocator var0, BytePtr var1, @MachineSizedUInt long var2, String var4, CMMediaType var5, CMTextFormatDescriptionPtr var6);

    @Bridge(symbol="CMTextFormatDescriptionCreateFromBigEndianTextDescriptionBlockBuffer", optional=true)
    private static native OSStatus createFromBigEndianTextDescriptionBlockBuffer0(CFAllocator var0, CMBlockBuffer var1, String var2, CMMediaType var3, CMTextFormatDescriptionPtr var4);

    @Bridge(symbol="CMTextFormatDescriptionCopyAsBigEndianTextDescriptionBlockBuffer", optional=true)
    private static native OSStatus copyAsBigEndianTextDescriptionBlockBuffer0(CFAllocator var0, CMTextFormatDescription var1, String var2, CMBlockBuffer.CMBlockBufferPtr var3);

    static {
        Bro.bind(CMTextFormatDescription.class);
    }

    public static class CMTextFormatDescriptionPtr
    extends Ptr<CMTextFormatDescription, CMTextFormatDescriptionPtr> {
    }
}

