/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioStreamPacketDescription;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMAttachmentBearer;
import org.robovm.apple.coremedia.CMAttachmentMode;
import org.robovm.apple.coremedia.CMBlockBuffer;
import org.robovm.apple.coremedia.CMBuffer;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMSampleAttachment;
import org.robovm.apple.coremedia.CMSampleBufferAttachment;
import org.robovm.apple.coremedia.CMSampleBufferFlags;
import org.robovm.apple.coremedia.CMSampleTimingInfo;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.coremedia.CMVideoFormatDescription;
import org.robovm.apple.corevideo.CVImageBuffer;
import org.robovm.apple.corevideo.CVPixelBuffer;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.Block2;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.objc.block.VoidBlock4;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMedia")
public class CMSampleBuffer
extends CFType
implements CMBuffer {
    private static AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static final LongMap<InvalidateCallback> invalidateCallbacks = new LongMap();
    private static final LongMap<MakeDataReadyCallback> makeDataReadyCallbacks = new LongMap();
    private static final LongMap<ForEachCallback> forEachCallbacks = new LongMap();
    private static final Method cbInvalidate;
    private static final Method cbMakeDataReady;
    private static final Method cbForEach;

    protected CMSampleBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvalidate(CMSampleBuffer buffer, long refcon) {
        InvalidateCallback callback = null;
        LongMap<InvalidateCallback> longMap = invalidateCallbacks;
        synchronized (longMap) {
            callback = (InvalidateCallback)invalidateCallbacks.get(refcon);
        }
        callback.invalidate(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbMakeDataReady(CMSampleBuffer buffer, long refcon) {
        LongMap<MakeDataReadyCallback> longMap = makeDataReadyCallbacks;
        synchronized (longMap) {
            try {
                ((MakeDataReadyCallback)makeDataReadyCallbacks.get(refcon)).makeDataReady(buffer);
            }
            catch (OSStatusException e) {
                return e.getStatus();
            }
            return OSStatus.NO_ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbForEach(CMSampleBuffer buffer, long index, long refcon) {
        LongMap<ForEachCallback> longMap = forEachCallbacks;
        synchronized (longMap) {
            try {
                ((ForEachCallback)forEachCallbacks.get(refcon)).forEach(buffer, index);
            }
            catch (OSStatusException e) {
                return e.getStatus();
            }
            return OSStatus.NO_ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMSampleBuffer create(CMBlockBuffer dataBuffer, boolean dataReady, MakeDataReadyCallback callback, CMFormatDescription formatDescription, @MachineSizedSInt long numSamples, CMSampleTimingInfo[] sampleTimingArray, long[] sampleSizeArray) throws OSStatusException {
        if (sampleTimingArray == null) {
            throw new NullPointerException("sampleTimingArray");
        }
        if (sampleSizeArray == null) {
            throw new NullPointerException("sampleSizeArray");
        }
        long refconId = CMSampleBuffer.refconId.getAndIncrement();
        CMSampleTimingInfo sampleTimingPtr = (CMSampleTimingInfo)Struct.allocate(CMSampleTimingInfo.class, (int)sampleTimingArray.length);
        sampleTimingPtr.update(sampleTimingArray);
        MachineSizedUIntPtr sampleSizePtr = (MachineSizedUIntPtr)Struct.allocate(MachineSizedUIntPtr.class, (int)sampleSizeArray.length);
        sampleSizePtr.set(sampleSizeArray);
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.create0(null, dataBuffer, dataReady, new FunctionPtr(cbMakeDataReady), refconId, formatDescription, numSamples, sampleTimingArray.length, sampleTimingPtr, sampleSizeArray.length, sampleSizePtr, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            CMSampleBuffer buffer = (CMSampleBuffer)ptr.get();
            buffer.localRefconId = refconId;
            LongMap<MakeDataReadyCallback> longMap = makeDataReadyCallbacks;
            synchronized (longMap) {
                makeDataReadyCallbacks.put(refconId, (Object)callback);
            }
            return buffer;
        }
        return null;
    }

    public CMSampleBuffer createReady(CMBlockBuffer dataBuffer, CMFormatDescription formatDescription, @MachineSizedSInt long numSamples, CMSampleTimingInfo[] sampleTimingArray, long[] sampleSizeArray) throws OSStatusException {
        if (sampleTimingArray == null) {
            throw new NullPointerException("sampleTimingArray");
        }
        if (sampleSizeArray == null) {
            throw new NullPointerException("sampleSizeArray");
        }
        long refconId = CMSampleBuffer.refconId.getAndIncrement();
        CMSampleTimingInfo sampleTimingPtr = (CMSampleTimingInfo)Struct.allocate(CMSampleTimingInfo.class, (int)sampleTimingArray.length);
        sampleTimingPtr.update(sampleTimingArray);
        MachineSizedUIntPtr sampleSizePtr = (MachineSizedUIntPtr)Struct.allocate(MachineSizedUIntPtr.class, (int)sampleSizeArray.length);
        sampleSizePtr.set(sampleSizeArray);
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createReady0(null, dataBuffer, formatDescription, numSamples, sampleTimingArray.length, sampleTimingPtr, sampleSizeArray.length, sampleSizePtr, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            CMSampleBuffer buffer = (CMSampleBuffer)ptr.get();
            buffer.localRefconId = refconId;
            return buffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMSampleBuffer createAudioSampleBuffer(CMBlockBuffer dataBuffer, boolean dataReady, MakeDataReadyCallback callback, CMFormatDescription formatDescription, @MachineSizedSInt long numSamples, @ByVal CMTime sbufPTS, AudioStreamPacketDescription[] packetDescriptions) throws OSStatusException {
        long refconId = CMSampleBuffer.refconId.getAndIncrement();
        AudioStreamPacketDescription packetDescriptionPtr = (AudioStreamPacketDescription)Struct.allocate(AudioStreamPacketDescription.class, (int)((int)numSamples));
        packetDescriptionPtr.update(packetDescriptions);
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createAudioSampleBuffer0(null, dataBuffer, dataReady, new FunctionPtr(cbMakeDataReady), refconId, formatDescription, numSamples, sbufPTS, packetDescriptionPtr, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            CMSampleBuffer buffer = (CMSampleBuffer)ptr.get();
            buffer.localRefconId = refconId;
            LongMap<MakeDataReadyCallback> longMap = makeDataReadyCallbacks;
            synchronized (longMap) {
                makeDataReadyCallbacks.put(refconId, (Object)callback);
            }
            return buffer;
        }
        return null;
    }

    public static CMSampleBuffer createAudioSampleBuffer(CMBlockBuffer dataBuffer, CMFormatDescription formatDescription, @MachineSizedSInt long numSamples, @ByVal CMTime sbufPTS, AudioStreamPacketDescription[] packetDescriptions) throws OSStatusException {
        long refconId = CMSampleBuffer.refconId.getAndIncrement();
        AudioStreamPacketDescription packetDescriptionPtr = (AudioStreamPacketDescription)Struct.allocate(AudioStreamPacketDescription.class, (int)((int)numSamples));
        packetDescriptionPtr.update(packetDescriptions);
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createAudioSampleBuffer0(null, dataBuffer, formatDescription, numSamples, sbufPTS, packetDescriptionPtr, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            CMSampleBuffer buffer = (CMSampleBuffer)ptr.get();
            buffer.localRefconId = refconId;
            return buffer;
        }
        return null;
    }

    public static CMSampleBuffer createReady(CVImageBuffer imageBuffer, CMVideoFormatDescription formatDescription, CMSampleTimingInfo sampleTiming) throws OSStatusException {
        long refconId = CMSampleBuffer.refconId.getAndIncrement();
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createReadyWithImageBuffer0(null, imageBuffer, formatDescription, sampleTiming, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            CMSampleBuffer buffer = (CMSampleBuffer)ptr.get();
            buffer.localRefconId = refconId;
            return buffer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMSampleBuffer create(CVImageBuffer imageBuffer, boolean dataReady, MakeDataReadyCallback callback, CMVideoFormatDescription formatDescription, CMSampleTimingInfo sampleTiming) throws OSStatusException {
        CMSampleBufferPtr ptr;
        long refconId = CMSampleBuffer.refconId.getAndIncrement();
        OSStatus status = CMSampleBuffer.createForImageBuffer0(null, imageBuffer, dataReady, new FunctionPtr(cbMakeDataReady), refconId, formatDescription, sampleTiming, ptr = new CMSampleBufferPtr());
        if (OSStatusException.throwIfNecessary(status)) {
            CMSampleBuffer buffer = (CMSampleBuffer)ptr.get();
            buffer.localRefconId = refconId;
            LongMap<MakeDataReadyCallback> longMap = makeDataReadyCallbacks;
            synchronized (longMap) {
                makeDataReadyCallbacks.put(refconId, (Object)callback);
            }
            return buffer;
        }
        return null;
    }

    public CMSampleBuffer createCopy() throws OSStatusException {
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createCopy0(null, this, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMSampleBuffer)ptr.get();
    }

    public CMSampleBuffer createCopy(CMSampleTimingInfo[] sampleTimingArray) throws OSStatusException {
        CMSampleTimingInfo sampleTimingPtr = (CMSampleTimingInfo)Struct.allocate(CMSampleTimingInfo.class, (int)sampleTimingArray.length);
        sampleTimingPtr.update(sampleTimingArray);
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createCopyWithNewTiming0(null, this, sampleTimingArray.length, sampleTimingPtr, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMSampleBuffer)ptr.get();
    }

    public CMSampleBuffer createCopy(@ByVal CFRange sampleRange) throws OSStatusException {
        CMSampleBufferPtr ptr = new CMSampleBufferPtr();
        OSStatus status = CMSampleBuffer.createForRange0(null, this, sampleRange, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMSampleBuffer)ptr.get();
    }

    public void setDataBuffer(CMBlockBuffer dataBuffer) throws OSStatusException {
        OSStatus status = this.setDataBuffer0(dataBuffer);
        OSStatusException.throwIfNecessary(status);
    }

    public void setAudioBufferList(AudioBufferList bufferList, CMSampleBufferFlags flags) throws OSStatusException {
        OSStatus status = this.setAudioBufferList0(null, null, flags, bufferList);
        OSStatusException.throwIfNecessary(status);
    }

    public AudioBufferList getAudioBufferList(@MachineSizedUInt long bufferListSize, CMSampleBufferFlags flags, CMBlockBuffer buffer) throws OSStatusException {
        CMBlockBuffer.CMBlockBufferPtr ptr = new CMBlockBuffer.CMBlockBufferPtr();
        ptr.set(buffer);
        AudioBufferList list = new AudioBufferList();
        OSStatus status = this.getAudioBufferList0(null, list, bufferListSize, null, null, flags, ptr);
        OSStatusException.throwIfNecessary(status);
        return list;
    }

    public AudioStreamPacketDescription[] getAudioStreamPacketDescriptions(@MachineSizedUInt long packetDescriptionsSize) throws OSStatusException {
        AudioStreamPacketDescription description = new AudioStreamPacketDescription();
        OSStatus status = this.getAudioStreamPacketDescriptions0(packetDescriptionsSize, description, null);
        OSStatusException.throwIfNecessary(status);
        return (AudioStreamPacketDescription[])description.toArray((int)packetDescriptionsSize);
    }

    public void copyPCMDataIntoAudioBufferList(int frameOffset, int numFrames, AudioBufferList bufferList) throws OSStatusException {
        OSStatus status = this.copyPCMDataIntoAudioBufferList0(frameOffset, numFrames, bufferList);
        OSStatusException.throwIfNecessary(status);
    }

    public void setDataReady() throws OSStatusException {
        OSStatus status = this.setDataReady0();
        OSStatusException.throwIfNecessary(status);
    }

    public void setDataFailed(OSStatus status) throws OSStatusException {
        OSStatus s = this.setDataFailed0(status);
        OSStatusException.throwIfNecessary(s);
    }

    public OSStatus hasDataFailed() {
        IntPtr ptr = new IntPtr();
        boolean failed = this.hasDataFailed0(ptr);
        if (failed) {
            return OSStatus.valueOf(ptr.get());
        }
        return null;
    }

    public void makeDataReady() throws OSStatusException {
        OSStatus status = this.makeDataReady0();
        OSStatusException.throwIfNecessary(status);
    }

    public void trackDataReadiness(CMSampleBuffer sbufToTrack) throws OSStatusException {
        OSStatus status = this.trackDataReadiness0(sbufToTrack);
        OSStatusException.throwIfNecessary(status);
    }

    public void invalidate() throws OSStatusException {
        OSStatus status = this.invalidate0();
        OSStatusException.throwIfNecessary(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInvalidateCallback(InvalidateCallback callback) throws OSStatusException {
        long refconId = this.localRefconId;
        OSStatus status = this.setInvalidateCallback0(new FunctionPtr(cbInvalidate), refconId);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<InvalidateCallback> longMap = invalidateCallbacks;
            synchronized (longMap) {
                invalidateCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    public void setInvalidateHandler(VoidBlock1<CMSampleBuffer> invalidateHandler) throws OSStatusException {
        OSStatus status = this.setInvalidateHandler0(invalidateHandler);
        OSStatusException.throwIfNecessary(status);
    }

    public void setOutputPresentationTimeStamp(CMTime outputPresentationTimeStamp) throws OSStatusException {
        OSStatus status = this.setOutputPresentationTimeStamp0(outputPresentationTimeStamp);
        OSStatusException.throwIfNecessary(status);
    }

    public CMSampleTimingInfo[] getSampleTimingInfoArray(@MachineSizedSInt long timingArrayEntries) throws OSStatusException {
        CMSampleTimingInfo info = new CMSampleTimingInfo();
        OSStatus status = this.getSampleTimingInfoArray0(timingArrayEntries, info, null);
        OSStatusException.throwIfNecessary(status);
        return (CMSampleTimingInfo[])info.toArray((int)timingArrayEntries);
    }

    public CMSampleTimingInfo[] getOutputSampleTimingInfoArray(@MachineSizedSInt long timingArrayEntries) throws OSStatusException {
        CMSampleTimingInfo info = new CMSampleTimingInfo();
        OSStatus status = this.getOutputSampleTimingInfoArray0(timingArrayEntries, info, null);
        OSStatusException.throwIfNecessary(status);
        return (CMSampleTimingInfo[])info.toArray((int)timingArrayEntries);
    }

    public CMSampleTimingInfo getSampleTimingInfo(@MachineSizedSInt long sampleIndex) throws OSStatusException {
        CMSampleTimingInfo info = new CMSampleTimingInfo();
        OSStatus status = this.getSampleTimingInfo0(sampleIndex, info);
        OSStatusException.throwIfNecessary(status);
        return info;
    }

    public long[] getSampleSizeArray(@MachineSizedSInt long sizeArrayEntries) throws OSStatusException {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        OSStatus status = this.getSampleSizeArray0(sizeArrayEntries, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.toLongArray((int)sizeArrayEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callForEachSample(ForEachCallback callback) throws OSStatusException {
        long refconId = this.localRefconId;
        OSStatus status = this.callForEachSample0(new FunctionPtr(cbForEach), refconId);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<ForEachCallback> longMap = forEachCallbacks;
            synchronized (longMap) {
                forEachCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    public void callForEachSample(Block2<CMSampleBuffer, Long, OSStatus> handler) throws OSStatusException {
        OSStatus status = this.callForEachSample0(handler);
        OSStatusException.throwIfNecessary(status);
    }

    public void setSampleBufferAttachments(CMSampleBufferAttachment attachment, CMAttachmentMode attachmentMode) {
        CMAttachmentBearer.setAttachments(this, attachment.getDictionary(), attachmentMode);
    }

    public CMSampleBufferAttachment getSampleBufferAttachments(CMAttachmentMode attachmentMode) {
        CFDictionary dict = CMAttachmentBearer.getAttachments(this, attachmentMode);
        if (dict != null) {
            return new CMSampleBufferAttachment(dict);
        }
        return null;
    }

    @Bridge(symbol="CMSampleBufferGetImageBuffer", optional=true)
    public native CVPixelBuffer getPixelBuffer();

    @GlobalValue(symbol="kCMSampleBufferNotification_DataBecameReady", optional=true)
    public static native NSString DataBecameReadyNotification();

    @GlobalValue(symbol="kCMSampleBufferNotification_DataFailed", optional=true)
    public static native NSString DataFailedNotification();

    @GlobalValue(symbol="kCMSampleBufferNotificationParameter_OSStatus", optional=true)
    protected static native NSString OSStatusNotificationParameter();

    @GlobalValue(symbol="kCMSampleBufferConduitNotification_InhibitOutputUntil", optional=true)
    public static native NSString InhibitOutputUntilConduitNotification();

    @GlobalValue(symbol="kCMSampleBufferConduitNotificationParameter_ResumeTag", optional=true)
    protected static native NSString ResumeTagConduitNotificationParameter();

    @GlobalValue(symbol="kCMSampleBufferConduitNotification_ResetOutput", optional=true)
    public static native NSString ResetOutputConduitNotification();

    @GlobalValue(symbol="kCMSampleBufferConduitNotification_UpcomingOutputPTSRangeChanged", optional=true)
    public static native NSString UpcomingOutputPTSRangeChangedConduitNotification();

    @GlobalValue(symbol="kCMSampleBufferConduitNotificationParameter_UpcomingOutputPTSRangeMayOverlapQueuedOutputPTSRange", optional=true)
    protected static native NSString UpcomingOutputPTSRangeMayOverlapQueuedOutputPTSRangeConduitNotificationParameter();

    @GlobalValue(symbol="kCMSampleBufferConduitNotificationParameter_MinUpcomingOutputPTS", optional=true)
    protected static native NSString MinUpcomingOutputPTSConduitNotificationParameter();

    @GlobalValue(symbol="kCMSampleBufferConduitNotificationParameter_MaxUpcomingOutputPTS", optional=true)
    protected static native NSString MaxUpcomingOutputPTSConduitNotificationParameter();

    @GlobalValue(symbol="kCMSampleBufferConsumerNotification_BufferConsumed", optional=true)
    public static native NSString BufferConsumedConsumerNotification();

    @Bridge(symbol="CMSampleBufferCreate", optional=true)
    protected static native OSStatus create0(CFAllocator var0, CMBlockBuffer var1, boolean var2, FunctionPtr var3, @Pointer long var4, CMFormatDescription var6, @MachineSizedSInt long var7, @MachineSizedSInt long var9, CMSampleTimingInfo var11, @MachineSizedSInt long var12, MachineSizedUIntPtr var14, CMSampleBufferPtr var15);

    @Bridge(symbol="CMSampleBufferCreateReady", optional=true)
    protected static native OSStatus createReady0(CFAllocator var0, CMBlockBuffer var1, CMFormatDescription var2, @MachineSizedSInt long var3, @MachineSizedSInt long var5, CMSampleTimingInfo var7, @MachineSizedSInt long var8, MachineSizedUIntPtr var10, CMSampleBufferPtr var11);

    @Bridge(symbol="CMAudioSampleBufferCreateWithPacketDescriptions", optional=true)
    protected static native OSStatus createAudioSampleBuffer0(CFAllocator var0, CMBlockBuffer var1, boolean var2, FunctionPtr var3, @Pointer long var4, CMFormatDescription var6, @MachineSizedSInt long var7, @ByVal CMTime var9, AudioStreamPacketDescription var10, CMSampleBufferPtr var11);

    @Bridge(symbol="CMAudioSampleBufferCreateReadyWithPacketDescriptions", optional=true)
    protected static native OSStatus createAudioSampleBuffer0(CFAllocator var0, CMBlockBuffer var1, CMFormatDescription var2, @MachineSizedSInt long var3, @ByVal CMTime var5, AudioStreamPacketDescription var6, CMSampleBufferPtr var7);

    @Bridge(symbol="CMSampleBufferCreateForImageBuffer", optional=true)
    protected static native OSStatus createForImageBuffer0(CFAllocator var0, CVImageBuffer var1, boolean var2, FunctionPtr var3, @Pointer long var4, CMVideoFormatDescription var6, CMSampleTimingInfo var7, CMSampleBufferPtr var8);

    @Bridge(symbol="CMSampleBufferCreateReadyWithImageBuffer", optional=true)
    protected static native OSStatus createReadyWithImageBuffer0(CFAllocator var0, CVImageBuffer var1, CMVideoFormatDescription var2, CMSampleTimingInfo var3, CMSampleBufferPtr var4);

    @Bridge(symbol="CMSampleBufferCreateCopy", optional=true)
    protected static native OSStatus createCopy0(CFAllocator var0, CMSampleBuffer var1, CMSampleBufferPtr var2);

    @Bridge(symbol="CMSampleBufferCreateCopyWithNewTiming", optional=true)
    protected static native OSStatus createCopyWithNewTiming0(CFAllocator var0, CMSampleBuffer var1, @MachineSizedSInt long var2, CMSampleTimingInfo var4, CMSampleBufferPtr var5);

    @Bridge(symbol="CMSampleBufferCopySampleBufferForRange", optional=true)
    protected static native OSStatus createForRange0(CFAllocator var0, CMSampleBuffer var1, @ByVal CFRange var2, CMSampleBufferPtr var3);

    @Bridge(symbol="CMSampleBufferGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CMSampleBufferSetDataBuffer", optional=true)
    protected native OSStatus setDataBuffer0(CMBlockBuffer var1);

    @Bridge(symbol="CMSampleBufferGetDataBuffer", optional=true)
    public native CMBlockBuffer getDataBuffer();

    @Bridge(symbol="CMSampleBufferGetImageBuffer", optional=true)
    public native CVImageBuffer getImageBuffer();

    @Bridge(symbol="CMSampleBufferSetDataBufferFromAudioBufferList", optional=true)
    protected native OSStatus setAudioBufferList0(CFAllocator var1, CFAllocator var2, CMSampleBufferFlags var3, AudioBufferList var4);

    @Bridge(symbol="CMSampleBufferGetAudioBufferListWithRetainedBlockBuffer", optional=true)
    protected native OSStatus getAudioBufferList0(MachineSizedUIntPtr var1, AudioBufferList var2, @MachineSizedUInt long var3, CFAllocator var5, CFAllocator var6, CMSampleBufferFlags var7, CMBlockBuffer.CMBlockBufferPtr var8);

    @Bridge(symbol="CMSampleBufferGetAudioStreamPacketDescriptions", optional=true)
    protected native OSStatus getAudioStreamPacketDescriptions0(@MachineSizedUInt long var1, AudioStreamPacketDescription var3, MachineSizedUIntPtr var4);

    @Bridge(symbol="CMSampleBufferCopyPCMDataIntoAudioBufferList", optional=true)
    protected native OSStatus copyPCMDataIntoAudioBufferList0(int var1, int var2, AudioBufferList var3);

    @Bridge(symbol="CMSampleBufferSetDataReady", optional=true)
    protected native OSStatus setDataReady0();

    @Bridge(symbol="CMSampleBufferDataIsReady", optional=true)
    public native boolean isDataReady();

    @Bridge(symbol="CMSampleBufferSetDataFailed", optional=true)
    protected native OSStatus setDataFailed0(OSStatus var1);

    @Bridge(symbol="CMSampleBufferHasDataFailed", optional=true)
    protected native boolean hasDataFailed0(IntPtr var1);

    @Bridge(symbol="CMSampleBufferMakeDataReady", optional=true)
    protected native OSStatus makeDataReady0();

    @Bridge(symbol="CMSampleBufferTrackDataReadiness", optional=true)
    protected native OSStatus trackDataReadiness0(CMSampleBuffer var1);

    @Bridge(symbol="CMSampleBufferInvalidate", optional=true)
    protected native OSStatus invalidate0();

    @Bridge(symbol="CMSampleBufferSetInvalidateCallback", optional=true)
    protected native OSStatus setInvalidateCallback0(FunctionPtr var1, long var2);

    @Bridge(symbol="CMSampleBufferSetInvalidateHandler", optional=true)
    protected native OSStatus setInvalidateHandler0(@Block VoidBlock1<CMSampleBuffer> var1);

    @Bridge(symbol="CMSampleBufferIsValid", optional=true)
    public native boolean isValid();

    @Bridge(symbol="CMSampleBufferGetNumSamples", optional=true)
    @MachineSizedSInt
    public native long getNumSamples();

    @Bridge(symbol="CMSampleBufferGetDuration", optional=true)
    @ByVal
    public native CMTime getDuration();

    @Bridge(symbol="CMSampleBufferGetPresentationTimeStamp", optional=true)
    @ByVal
    public native CMTime getPresentationTimeStamp();

    @Bridge(symbol="CMSampleBufferGetDecodeTimeStamp", optional=true)
    @ByVal
    public native CMTime getDecodeTimeStamp();

    @Bridge(symbol="CMSampleBufferGetOutputDuration", optional=true)
    @ByVal
    public native CMTime getOutputDuration();

    @Bridge(symbol="CMSampleBufferGetOutputPresentationTimeStamp", optional=true)
    @ByVal
    public native CMTime getOutputPresentationTimeStamp();

    @Bridge(symbol="CMSampleBufferSetOutputPresentationTimeStamp", optional=true)
    protected native OSStatus setOutputPresentationTimeStamp0(@ByVal CMTime var1);

    @Bridge(symbol="CMSampleBufferGetOutputDecodeTimeStamp", optional=true)
    @ByVal
    public native CMTime getOutputDecodeTimeStamp();

    @Bridge(symbol="CMSampleBufferGetSampleTimingInfoArray", optional=true)
    protected native OSStatus getSampleTimingInfoArray0(@MachineSizedSInt long var1, CMSampleTimingInfo var3, MachineSizedSIntPtr var4);

    @Bridge(symbol="CMSampleBufferGetOutputSampleTimingInfoArray", optional=true)
    protected native OSStatus getOutputSampleTimingInfoArray0(@MachineSizedSInt long var1, CMSampleTimingInfo var3, MachineSizedSIntPtr var4);

    @Bridge(symbol="CMSampleBufferGetSampleTimingInfo", optional=true)
    protected native OSStatus getSampleTimingInfo0(@MachineSizedSInt long var1, CMSampleTimingInfo var3);

    @Bridge(symbol="CMSampleBufferGetSampleSizeArray", optional=true)
    protected native OSStatus getSampleSizeArray0(@MachineSizedSInt long var1, MachineSizedUIntPtr var3, MachineSizedSIntPtr var4);

    @Bridge(symbol="CMSampleBufferGetSampleSize", optional=true)
    @MachineSizedUInt
    public native long getSampleSize(@MachineSizedSInt long var1);

    @Bridge(symbol="CMSampleBufferGetTotalSampleSize", optional=true)
    @MachineSizedUInt
    public native long getTotalSampleSize();

    @Bridge(symbol="CMSampleBufferGetFormatDescription", optional=true)
    public native CMFormatDescription getFormatDescription();

    @Bridge(symbol="CMSampleBufferGetSampleAttachmentsArray", optional=true)
    @Marshaler(value=CMSampleAttachment.AsListMarshaler.class)
    public native List<CMSampleAttachment> getSampleAttachments(boolean var1);

    @Bridge(symbol="CMSampleBufferCallForEachSample", optional=true)
    protected native OSStatus callForEachSample0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="CMSampleBufferCallBlockForEachSample", optional=true)
    protected native OSStatus callForEachSample0(@Block Block2<CMSampleBuffer, Long, OSStatus> var1);

    static {
        try {
            cbInvalidate = CMSampleBuffer.class.getDeclaredMethod("cbInvalidate", CMSampleBuffer.class, Long.TYPE);
            cbMakeDataReady = CMSampleBuffer.class.getDeclaredMethod("cbMakeDataReady", CMSampleBuffer.class, Long.TYPE);
            cbForEach = CMSampleBuffer.class.getDeclaredMethod("cbForEach", CMSampleBuffer.class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CMSampleBuffer.class);
    }

    public static interface ForEachCallback {
        public void forEach(CMSampleBuffer var1, long var2) throws OSStatusException;
    }

    public static interface MakeDataReadyCallback {
        public void makeDataReady(CMSampleBuffer var1) throws OSStatusException;
    }

    public static interface InvalidateCallback {
        public void invalidate(CMSampleBuffer var1);
    }

    public static class CMSampleBufferPtr
    extends Ptr<CMSampleBuffer, CMSampleBufferPtr> {
    }

    public static class Notifications {
        public static NSObject observeDataBecameReady(CMSampleBuffer object, final VoidBlock1<CMSampleBuffer> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMSampleBuffer.DataBecameReadyNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)a.getObject().as(CMSampleBuffer.class));
                }
            });
        }

        public static NSObject observeDataFailed(CMSampleBuffer object, final VoidBlock2<CMSampleBuffer, OSStatus> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMSampleBuffer.DataFailedNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<NSString, NSObject> data = a.getUserInfo();
                    NSNumber val = (NSNumber)data.get(CMSampleBuffer.OSStatusNotificationParameter());
                    OSStatus error = val != null ? OSStatus.valueOf((int)val.longValue()) : null;
                    block.invoke((Object)a.getObject().as(CMSampleBuffer.class), (Object)error);
                }
            });
        }

        public static NSObject observeInhibitOutputUntil(CMSampleBuffer object, final VoidBlock2<CMSampleBuffer, Long> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMSampleBuffer.InhibitOutputUntilConduitNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<NSString, NSObject> data = a.getUserInfo();
                    NSNumber val = (NSNumber)data.get(CMSampleBuffer.ResumeTagConduitNotificationParameter());
                    long tag = val != null ? val.longValue() : 0L;
                    block.invoke((Object)a.getObject().as(CMSampleBuffer.class), (Object)tag);
                }
            });
        }

        public static NSObject observeResetOutput(CMSampleBuffer object, final VoidBlock1<CMSampleBuffer> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMSampleBuffer.ResetOutputConduitNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)a.getObject().as(CMSampleBuffer.class));
                }
            });
        }

        public static NSObject observeUpcomingOutputPTSRangeChanged(CMSampleBuffer object, final VoidBlock4<CMSampleBuffer, Boolean, CMTime, CMTime> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMSampleBuffer.UpcomingOutputPTSRangeChangedConduitNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<NSString, NSObject> data = a.getUserInfo();
                    NSNumber val1 = (NSNumber)data.get(CMSampleBuffer.UpcomingOutputPTSRangeMayOverlapQueuedOutputPTSRangeConduitNotificationParameter());
                    boolean mayOverlap = val1 != null ? val1.booleanValue() : false;
                    NSDictionary val2 = (NSDictionary)data.get(CMSampleBuffer.MinUpcomingOutputPTSConduitNotificationParameter());
                    CMTime min = val2 != null ? CMTime.create(val2) : null;
                    NSDictionary val3 = (NSDictionary)data.get(CMSampleBuffer.MaxUpcomingOutputPTSConduitNotificationParameter());
                    CMTime max = val3 != null ? CMTime.create(val3) : null;
                    block.invoke((Object)a.getObject().as(CMSampleBuffer.class), (Object)mayOverlap, (Object)min, (Object)max);
                }
            });
        }

        public static NSObject observeBufferConsumed(CMSampleBuffer object, final VoidBlock2<CMSampleBuffer, NSDictionary<NSString, NSObject>> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CMSampleBuffer.BufferConsumedConsumerNotification(), (NSObject)object.as(NSObject.class), NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)a.getObject().as(CMSampleBuffer.class), a.getUserInfo());
                }
            });
        }
    }
}

