/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFComparisonResult;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMBuffer;
import org.robovm.apple.coremedia.CMBufferCallbacksStruct;
import org.robovm.apple.coremedia.CMBufferQueueCallbacks;
import org.robovm.apple.coremedia.CMBufferQueueTriggerCondition;
import org.robovm.apple.coremedia.CMBufferQueueTriggerToken;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreMedia")
public class CMBufferQueue
extends CFType {
    private static AtomicLong refconId = new AtomicLong();
    private static AtomicLong triggerId = new AtomicLong();
    private static final LongMap<CMBufferQueueCallbacks> bufferQueueCallbacks = new LongMap();
    private static final LongMap<ResetCallback> resetCallbacks = new LongMap();
    private static final LongMap<TriggerCallback> triggerCallbacks = new LongMap();
    private static final LongMap<ValidationCallback> validationCallbacks = new LongMap();
    private static final LongMap<ForEachCallback> forEachCallbacks = new LongMap();
    private static final Method cbGetDecodeTimeStamp;
    private static final Method cbGetPresentationTimeStamp;
    private static final Method cbGetDuration;
    private static final Method cbIsDataReady;
    private static final Method cbCompare;
    private static final Method cbGetSize;
    private static final Method cbReset;
    private static final Method cbTrigger;
    private static final Method cbValidate;
    private static final Method cbForEach;

    protected CMBufferQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static CMTime cbGetDecodeTimeStamp(CFType buffer, @Pointer long refcon) {
        CMBufferQueueCallbacks callback = null;
        LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
        synchronized (longMap) {
            callback = (CMBufferQueueCallbacks)bufferQueueCallbacks.get(refcon);
        }
        return callback.getDecodeTimeStamp((CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static CMTime cbGetPresentationTimeStamp(CFType buffer, @Pointer long refcon) {
        CMBufferQueueCallbacks callback = null;
        LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
        synchronized (longMap) {
            callback = (CMBufferQueueCallbacks)bufferQueueCallbacks.get(refcon);
        }
        return callback.getPresentationTimeStamp((CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static CMTime cbGetDuration(CFType buffer, @Pointer long refcon) {
        CMBufferQueueCallbacks callback = null;
        LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
        synchronized (longMap) {
            callback = (CMBufferQueueCallbacks)bufferQueueCallbacks.get(refcon);
        }
        return callback.getDuration((CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static boolean cbIsDataReady(CFType buffer, @Pointer long refcon) {
        CMBufferQueueCallbacks callback = null;
        LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
        synchronized (longMap) {
            callback = (CMBufferQueueCallbacks)bufferQueueCallbacks.get(refcon);
        }
        return callback.isDataReady((CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static CFComparisonResult cbCompare(CFType buffer1, CFType buffer2, @Pointer long refcon) {
        CMBufferQueueCallbacks callback = null;
        LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
        synchronized (longMap) {
            callback = (CMBufferQueueCallbacks)bufferQueueCallbacks.get(refcon);
        }
        return callback.compare((CMBuffer)((Object)buffer1), (CMBuffer)((Object)buffer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static int cbGetSize(CFType buffer, @Pointer long refcon) {
        CMBufferQueueCallbacks callback = null;
        LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
        synchronized (longMap) {
            callback = (CMBufferQueueCallbacks)bufferQueueCallbacks.get(refcon);
        }
        return callback.getSize((CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReset(CFType buffer, @Pointer long refcon) {
        ResetCallback callback = null;
        LongMap<ResetCallback> longMap = resetCallbacks;
        synchronized (longMap) {
            callback = (ResetCallback)resetCallbacks.get(refcon);
        }
        callback.reset((CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbTrigger(@Pointer long refcon, CMBufferQueueTriggerToken triggerToken) {
        TriggerCallback callback = null;
        LongMap<TriggerCallback> longMap = triggerCallbacks;
        synchronized (longMap) {
            callback = (TriggerCallback)triggerCallbacks.get(refcon);
        }
        callback.trigger(triggerToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbValidate(CMBufferQueue bufferQueue, CFType buffer, @Pointer long refcon) {
        ValidationCallback callback = null;
        LongMap<ValidationCallback> longMap = validationCallbacks;
        synchronized (longMap) {
            callback = (ValidationCallback)validationCallbacks.get(refcon);
        }
        callback.validate(bufferQueue, (CMBuffer)((Object)buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbForEach(CFType buffer, @Pointer long refcon) {
        LongMap<ForEachCallback> longMap = forEachCallbacks;
        synchronized (longMap) {
            try {
                ((ForEachCallback)forEachCallbacks.get(refcon)).invoke((CMBuffer)((Object)buffer));
            }
            catch (OSStatusException e) {
                return e.getStatus();
            }
            return OSStatus.NO_ERR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMBufferQueue create(@MachineSizedSInt long capacity, CMBufferQueueCallbacks callback) throws OSStatusException {
        long refconId = CMBufferQueue.refconId.getAndIncrement();
        CMBufferCallbacksStruct callbacks = new CMBufferCallbacksStruct();
        callbacks.setRefcon(refconId);
        callbacks.setGetDecodeTimeStamp(new FunctionPtr(cbGetDecodeTimeStamp));
        callbacks.setGetPresentationTimeStamp(new FunctionPtr(cbGetPresentationTimeStamp));
        callbacks.setGetDuration(new FunctionPtr(cbGetDuration));
        callbacks.setIsDataReady(new FunctionPtr(cbIsDataReady));
        callbacks.setCompare(new FunctionPtr(cbCompare));
        callbacks.setGetSize(new FunctionPtr(cbGetSize));
        CMBufferQueuePtr ptr = new CMBufferQueuePtr();
        OSStatus status = CMBufferQueue.create0(null, capacity, callbacks, ptr);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<CMBufferQueueCallbacks> longMap = bufferQueueCallbacks;
            synchronized (longMap) {
                bufferQueueCallbacks.put(refconId, (Object)callback);
            }
            return (CMBufferQueue)ptr.get();
        }
        return null;
    }

    public void markEndOfData() throws OSStatusException {
        OSStatus status = this.markEndOfData0();
        OSStatusException.throwIfNecessary(status);
    }

    public void reset() throws OSStatusException {
        OSStatus status = this.reset0();
        OSStatusException.throwIfNecessary(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(ResetCallback callback) throws OSStatusException {
        long refconId = CMBufferQueue.refconId.get();
        OSStatus status = this.reset0(new FunctionPtr(cbReset), refconId);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<ResetCallback> longMap = resetCallbacks;
            synchronized (longMap) {
                resetCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installTrigger(TriggerCallback callback, CMBufferQueueTriggerCondition triggerCondition, @ByVal CMTime triggerTime) throws OSStatusException {
        long refconId = triggerId.getAndIncrement();
        OSStatus status = this.installTrigger0(new FunctionPtr(cbTrigger), refconId, triggerCondition, triggerTime, null);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<TriggerCallback> longMap = triggerCallbacks;
            synchronized (longMap) {
                triggerCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installTrigger(TriggerCallback callback, CMBufferQueueTriggerCondition triggerCondition, @MachineSizedSInt long triggerThreshold) throws OSStatusException {
        long refconId = triggerId.getAndIncrement();
        OSStatus status = this.installTrigger0(new FunctionPtr(cbTrigger), refconId, triggerCondition, triggerThreshold, null);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<TriggerCallback> longMap = triggerCallbacks;
            synchronized (longMap) {
                triggerCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    public void removeTrigger(CMBufferQueueTriggerToken triggerToken) throws OSStatusException {
        OSStatus status = this.removeTrigger0(triggerToken);
        OSStatusException.throwIfNecessary(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callForEachBuffer(ForEachCallback callback) throws OSStatusException {
        long refconId = CMBufferQueue.refconId.get();
        OSStatus status = this.callForEachBuffer0(new FunctionPtr(cbReset), refconId);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<ForEachCallback> longMap = forEachCallbacks;
            synchronized (longMap) {
                forEachCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValidationCallback(ValidationCallback callback) throws OSStatusException {
        long refconId = CMBufferQueue.refconId.get();
        OSStatus status = this.setValidationCallback0(new FunctionPtr(cbValidate), refconId);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<ValidationCallback> longMap = validationCallbacks;
            synchronized (longMap) {
                validationCallbacks.put(refconId, (Object)callback);
            }
        }
    }

    @Bridge(symbol="CMBufferQueueCreate", optional=true)
    protected static native OSStatus create0(CFAllocator var0, @MachineSizedSInt long var1, CMBufferCallbacksStruct var3, CMBufferQueuePtr var4);

    @Bridge(symbol="CMBufferQueueGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CMBufferQueueEnqueue", optional=true)
    protected native OSStatus enqueue0(CFType var1);

    @Bridge(symbol="CMBufferQueueDequeueAndRetain", optional=true)
    public native CFType dequeueAndRetain();

    @Bridge(symbol="CMBufferQueueDequeueIfDataReadyAndRetain", optional=true)
    public native CFType dequeueIfDataReadyAndRetain();

    @Bridge(symbol="CMBufferQueueGetHead", optional=true)
    public native CFType getHead();

    @Bridge(symbol="CMBufferQueueIsEmpty", optional=true)
    public native boolean isEmpty();

    @Bridge(symbol="CMBufferQueueMarkEndOfData", optional=true)
    protected native OSStatus markEndOfData0();

    @Bridge(symbol="CMBufferQueueContainsEndOfData", optional=true)
    public native boolean containsEndOfData();

    @Bridge(symbol="CMBufferQueueIsAtEndOfData", optional=true)
    public native boolean isAtEndOfData();

    @Bridge(symbol="CMBufferQueueReset", optional=true)
    protected native OSStatus reset0();

    @Bridge(symbol="CMBufferQueueResetWithCallback", optional=true)
    protected native OSStatus reset0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="CMBufferQueueGetBufferCount", optional=true)
    @MachineSizedSInt
    public native long getBufferCount();

    @Bridge(symbol="CMBufferQueueGetDuration", optional=true)
    @ByVal
    public native CMTime getDuration();

    @Bridge(symbol="CMBufferQueueGetMinDecodeTimeStamp", optional=true)
    @ByVal
    public native CMTime getMinDecodeTimeStamp();

    @Bridge(symbol="CMBufferQueueGetFirstDecodeTimeStamp", optional=true)
    @ByVal
    public native CMTime getFirstDecodeTimeStamp();

    @Bridge(symbol="CMBufferQueueGetMinPresentationTimeStamp", optional=true)
    @ByVal
    public native CMTime getMinPresentationTimeStamp();

    @Bridge(symbol="CMBufferQueueGetFirstPresentationTimeStamp", optional=true)
    @ByVal
    public native CMTime getFirstPresentationTimeStamp();

    @Bridge(symbol="CMBufferQueueGetMaxPresentationTimeStamp", optional=true)
    @ByVal
    public native CMTime getMaxPresentationTimeStamp();

    @Bridge(symbol="CMBufferQueueGetEndPresentationTimeStamp", optional=true)
    @ByVal
    public native CMTime getEndPresentationTimeStamp();

    @Bridge(symbol="CMBufferQueueGetTotalSize", optional=true)
    @MachineSizedUInt
    public native long getTotalSize();

    @Bridge(symbol="CMBufferQueueInstallTrigger", optional=true)
    protected native OSStatus installTrigger0(FunctionPtr var1, @Pointer long var2, CMBufferQueueTriggerCondition var4, @ByVal CMTime var5, CMBufferQueueTriggerToken.CMBufferQueueTriggerTokenPtr var6);

    @Bridge(symbol="CMBufferQueueInstallTriggerWithIntegerThreshold", optional=true)
    protected native OSStatus installTrigger0(FunctionPtr var1, @Pointer long var2, CMBufferQueueTriggerCondition var4, @MachineSizedSInt long var5, CMBufferQueueTriggerToken.CMBufferQueueTriggerTokenPtr var7);

    @Bridge(symbol="CMBufferQueueRemoveTrigger", optional=true)
    protected native OSStatus removeTrigger0(CMBufferQueueTriggerToken var1);

    @Bridge(symbol="CMBufferQueueTestTrigger", optional=true)
    protected native boolean testTrigger0(CMBufferQueueTriggerToken var1);

    @Bridge(symbol="CMBufferQueueCallForEachBuffer", optional=true)
    protected native OSStatus callForEachBuffer0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="CMBufferQueueSetValidationCallback", optional=true)
    protected native OSStatus setValidationCallback0(FunctionPtr var1, @Pointer long var2);

    static {
        try {
            cbGetDecodeTimeStamp = CMBufferQueue.class.getDeclaredMethod("cbGetDecodeTimeStamp", CFType.class, Long.TYPE);
            cbGetPresentationTimeStamp = CMBufferQueue.class.getDeclaredMethod("cbGetPresentationTimeStamp", CFType.class, Long.TYPE);
            cbGetDuration = CMBufferQueue.class.getDeclaredMethod("cbGetDuration", CFType.class, Long.TYPE);
            cbIsDataReady = CMBufferQueue.class.getDeclaredMethod("cbIsDataReady", CFType.class, Long.TYPE);
            cbCompare = CMBufferQueue.class.getDeclaredMethod("cbCompare", CFType.class, CFType.class, Long.TYPE);
            cbGetSize = CMBufferQueue.class.getDeclaredMethod("cbGetSize", CFType.class, Long.TYPE);
            cbReset = CMBufferQueue.class.getDeclaredMethod("cbReset", CFType.class, Long.TYPE);
            cbTrigger = CMBufferQueue.class.getDeclaredMethod("cbTrigger", Long.TYPE, CMBufferQueueTriggerToken.class);
            cbValidate = CMBufferQueue.class.getDeclaredMethod("cbValidate", CMBufferQueue.class, CFType.class, Long.TYPE);
            cbForEach = CMBufferQueue.class.getDeclaredMethod("cbForEach", CFType.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CMBufferQueue.class);
    }

    public static interface ForEachCallback {
        public void invoke(CMBuffer var1) throws OSStatusException;
    }

    public static interface ValidationCallback {
        public void validate(CMBufferQueue var1, CMBuffer var2);
    }

    public static interface TriggerCallback {
        public void trigger(CMBufferQueueTriggerToken var1);
    }

    public static interface ResetCallback {
        public void reset(CMBuffer var1);
    }

    public static class CMBufferQueuePtr
    extends Ptr<CMBufferQueue, CMBufferQueuePtr> {
    }
}

