/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coremedia;

import java.util.List;
import org.robovm.apple.audiotoolbox.AudioFormatListItem;
import org.robovm.apple.coreaudio.AudioChannelLayout;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremedia.CMAudioCodecType;
import org.robovm.apple.coremedia.CMAudioFormatDescriptionMask;
import org.robovm.apple.coremedia.CMBlockBuffer;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMSoundDescriptionFlavor;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreMedia")
public class CMAudioFormatDescription
extends CMFormatDescription {
    public static CMAudioFormatDescription create(AudioStreamBasicDescription asbd, @MachineSizedUInt long layoutSize, AudioChannelLayout layout, @MachineSizedUInt long magicCookieSize, VoidPtr magicCookie, NSDictionary<NSString, ?> extensions) throws OSStatusException {
        CMAudioFormatDescriptionPtr ptr = new CMAudioFormatDescriptionPtr();
        OSStatus status = CMAudioFormatDescription.create0(null, asbd, layoutSize, layout, magicCookieSize, magicCookie, extensions, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMAudioFormatDescription)ptr.get();
    }

    public static CMAudioFormatDescription createFromBigEndianSoundDescriptionData(BytePtr soundDescriptionData, @MachineSizedUInt long soundDescriptionSize, CMSoundDescriptionFlavor soundDescriptionFlavor) throws OSStatusException {
        CMAudioFormatDescriptionPtr ptr = new CMAudioFormatDescriptionPtr();
        OSStatus status = CMAudioFormatDescription.createFromBigEndianSoundDescriptionData0(null, soundDescriptionData, soundDescriptionSize, soundDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMAudioFormatDescription)ptr.get();
    }

    public static CMAudioFormatDescription createFromBigEndianSoundDescriptionBlockBuffer(CMBlockBuffer soundDescriptionBlockBuffer, CMSoundDescriptionFlavor soundDescriptionFlavor) throws OSStatusException {
        CMAudioFormatDescriptionPtr ptr = new CMAudioFormatDescriptionPtr();
        OSStatus status = CMAudioFormatDescription.createFromBigEndianSoundDescriptionBlockBuffer0(null, soundDescriptionBlockBuffer, soundDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMAudioFormatDescription)ptr.get();
    }

    public CMAudioCodecType getAudioCodecType() {
        return CMAudioCodecType.valueOf(this.getMediaSubType());
    }

    public VoidPtr getMagicCookie() {
        return this.getMagicCookie0(null);
    }

    @MachineSizedUInt
    public long getMagicCookieSize() {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        this.getMagicCookie0(ptr);
        return ptr.get();
    }

    public AudioChannelLayout getChannelLayout() {
        return this.getChannelLayout0(null);
    }

    @MachineSizedUInt
    public long getChannelLayoutSize() {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        this.getChannelLayout0(ptr);
        return ptr.get();
    }

    public AudioFormatListItem getFormatList() {
        return this.getFormatList0(null);
    }

    @MachineSizedUInt
    public long getFormatListSize() {
        MachineSizedUIntPtr ptr = new MachineSizedUIntPtr();
        this.getFormatList0(ptr);
        return ptr.get();
    }

    public static CMAudioFormatDescription createSummary(List<CMAudioFormatDescription> formatDescriptionArray) throws OSStatusException {
        CMAudioFormatDescriptionPtr ptr = new CMAudioFormatDescriptionPtr();
        OSStatus status = CMAudioFormatDescription.createSummary0(null, formatDescriptionArray, 0, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMAudioFormatDescription)ptr.get();
    }

    public boolean equalsTo(CMAudioFormatDescription desc2, CMAudioFormatDescriptionMask equalityMask) {
        return this.equalsTo0(desc2, equalityMask, null);
    }

    public CMBlockBuffer copyAsBigEndianSoundDescriptionBlockBuffer(CMAudioFormatDescription audioFormatDescription, CMSoundDescriptionFlavor soundDescriptionFlavor) throws OSStatusException {
        CMBlockBuffer.CMBlockBufferPtr ptr = new CMBlockBuffer.CMBlockBufferPtr();
        OSStatus status = CMAudioFormatDescription.copyAsBigEndianSoundDescriptionBlockBuffer0(null, this, soundDescriptionFlavor, ptr);
        OSStatusException.throwIfNecessary(status);
        return (CMBlockBuffer)ptr.get();
    }

    @Bridge(symbol="CMAudioFormatDescriptionCreate", optional=true)
    protected static native OSStatus create0(CFAllocator var0, AudioStreamBasicDescription var1, @MachineSizedUInt long var2, AudioChannelLayout var4, @MachineSizedUInt long var5, VoidPtr var7, NSDictionary<NSString, ?> var8, CMAudioFormatDescriptionPtr var9);

    @Bridge(symbol="CMAudioFormatDescriptionGetStreamBasicDescription", optional=true)
    public native AudioStreamBasicDescription getStreamBasicDescription();

    @Bridge(symbol="CMAudioFormatDescriptionGetMagicCookie", optional=true)
    private native VoidPtr getMagicCookie0(MachineSizedUIntPtr var1);

    @Bridge(symbol="CMAudioFormatDescriptionGetChannelLayout", optional=true)
    private native AudioChannelLayout getChannelLayout0(MachineSizedUIntPtr var1);

    @Bridge(symbol="CMAudioFormatDescriptionGetFormatList", optional=true)
    private native AudioFormatListItem getFormatList0(MachineSizedUIntPtr var1);

    @Bridge(symbol="CMAudioFormatDescriptionGetRichestDecodableFormat", optional=true)
    public native AudioFormatListItem getRichestDecodableFormat();

    @Bridge(symbol="CMAudioFormatDescriptionGetMostCompatibleFormat", optional=true)
    public native AudioFormatListItem getMostCompatibleFormat();

    @Bridge(symbol="CMAudioFormatDescriptionCreateSummary", optional=true)
    private static native OSStatus createSummary0(CFAllocator var0, @Marshaler(value=CFType.AsListMarshaler.class) List<CMAudioFormatDescription> var1, int var2, CMAudioFormatDescriptionPtr var3);

    @Bridge(symbol="CMAudioFormatDescriptionEqual", optional=true)
    private native boolean equalsTo0(CMAudioFormatDescription var1, CMAudioFormatDescriptionMask var2, IntPtr var3);

    @Bridge(symbol="CMAudioFormatDescriptionCreateFromBigEndianSoundDescriptionData", optional=true)
    private static native OSStatus createFromBigEndianSoundDescriptionData0(CFAllocator var0, BytePtr var1, @MachineSizedUInt long var2, CMSoundDescriptionFlavor var4, CMAudioFormatDescriptionPtr var5);

    @Bridge(symbol="CMAudioFormatDescriptionCreateFromBigEndianSoundDescriptionBlockBuffer", optional=true)
    private static native OSStatus createFromBigEndianSoundDescriptionBlockBuffer0(CFAllocator var0, CMBlockBuffer var1, CMSoundDescriptionFlavor var2, CMAudioFormatDescriptionPtr var3);

    @Bridge(symbol="CMAudioFormatDescriptionCopyAsBigEndianSoundDescriptionBlockBuffer", optional=true)
    private static native OSStatus copyAsBigEndianSoundDescriptionBlockBuffer0(CFAllocator var0, CMAudioFormatDescription var1, CMSoundDescriptionFlavor var2, CMBlockBuffer.CMBlockBufferPtr var3);

    static {
        Bro.bind(CMAudioFormatDescription.class);
    }

    public static class CMAudioFormatDescriptionPtr
    extends Ptr<CMAudioFormatDescription, CMAudioFormatDescriptionPtr> {
    }
}

