/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.imageio.CGImageProperties;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreImage")
public class CIImageOptions
extends CocoaUtility {
    private CFDictionary data;

    protected CIImageOptions(CFDictionary data) {
        this.data = data;
    }

    public CIImageOptions() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public CGColorSpace getColorSpace() {
        if (this.data.containsKey(CIImageOptions.ColorSpaceKey())) {
            CGColorSpace val = this.data.get(CIImageOptions.ColorSpaceKey(), CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CIImageOptions setColorSpace(CGColorSpace colorSpace) {
        this.data.put(CIImageOptions.ColorSpaceKey(), colorSpace);
        return this;
    }

    public CGImageProperties getProperties() {
        if (this.data.containsKey(CIImageOptions.PropertiesKey())) {
            CFDictionary val = this.data.get(CIImageOptions.PropertiesKey(), CFDictionary.class);
            return new CGImageProperties(val);
        }
        return null;
    }

    public CIImageOptions setProperties(CGImageProperties properties) {
        this.data.put(CIImageOptions.PropertiesKey(), properties.getDictionary());
        return this;
    }

    @GlobalValue(symbol="kCIImageColorSpace", optional=true)
    protected static native CFString ColorSpaceKey();

    @GlobalValue(symbol="kCIImageProperties", optional=true)
    protected static native CFString PropertiesKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CIImageOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIImageOptions toObject(Class<CIImageOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIImageOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIImageOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

