/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBoolean;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coreimage.CIFeature;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreImage")
public class CIImageAutoAdjustOptions
extends CocoaUtility {
    private CFDictionary data;

    protected CIImageAutoAdjustOptions(CFDictionary data) {
        this.data = data;
    }

    public CIImageAutoAdjustOptions() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public boolean appliesEnhancementFilter() {
        if (this.data.containsKey(CIImageAutoAdjustOptions.EnhanceKey())) {
            CFBoolean val = this.data.get(CIImageAutoAdjustOptions.EnhanceKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return true;
    }

    public CIImageAutoAdjustOptions setAppliesEnhancementFilter(boolean apply) {
        this.data.put(CIImageAutoAdjustOptions.EnhanceKey(), CFBoolean.valueOf(apply));
        return this;
    }

    public boolean appliesRedEyeFilter() {
        if (this.data.containsKey(CIImageAutoAdjustOptions.RedEyeKey())) {
            CFBoolean val = this.data.get(CIImageAutoAdjustOptions.RedEyeKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return true;
    }

    public CIImageAutoAdjustOptions setAppliesRedEyeFilter(boolean apply) {
        this.data.put(CIImageAutoAdjustOptions.RedEyeKey(), CFBoolean.valueOf(apply));
        return this;
    }

    public List<CIFeature> getFeatures() {
        if (this.data.containsKey(CIImageAutoAdjustOptions.FeaturesKey())) {
            CFArray val = this.data.get(CIImageAutoAdjustOptions.FeaturesKey(), CFArray.class);
            return val.toList(CIFeature.class);
        }
        return null;
    }

    public CIImageAutoAdjustOptions setFeatures(List<CIFeature> features) {
        this.data.put(CIImageAutoAdjustOptions.FeaturesKey(), CFArray.create(features));
        return this;
    }

    public boolean appliesCropFilter() {
        if (this.data.containsKey(CIImageAutoAdjustOptions.CropKey())) {
            CFBoolean val = this.data.get(CIImageAutoAdjustOptions.CropKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CIImageAutoAdjustOptions setAppliesCropFilter(boolean apply) {
        this.data.put(CIImageAutoAdjustOptions.CropKey(), CFBoolean.valueOf(apply));
        return this;
    }

    public boolean appliesAutoLevel() {
        if (this.data.containsKey(CIImageAutoAdjustOptions.LevelKey())) {
            CFBoolean val = this.data.get(CIImageAutoAdjustOptions.LevelKey(), CFBoolean.class);
            return val.booleanValue();
        }
        return false;
    }

    public CIImageAutoAdjustOptions setAppliesAutoLevel(boolean apply) {
        this.data.put(CIImageAutoAdjustOptions.LevelKey(), CFBoolean.valueOf(apply));
        return this;
    }

    @GlobalValue(symbol="kCIImageAutoAdjustEnhance", optional=true)
    protected static native CFString EnhanceKey();

    @GlobalValue(symbol="kCIImageAutoAdjustRedEye", optional=true)
    protected static native CFString RedEyeKey();

    @GlobalValue(symbol="kCIImageAutoAdjustFeatures", optional=true)
    protected static native CFString FeaturesKey();

    @GlobalValue(symbol="kCIImageAutoAdjustCrop", optional=true)
    protected static native CFString CropKey();

    @GlobalValue(symbol="kCIImageAutoAdjustLevel", optional=true)
    protected static native CFString LevelKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CIImageAutoAdjustOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIImageAutoAdjustOptions toObject(Class<CIImageAutoAdjustOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIImageAutoAdjustOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIImageAutoAdjustOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

