/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="CoreImage")
public class CIFormat
extends CocoaUtility {
    public static final CIFormat ARGB8;
    public static final CIFormat BGRA8;
    public static final CIFormat RGBA8;
    public static final CIFormat RGBAf;
    public static final CIFormat RGBAh;
    private static CIFormat[] values;
    private final LazyGlobalValue<Integer> lazyGlobalValue;

    private CIFormat(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public int value() {
        return (Integer)this.lazyGlobalValue.value();
    }

    public static CIFormat valueOf(int value) {
        for (CIFormat v : values) {
            if (v.value() != value) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + CIFormat.class.getName());
    }

    @GlobalValue(symbol="kCIFormatARGB8", optional=true)
    protected static native int ARGB8Value();

    @GlobalValue(symbol="kCIFormatBGRA8", optional=true)
    protected static native int BGRA8Value();

    @GlobalValue(symbol="kCIFormatRGBA8", optional=true)
    protected static native int RGBA8Value();

    @GlobalValue(symbol="kCIFormatRGBAf", optional=true)
    protected static native int RGBAfValue();

    @GlobalValue(symbol="kCIFormatRGBAh", optional=true)
    protected static native int RGBAhValue();

    static {
        Bro.bind(CIFormat.class);
        ARGB8 = new CIFormat("ARGB8Value");
        BGRA8 = new CIFormat("BGRA8Value");
        RGBA8 = new CIFormat("RGBA8Value");
        RGBAf = new CIFormat("RGBAfValue");
        RGBAh = new CIFormat("RGBAhValue");
        values = new CIFormat[]{BGRA8, RGBA8, RGBAh, ARGB8, RGBAf};
    }
}

