/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coreimage.CIFilterAttribute;
import org.robovm.apple.coreimage.CIFilterCategory;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreImage")
public class CIFilterAttributes
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CIFilterAttributes(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public CIFilterAttribute getAttribute(String name) {
        NSString str = new NSString(name);
        if (this.data.containsKey(str)) {
            NSDictionary val = (NSDictionary)this.data.get(str);
            return new CIFilterAttribute(val);
        }
        return null;
    }

    public String getName() {
        if (this.data.containsKey(CIFilterAttributes.NameKey())) {
            NSString val = (NSString)this.data.get(CIFilterAttributes.NameKey());
            return val.toString();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.data.containsKey(CIFilterAttributes.DisplayNameKey())) {
            NSString val = (NSString)this.data.get(CIFilterAttributes.DisplayNameKey());
            return val.toString();
        }
        return null;
    }

    public List<CIFilterCategory> getCategories() {
        if (this.data.containsKey(CIFilterAttributes.CategoriesKey())) {
            NSArray val = (NSArray)this.data.get(CIFilterAttributes.CategoriesKey());
            ArrayList<CIFilterCategory> list = new ArrayList<CIFilterCategory>();
            for (NSString str : val) {
                list.add(CIFilterCategory.valueOf(str));
            }
            return list;
        }
        return null;
    }

    @GlobalValue(symbol="kCIAttributeFilterName", optional=true)
    protected static native NSString NameKey();

    @GlobalValue(symbol="kCIAttributeFilterDisplayName", optional=true)
    protected static native NSString DisplayNameKey();

    @GlobalValue(symbol="kCIAttributeFilterCategories", optional=true)
    protected static native NSString CategoriesKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CIFilterAttributes.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIFilterAttributes toObject(Class<CIFilterAttributes> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIFilterAttributes(o);
        }

        @MarshalsPointer
        public static long toNative(CIFilterAttributes o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

