/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.List;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coreimage.CIFilterAttributes;
import org.robovm.apple.coreimage.CIFilterCategory;
import org.robovm.apple.coreimage.CIFilterInputParameters;
import org.robovm.apple.coreimage.CIImage;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSCoding;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCClass;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Variadic;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreImage")
@NativeClass
public class CIFilter
extends NSObject
implements NSCoding {
    private static final ObjCClass objCClass;
    private static final Selector createSelector;

    protected CIFilter(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="outputImage")
    public native CIImage getOutputImage();

    private static NSObject toNSObject(Object[] keysAndValues, int index) {
        if (index >= keysAndValues.length) {
            return null;
        }
        NSObject val = null;
        Object o = keysAndValues[index];
        if (o instanceof String) {
            val = new NSString((String)o);
        } else if (o instanceof Number) {
            val = NSNumber.valueOf((Number)o);
        }
        return val;
    }

    public static CIFilter create(String name, Object ... inputParameters) {
        if (inputParameters == null || inputParameters.length == 0) {
            return CIFilter.create(name);
        }
        int n = inputParameters.length;
        if (n > 20) {
            throw new IllegalArgumentException("A maximum of 10 key-value pairs is supported");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Length of array inputParameters must be even but was " + n);
        }
        NSObject key0 = CIFilter.toNSObject(inputParameters, 0);
        NSObject value0 = CIFilter.toNSObject(inputParameters, 1);
        NSObject key1 = CIFilter.toNSObject(inputParameters, 2);
        NSObject value1 = CIFilter.toNSObject(inputParameters, 3);
        NSObject key2 = CIFilter.toNSObject(inputParameters, 4);
        NSObject value2 = CIFilter.toNSObject(inputParameters, 5);
        NSObject key3 = CIFilter.toNSObject(inputParameters, 6);
        NSObject value3 = CIFilter.toNSObject(inputParameters, 7);
        NSObject key4 = CIFilter.toNSObject(inputParameters, 8);
        NSObject value4 = CIFilter.toNSObject(inputParameters, 9);
        NSObject key5 = CIFilter.toNSObject(inputParameters, 10);
        NSObject value5 = CIFilter.toNSObject(inputParameters, 11);
        NSObject key6 = CIFilter.toNSObject(inputParameters, 12);
        NSObject value6 = CIFilter.toNSObject(inputParameters, 13);
        NSObject key7 = CIFilter.toNSObject(inputParameters, 14);
        NSObject value7 = CIFilter.toNSObject(inputParameters, 15);
        NSObject key8 = CIFilter.toNSObject(inputParameters, 16);
        NSObject value8 = CIFilter.toNSObject(inputParameters, 17);
        NSObject key9 = CIFilter.toNSObject(inputParameters, 18);
        NSObject value9 = CIFilter.toNSObject(inputParameters, 19);
        return CIFilter.create(objCClass, createSelector, name, key0, value0, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, key8, value8, key9, value9);
    }

    @Bridge
    @Variadic(value=2)
    private static native CIFilter create(ObjCClass var0, Selector var1, String var2, NSObject var3, NSObject var4, NSObject var5, NSObject var6, NSObject var7, NSObject var8, NSObject var9, NSObject var10, NSObject var11, NSObject var12, NSObject var13, NSObject var14, NSObject var15, NSObject var16, NSObject var17, NSObject var18, NSObject var19, NSObject var20, NSObject var21, NSObject var22);

    @Method(selector="name")
    public native String getName();

    @Method(selector="inputKeys")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getInputKeys();

    @Method(selector="outputKeys")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getOutputKeys();

    @Method(selector="setDefaults")
    public native void setDefaults();

    @Method(selector="attributes")
    public native CIFilterAttributes getAttributes();

    @Method(selector="filterWithName:")
    public static native CIFilter create(String var0);

    @Method(selector="filterWithName:withInputParameters:")
    public static native CIFilter create(String var0, CIFilterInputParameters var1);

    @Method(selector="filterNamesInCategory:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getFilterNames(CIFilterCategory var0);

    @Method(selector="filterNamesInCategories:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getFilterNames(@Marshaler(value=CIFilterCategory.AsListMarshaler.class) List<CIFilterCategory> var0);

    @Method(selector="serializedXMPFromFilters:inputImageExtent:")
    public static native NSData serializeToXMP(NSArray<CIFilter> var0, @ByVal CGRect var1);

    public static NSArray<CIFilter> deserializeFromXMP(NSData xmpData, @ByVal CGRect extent) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSArray<CIFilter> result = CIFilter.deserializeFromXMP(xmpData, extent, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="filterArrayFromSerializedXMP:inputImageExtent:error:")
    private static native NSArray<CIFilter> deserializeFromXMP(NSData var0, @ByVal CGRect var1, NSError.NSErrorPtr var2);

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    static {
        ObjCRuntime.bind(CIFilter.class);
        objCClass = ObjCClass.getByType(CIFilter.class);
        createSelector = Selector.register((String)"filterWithName:keysAndValues:");
    }

    public static class CIFilterPtr
    extends Ptr<CIFilter, CIFilterPtr> {
    }
}

