/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.coreimage.CIDetectorAccuracy;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreImage")
public class CIDetectorOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CIDetectorOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public CIDetectorOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public CIDetectorAccuracy getAccuracy() {
        if (this.data.containsKey(CIDetectorOptions.AccuracyKey())) {
            NSString val = (NSString)this.data.get(CIDetectorOptions.AccuracyKey());
            return CIDetectorAccuracy.valueOf(val);
        }
        return null;
    }

    public CIDetectorOptions setAccuracy(CIDetectorAccuracy accuracy) {
        this.data.put(CIDetectorOptions.AccuracyKey(), accuracy.value());
        return this;
    }

    public boolean isTracking() {
        if (this.data.containsKey(CIDetectorOptions.TrackingKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorOptions.TrackingKey());
            return val.booleanValue();
        }
        return false;
    }

    public CIDetectorOptions setTracking(boolean tracking) {
        this.data.put(CIDetectorOptions.TrackingKey(), NSNumber.valueOf(tracking));
        return this;
    }

    public double getMinFeatureSize() {
        if (this.data.containsKey(CIDetectorOptions.MinFeatureSizeKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorOptions.MinFeatureSizeKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CIDetectorOptions setMinFeatureSize(double minFeatureSize) {
        this.data.put(CIDetectorOptions.MinFeatureSizeKey(), NSNumber.valueOf(minFeatureSize));
        return this;
    }

    @GlobalValue(symbol="CIDetectorAccuracy", optional=true)
    protected static native NSString AccuracyKey();

    @GlobalValue(symbol="CIDetectorTracking", optional=true)
    protected static native NSString TrackingKey();

    @GlobalValue(symbol="CIDetectorMinFeatureSize", optional=true)
    protected static native NSString MinFeatureSizeKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CIDetectorOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIDetectorOptions toObject(Class<CIDetectorOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIDetectorOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIDetectorOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

