/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.imageio.CGImagePropertyOrientation;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreImage")
public class CIDetectorFeatureOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CIDetectorFeatureOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public CIDetectorFeatureOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public CGImagePropertyOrientation getImageOrientation() {
        if (this.data.containsKey(CIDetectorFeatureOptions.ImageOrientationKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorFeatureOptions.ImageOrientationKey());
            return CGImagePropertyOrientation.valueOf(val.intValue());
        }
        return CGImagePropertyOrientation.Up;
    }

    public CIDetectorFeatureOptions setImageOrientation(CGImagePropertyOrientation orientation) {
        this.data.put(CIDetectorFeatureOptions.ImageOrientationKey(), NSNumber.valueOf(orientation.value()));
        return this;
    }

    public boolean isRecognizingEyeBlinks() {
        if (this.data.containsKey(CIDetectorFeatureOptions.EyeBlinkKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorFeatureOptions.EyeBlinkKey());
            return val.booleanValue();
        }
        return false;
    }

    public CIDetectorFeatureOptions setRecognizeEyeBlinks(boolean recognize) {
        this.data.put(CIDetectorFeatureOptions.EyeBlinkKey(), NSNumber.valueOf(recognize));
        return this;
    }

    public boolean isRecognizingSmiles() {
        if (this.data.containsKey(CIDetectorFeatureOptions.SmileKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorFeatureOptions.SmileKey());
            return val.booleanValue();
        }
        return false;
    }

    public CIDetectorFeatureOptions setRecognizeSmiles() {
        this.data.put(CIDetectorFeatureOptions.SmileKey(), NSNumber.valueOf(CIDetectorFeatureOptions.SmileKey()));
        return this;
    }

    public double getFocalLength() {
        if (this.data.containsKey(CIDetectorFeatureOptions.FocalLengthKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorFeatureOptions.FocalLengthKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CIDetectorFeatureOptions setFocalLength(double focalLength) {
        this.data.put(CIDetectorFeatureOptions.FocalLengthKey(), NSNumber.valueOf(focalLength));
        return this;
    }

    public double getAspectRatio() {
        if (this.data.containsKey(CIDetectorFeatureOptions.AspectRatioKey())) {
            NSNumber val = (NSNumber)this.data.get(CIDetectorFeatureOptions.AspectRatioKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CIDetectorFeatureOptions setFAspectRatio(double aspectRatio) {
        this.data.put(CIDetectorFeatureOptions.AspectRatioKey(), NSNumber.valueOf(aspectRatio));
        return this;
    }

    @GlobalValue(symbol="CIDetectorImageOrientation", optional=true)
    protected static native NSString ImageOrientationKey();

    @GlobalValue(symbol="CIDetectorEyeBlink", optional=true)
    protected static native NSString EyeBlinkKey();

    @GlobalValue(symbol="CIDetectorSmile", optional=true)
    protected static native NSString SmileKey();

    @GlobalValue(symbol="CIDetectorFocalLength", optional=true)
    protected static native NSString FocalLengthKey();

    @GlobalValue(symbol="CIDetectorAspectRatio", optional=true)
    protected static native NSString AspectRatioKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CIDetectorFeatureOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIDetectorFeatureOptions toObject(Class<CIDetectorFeatureOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIDetectorFeatureOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIDetectorFeatureOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

