/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coreimage.CIFormat;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSNull;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreImage")
public class CIContextOptions
extends CocoaUtility {
    private CFDictionary data;

    protected CIContextOptions(CFDictionary data) {
        this.data = data;
    }

    public CIContextOptions() {
        this.data = CFMutableDictionary.create();
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public CGColorSpace getOutputColorSpace() {
        if (this.data.containsKey((NativeObject)CIContextOptions.OutputColorSpaceKey())) {
            CGColorSpace val = this.data.get((NativeObject)CIContextOptions.OutputColorSpaceKey(), CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CIContextOptions setOutputColorSpace(CGColorSpace colorSpace) {
        this.data.put((NativeObject)CIContextOptions.OutputColorSpaceKey(), (NativeObject)(colorSpace != null ? colorSpace : NSNull.getNull()));
        return this;
    }

    public CGColorSpace getWorkingColorSpace() {
        if (this.data.containsKey((NativeObject)CIContextOptions.WorkingColorSpaceKey())) {
            CGColorSpace val = this.data.get((NativeObject)CIContextOptions.WorkingColorSpaceKey(), CGColorSpace.class);
            return val;
        }
        return null;
    }

    public CIContextOptions setWorkingColorSpace(CGColorSpace colorSpace) {
        this.data.put((NativeObject)CIContextOptions.WorkingColorSpaceKey(), (NativeObject)(colorSpace != null ? colorSpace : NSNull.getNull()));
        return this;
    }

    public CIFormat getWorkingFormat() {
        if (this.data.containsKey((NativeObject)CIContextOptions.WorkingFormatKey())) {
            NSNumber val = this.data.get((NativeObject)CIContextOptions.WorkingFormatKey(), NSNumber.class);
            return CIFormat.valueOf(val.intValue());
        }
        return null;
    }

    public CIContextOptions setWorkingFormat(CIFormat format) {
        this.data.put((NativeObject)CIContextOptions.WorkingFormatKey(), (NativeObject)NSNumber.valueOf(format.value()));
        return this;
    }

    public boolean isUsingSoftwareRenderer() {
        if (this.data.containsKey((NativeObject)CIContextOptions.UseSoftwareRendererKey())) {
            NSNumber val = this.data.get((NativeObject)CIContextOptions.UseSoftwareRendererKey(), NSNumber.class);
            return val.booleanValue();
        }
        return false;
    }

    public CIContextOptions setUseSoftwareRenderer(boolean softwareRenderer) {
        this.data.put((NativeObject)CIContextOptions.UseSoftwareRendererKey(), (NativeObject)NSNumber.valueOf(softwareRenderer));
        return this;
    }

    public boolean isRequestingLowPriority() {
        if (this.data.containsKey((NativeObject)CIContextOptions.PriorityRequestLowKey())) {
            NSNumber val = this.data.get((NativeObject)CIContextOptions.PriorityRequestLowKey(), NSNumber.class);
            return val.booleanValue();
        }
        return false;
    }

    public CIContextOptions setRequestLowPriority(boolean requestLowPriority) {
        this.data.put((NativeObject)CIContextOptions.PriorityRequestLowKey(), (NativeObject)NSNumber.valueOf(requestLowPriority));
        return this;
    }

    @GlobalValue(symbol="kCIContextOutputColorSpace", optional=true)
    protected static native NSString OutputColorSpaceKey();

    @GlobalValue(symbol="kCIContextWorkingColorSpace", optional=true)
    protected static native NSString WorkingColorSpaceKey();

    @GlobalValue(symbol="kCIContextWorkingFormat", optional=true)
    protected static native NSString WorkingFormatKey();

    @GlobalValue(symbol="kCIContextUseSoftwareRenderer", optional=true)
    protected static native NSString UseSoftwareRendererKey();

    @GlobalValue(symbol="kCIContextPriorityRequestLow", optional=true)
    protected static native NSString PriorityRequestLowKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CIContextOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIContextOptions toObject(Class<CIContextOptions> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIContextOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIContextOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

