/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIGeometry;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGSize
extends Struct<CGSize> {
    public CGSize() {
    }

    public CGSize(@MachineSizedFloat double width, @MachineSizedFloat double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    @StructMember(value=0)
    @MachineSizedFloat
    public native double getWidth();

    @StructMember(value=0)
    public native CGSize setWidth(@MachineSizedFloat double var1);

    @StructMember(value=1)
    @MachineSizedFloat
    public native double getHeight();

    @StructMember(value=1)
    public native CGSize setHeight(@MachineSizedFloat double var1);

    public static CGSize fromString(String string) {
        return UIGeometry.stringToCGSize(string);
    }

    public static CGSize fromDictionary(NSDictionary<NSString, NSNumber> dict) {
        CGSize s = new CGSize();
        if (!CGSize.fromDictionary(dict, s)) {
            throw new IllegalArgumentException("Failed to create CGSize from dictionary " + dict);
        }
        return s;
    }

    public boolean equals(Object obj) {
        return obj instanceof CGSize && CGSize.equalsTo(this, (CGSize)((Object)obj));
    }

    public String toString() {
        return UIGeometry.toString(this);
    }

    @GlobalValue(symbol="CGSizeZero", optional=true)
    @ByVal
    public static native CGSize Zero();

    public boolean equalsTo(CGSize size2) {
        return CGSize.equalsTo(this, size2);
    }

    @Bridge(symbol="CGSizeEqualToSize", optional=true)
    private static native boolean equalsTo(@ByVal CGSize var0, @ByVal CGSize var1);

    public NSDictionary<NSString, NSNumber> toDictionary() {
        return CGSize.toDictionary(this);
    }

    @Bridge(symbol="CGSizeCreateDictionaryRepresentation", optional=true)
    private static native NSDictionary<NSString, NSNumber> toDictionary(@ByVal CGSize var0);

    @Bridge(symbol="CGSizeMakeWithDictionaryRepresentation", optional=true)
    private static native boolean fromDictionary(NSDictionary<NSString, NSNumber> var0, CGSize var1);

    public CGSize apply(CGAffineTransform t) {
        return CGSize.apply(this, t);
    }

    @Bridge(symbol="CGSizeApplyAffineTransform", optional=true)
    @ByVal
    private static native CGSize apply(@ByVal CGSize var0, @ByVal CGAffineTransform var1);

    static {
        Bro.bind(CGSize.class);
    }

    public static class CGSizePtr
    extends Ptr<CGSize, CGSizePtr> {
    }
}

