/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.coregraphics.CGPDFArray;
import org.robovm.apple.coregraphics.CGPDFDictionary;
import org.robovm.apple.coregraphics.CGPDFObjectType;
import org.robovm.apple.coregraphics.CGPDFStream;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreGraphics")
public class CGPDFObject
extends NativeObject {
    protected CGPDFObject() {
    }

    public boolean isNull() {
        return this.getValue(CGPDFObjectType.Null, new VoidPtr());
    }

    public boolean booleanValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Boolean, ptr)) {
            return ((BooleanPtr)ptr.as(BooleanPtr.class)).get();
        }
        return false;
    }

    public long longValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Integer, ptr)) {
            return ((LongPtr)ptr.as(LongPtr.class)).get();
        }
        return 0L;
    }

    public double doubleValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Real, ptr)) {
            return ((DoublePtr)ptr.as(DoublePtr.class)).get();
        }
        return 0.0;
    }

    public String nameValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Name, ptr)) {
            return ((BytePtr)ptr.as(BytePtr.class)).toStringZ();
        }
        return null;
    }

    public String stringValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.String, ptr)) {
            return ((BytePtr)ptr.as(BytePtr.class)).toStringZ();
        }
        return null;
    }

    public CGPDFArray arrayValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Array, ptr)) {
            return (CGPDFArray)((CGPDFArray.CGPDFArrayPtr)ptr.as(CGPDFArray.CGPDFArrayPtr.class)).get();
        }
        return null;
    }

    public CGPDFDictionary dictionaryValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Dictionary, ptr)) {
            return (CGPDFDictionary)((CGPDFDictionary.CGPDFDictionaryPtr)ptr.as(CGPDFDictionary.CGPDFDictionaryPtr.class)).get();
        }
        return null;
    }

    public CGPDFStream streamValue() {
        VoidPtr ptr = new VoidPtr();
        if (this.getValue(CGPDFObjectType.Stream, ptr)) {
            return (CGPDFStream)((CGPDFStream.CGPDFStreamPtr)ptr.as(CGPDFStream.CGPDFStreamPtr.class)).get();
        }
        return null;
    }

    @Bridge(symbol="CGPDFObjectGetType", optional=true)
    public native CGPDFObjectType getType();

    @Bridge(symbol="CGPDFObjectGetValue", optional=true)
    private native boolean getValue(CGPDFObjectType var1, VoidPtr var2);

    static {
        Bro.bind(CGPDFObject.class);
    }

    public static class CGPDFObjectPtr
    extends Ptr<CGPDFObject, CGPDFObjectPtr> {
    }
}

