/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGBlendMode;
import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.coregraphics.CGColorRenderingIntent;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGFont;
import org.robovm.apple.coregraphics.CGGradient;
import org.robovm.apple.coregraphics.CGGradientDrawingOptions;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGInterpolationQuality;
import org.robovm.apple.coregraphics.CGLayer;
import org.robovm.apple.coregraphics.CGLineCap;
import org.robovm.apple.coregraphics.CGLineJoin;
import org.robovm.apple.coregraphics.CGPDFPage;
import org.robovm.apple.coregraphics.CGPath;
import org.robovm.apple.coregraphics.CGPathDrawingMode;
import org.robovm.apple.coregraphics.CGPattern;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.coregraphics.CGShading;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coregraphics.CGTextDrawingMode;
import org.robovm.apple.coregraphics.CGTextEncoding;
import org.robovm.apple.coregraphics.CoreGraphics;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGContext
extends CFType {
    protected CGContext() {
    }

    public void addRects(CGRect[] rects) {
        if (rects == null) {
            throw new NullPointerException("rects");
        }
        CGRect first = (CGRect)Struct.allocate(CGRect.class, (int)rects.length);
        first.update(rects);
        this.addRects(first, rects.length);
    }

    public void addLines(CGPoint[] points) {
        if (points == null) {
            throw new NullPointerException("points");
        }
        CGPoint first = (CGPoint)Struct.allocate(CGPoint.class, (int)points.length);
        first.update(points);
        this.addLines(first, points.length);
    }

    public void clipToRects(CGRect[] rects) {
        if (rects == null) {
            throw new NullPointerException("rects");
        }
        CGRect first = (CGRect)Struct.allocate(CGRect.class, (int)rects.length);
        first.update(rects);
        this.clipToRects(first, rects.length);
    }

    public void fillRects(CGRect[] rects) {
        if (rects == null) {
            throw new NullPointerException("rects");
        }
        CGRect first = (CGRect)Struct.allocate(CGRect.class, (int)rects.length);
        first.update(rects);
        this.fillRects(first, rects.length);
    }

    public void setFillColor(double[] components) {
        this.setFillColor(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setFillColor(float[] components) {
        this.setFillColor(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setStrokeColor(double[] components) {
        this.setStrokeColor(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setStrokeColor(float[] components) {
        this.setStrokeColor(VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setFillPattern(CGPattern pattern, double[] components) {
        this.setFillPattern(pattern, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setFillPattern(CGPattern pattern, float[] components) {
        this.setFillPattern(pattern, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setStrokePattern(CGPattern pattern, double[] components) {
        this.setStrokePattern(pattern, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setStrokePattern(CGPattern pattern, float[] components) {
        this.setStrokePattern(pattern, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public void setLineDash(double phase, double[] lengths) {
        if (lengths == null) {
            this.setLineDash(phase, 0L, 0L);
        } else {
            this.setLineDash(phase, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(lengths)), (long)lengths.length);
        }
    }

    public void setLineDash(double phase, float[] lengths, long count) {
        if (lengths == null) {
            this.setLineDash(phase, 0L, 0L);
        } else {
            this.setLineDash(phase, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(lengths)), (long)lengths.length);
        }
    }

    public void strokeLineSegments(CGPoint[] points) {
        if (points == null) {
            throw new NullPointerException("points");
        }
        CGPoint first = (CGPoint)Struct.allocate(CGPoint.class, (int)points.length);
        first.update(points);
        this.strokeLineSegments(first, points.length);
    }

    @Deprecated
    public void selectFont(String name, double size, CGTextEncoding textEncoding) {
        this.selectFont(VM.getStringUTFChars((String)name), size, textEncoding);
    }

    @Deprecated
    public void showText(String string) {
        byte[] bytes = string.getBytes();
        this.showText(VM.getArrayValuesAddress((Object)bytes), bytes.length);
    }

    @Deprecated
    public void showTextAtPoint(double x, double y, String string) {
        byte[] bytes = string.getBytes();
        this.showTextAtPoint(x, y, VM.getArrayValuesAddress((Object)bytes), bytes.length);
    }

    @Deprecated
    public void showGlyphs(char[] glyphs) {
        this.showGlyphs(VM.getArrayValuesAddress((Object)glyphs), glyphs.length);
    }

    @Deprecated
    public void showGlyphsAtPoint(double x, double y, char[] glyphs) {
        this.showGlyphsAtPoint(x, y, VM.getArrayValuesAddress((Object)glyphs), glyphs.length);
    }

    public void showGlyphsAtPositions(char[] glyphs, CGPoint[] positions, long count) {
        if (glyphs.length != positions.length) {
            throw new IllegalArgumentException("glyphs.length != positions.length");
        }
        CGPoint first = (CGPoint)Struct.allocate(CGPoint.class, (int)positions.length);
        first.update(positions);
        this.showGlyphsAtPositions(VM.getArrayValuesAddress((Object)glyphs), first, (long)glyphs.length);
    }

    @Deprecated
    public void showGlyphsWithAdvances(char[] glyphs, CGSize[] advances) {
        if (glyphs.length != advances.length) {
            throw new IllegalArgumentException("glyphs.length != advances.length");
        }
        CGSize first = (CGSize)Struct.allocate(CGSize.class, (int)advances.length);
        first.update(advances);
        this.showGlyphsWithAdvances(VM.getArrayValuesAddress((Object)glyphs), first, glyphs.length);
    }

    @Bridge(symbol="CGContextGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CGContextSaveGState", optional=true)
    public native void saveGState();

    @Bridge(symbol="CGContextRestoreGState", optional=true)
    public native void restoreGState();

    @Bridge(symbol="CGContextScaleCTM", optional=true)
    public native void scaleCTM(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextTranslateCTM", optional=true)
    public native void translateCTM(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextRotateCTM", optional=true)
    public native void rotateCTM(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextConcatCTM", optional=true)
    public native void concatCTM(@ByVal CGAffineTransform var1);

    @Bridge(symbol="CGContextGetCTM", optional=true)
    @ByVal
    public native CGAffineTransform getCTM();

    @Bridge(symbol="CGContextSetLineWidth", optional=true)
    public native void setLineWidth(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextSetLineCap", optional=true)
    public native void setLineCap(CGLineCap var1);

    @Bridge(symbol="CGContextSetLineJoin", optional=true)
    public native void setLineJoin(CGLineJoin var1);

    @Bridge(symbol="CGContextSetMiterLimit", optional=true)
    public native void setMiterLimit(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextSetLineDash", optional=true)
    private native void setLineDash(@MachineSizedFloat double var1, @Pointer long var3, @MachineSizedUInt long var5);

    @Bridge(symbol="CGContextSetFlatness", optional=true)
    public native void setFlatness(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextSetAlpha", optional=true)
    public native void setAlpha(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextSetBlendMode", optional=true)
    public native void setBlendMode(CGBlendMode var1);

    @Bridge(symbol="CGContextBeginPath", optional=true)
    public native void beginPath();

    @Bridge(symbol="CGContextMoveToPoint", optional=true)
    public native void moveToPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextAddLineToPoint", optional=true)
    public native void addLineToPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextAddCurveToPoint", optional=true)
    public native void addCurveToPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7, @MachineSizedFloat double var9, @MachineSizedFloat double var11);

    @Bridge(symbol="CGContextAddQuadCurveToPoint", optional=true)
    public native void addQuadCurveToPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7);

    @Bridge(symbol="CGContextClosePath", optional=true)
    public native void closePath();

    @Bridge(symbol="CGContextAddRect", optional=true)
    public native void addRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextAddRects", optional=true)
    private native void addRects(CGRect var1, @MachineSizedUInt long var2);

    @Bridge(symbol="CGContextAddLines", optional=true)
    private native void addLines(CGPoint var1, @MachineSizedUInt long var2);

    @Bridge(symbol="CGContextAddEllipseInRect", optional=true)
    public native void addEllipseInRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextAddArc", optional=true)
    public native void addArc(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7, @MachineSizedFloat double var9, int var11);

    @Bridge(symbol="CGContextAddArcToPoint", optional=true)
    public native void addArcToPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7, @MachineSizedFloat double var9);

    @Bridge(symbol="CGContextAddPath", optional=true)
    public native void addPath(CGPath var1);

    @Bridge(symbol="CGContextReplacePathWithStrokedPath", optional=true)
    public native void replacePathWithStrokedPath();

    @Bridge(symbol="CGContextIsPathEmpty", optional=true)
    public native boolean isPathEmpty();

    @Bridge(symbol="CGContextGetPathCurrentPoint", optional=true)
    @ByVal
    public native CGPoint getPathCurrentPoint();

    @Bridge(symbol="CGContextGetPathBoundingBox", optional=true)
    @ByVal
    public native CGRect getPathBoundingBox();

    @Bridge(symbol="CGContextCopyPath", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CGPath getPath();

    @Bridge(symbol="CGContextPathContainsPoint", optional=true)
    public native boolean pathContainsPoint(@ByVal CGPoint var1, CGPathDrawingMode var2);

    @Bridge(symbol="CGContextDrawPath", optional=true)
    public native void drawPath(CGPathDrawingMode var1);

    @Bridge(symbol="CGContextFillPath", optional=true)
    public native void fillPath();

    @Bridge(symbol="CGContextEOFillPath", optional=true)
    public native void evenOddFillPath();

    @Bridge(symbol="CGContextStrokePath", optional=true)
    public native void strokePath();

    @Bridge(symbol="CGContextFillRect", optional=true)
    public native void fillRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextFillRects", optional=true)
    private native void fillRects(CGRect var1, @MachineSizedUInt long var2);

    @Bridge(symbol="CGContextStrokeRect", optional=true)
    public native void strokeRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextStrokeRectWithWidth", optional=true)
    public native void strokeRect(@ByVal CGRect var1, @MachineSizedFloat double var2);

    @Bridge(symbol="CGContextClearRect", optional=true)
    public native void clearRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextFillEllipseInRect", optional=true)
    public native void fillEllipseInRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextStrokeEllipseInRect", optional=true)
    public native void strokeEllipseInRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextStrokeLineSegments", optional=true)
    private native void strokeLineSegments(CGPoint var1, @MachineSizedUInt long var2);

    @Bridge(symbol="CGContextClip", optional=true)
    public native void clip();

    @Bridge(symbol="CGContextEOClip", optional=true)
    public native void evenOddClip();

    @Bridge(symbol="CGContextClipToMask", optional=true)
    public native void clipToMask(@ByVal CGRect var1, CGImage var2);

    @Bridge(symbol="CGContextGetClipBoundingBox", optional=true)
    @ByVal
    public native CGRect getClipBoundingBox();

    @Bridge(symbol="CGContextClipToRect", optional=true)
    public native void clipToRect(@ByVal CGRect var1);

    @Bridge(symbol="CGContextClipToRects", optional=true)
    private native void clipToRects(CGRect var1, @MachineSizedUInt long var2);

    @Bridge(symbol="CGContextSetFillColorWithColor", optional=true)
    public native void setFillColor(CGColor var1);

    @Bridge(symbol="CGContextSetStrokeColorWithColor", optional=true)
    public native void setStrokeColor(CGColor var1);

    @Bridge(symbol="CGContextSetFillColorSpace", optional=true)
    public native void setFillColorSpace(CGColorSpace var1);

    @Bridge(symbol="CGContextSetStrokeColorSpace", optional=true)
    public native void setStrokeColorSpace(CGColorSpace var1);

    @Bridge(symbol="CGContextSetFillColor", optional=true)
    private native void setFillColor(@Pointer long var1);

    @Bridge(symbol="CGContextSetStrokeColor", optional=true)
    private native void setStrokeColor(@Pointer long var1);

    @Bridge(symbol="CGContextSetFillPattern", optional=true)
    private native void setFillPattern(CGPattern var1, @Pointer long var2);

    @Bridge(symbol="CGContextSetStrokePattern", optional=true)
    private native void setStrokePattern(CGPattern var1, @Pointer long var2);

    @Bridge(symbol="CGContextSetPatternPhase", optional=true)
    public native void setPatternPhase(@ByVal CGSize var1);

    @Bridge(symbol="CGContextSetGrayFillColor", optional=true)
    public native void setGrayFillColor(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextSetGrayStrokeColor", optional=true)
    public native void setGrayStrokeColor(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextSetRGBFillColor", optional=true)
    public native void setRGBFillColor(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7);

    @Bridge(symbol="CGContextSetRGBStrokeColor", optional=true)
    public native void setRGBStrokeColor(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7);

    @Bridge(symbol="CGContextSetCMYKFillColor", optional=true)
    public native void setCMYKFillColor(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7, @MachineSizedFloat double var9);

    @Bridge(symbol="CGContextSetCMYKStrokeColor", optional=true)
    public native void setCMYKStrokeColor(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @MachineSizedFloat double var5, @MachineSizedFloat double var7, @MachineSizedFloat double var9);

    @Bridge(symbol="CGContextSetRenderingIntent", optional=true)
    public native void setRenderingIntent(CGColorRenderingIntent var1);

    @Bridge(symbol="CGContextDrawImage", optional=true)
    public native void drawImage(@ByVal CGRect var1, CGImage var2);

    @Bridge(symbol="CGContextDrawTiledImage", optional=true)
    public native void drawTiledImage(@ByVal CGRect var1, CGImage var2);

    @Bridge(symbol="CGContextGetInterpolationQuality", optional=true)
    public native CGInterpolationQuality getInterpolationQuality();

    @Bridge(symbol="CGContextSetInterpolationQuality", optional=true)
    public native void setInterpolationQuality(CGInterpolationQuality var1);

    @Bridge(symbol="CGContextSetShadowWithColor", optional=true)
    public native void setShadow(@ByVal CGSize var1, @MachineSizedFloat double var2, CGColor var4);

    @Bridge(symbol="CGContextSetShadow", optional=true)
    public native void setShadow(@ByVal CGSize var1, @MachineSizedFloat double var2);

    @Bridge(symbol="CGContextDrawLinearGradient", optional=true)
    public native void drawLinearGradient(CGGradient var1, @ByVal CGPoint var2, @ByVal CGPoint var3, CGGradientDrawingOptions var4);

    @Bridge(symbol="CGContextDrawRadialGradient", optional=true)
    public native void drawRadialGradient(CGGradient var1, @ByVal CGPoint var2, @MachineSizedFloat double var3, @ByVal CGPoint var5, @MachineSizedFloat double var6, CGGradientDrawingOptions var8);

    @Bridge(symbol="CGContextDrawShading", optional=true)
    public native void drawShading(CGShading var1);

    @Bridge(symbol="CGContextSetCharacterSpacing", optional=true)
    public native void setCharacterSpacing(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextSetTextPosition", optional=true)
    public native void setTextPosition(@MachineSizedFloat double var1, @MachineSizedFloat double var3);

    @Bridge(symbol="CGContextGetTextPosition", optional=true)
    @ByVal
    public native CGPoint getTextPosition();

    @Bridge(symbol="CGContextSetTextMatrix", optional=true)
    public native void setTextMatrix(@ByVal CGAffineTransform var1);

    @Bridge(symbol="CGContextGetTextMatrix", optional=true)
    @ByVal
    public native CGAffineTransform getTextMatrix();

    @Bridge(symbol="CGContextSetTextDrawingMode", optional=true)
    public native void setTextDrawingMode(CGTextDrawingMode var1);

    @Bridge(symbol="CGContextSetFont", optional=true)
    public native void setFont(CGFont var1);

    @Bridge(symbol="CGContextSetFontSize", optional=true)
    public native void setFontSize(@MachineSizedFloat double var1);

    @Bridge(symbol="CGContextShowGlyphsAtPositions", optional=true)
    private native void showGlyphsAtPositions(@Pointer long var1, CGPoint var3, @MachineSizedUInt long var4);

    @Bridge(symbol="CGContextDrawPDFPage", optional=true)
    public native void drawPDFPage(CGPDFPage var1);

    @Bridge(symbol="CGContextBeginPage", optional=true)
    public native void beginPage(CGRect var1);

    @Bridge(symbol="CGContextEndPage", optional=true)
    public native void endPage();

    @Bridge(symbol="CGContextFlush", optional=true)
    public native void flush();

    @Bridge(symbol="CGContextSynchronize", optional=true)
    public native void synchronize();

    @Bridge(symbol="CGContextSetShouldAntialias", optional=true)
    public native void setShouldAntialias(boolean var1);

    @Bridge(symbol="CGContextSetAllowsAntialiasing", optional=true)
    public native void setAllowsAntialiasing(boolean var1);

    @Bridge(symbol="CGContextSetShouldSmoothFonts", optional=true)
    public native void setShouldSmoothFonts(boolean var1);

    @Bridge(symbol="CGContextSetAllowsFontSmoothing", optional=true)
    public native void setAllowsFontSmoothing(boolean var1);

    @Bridge(symbol="CGContextSetShouldSubpixelPositionFonts", optional=true)
    public native void setShouldSubpixelPositionFonts(boolean var1);

    @Bridge(symbol="CGContextSetAllowsFontSubpixelPositioning", optional=true)
    public native void setAllowsFontSubpixelPositioning(boolean var1);

    @Bridge(symbol="CGContextSetShouldSubpixelQuantizeFonts", optional=true)
    public native void setShouldSubpixelQuantizeFonts(boolean var1);

    @Bridge(symbol="CGContextSetAllowsFontSubpixelQuantization", optional=true)
    public native void setAllowsFontSubpixelQuantization(boolean var1);

    @Bridge(symbol="CGContextBeginTransparencyLayer", optional=true)
    public native void beginTransparencyLayer(NSDictionary<?, ?> var1);

    @Bridge(symbol="CGContextBeginTransparencyLayerWithRect", optional=true)
    public native void beginTransparencyLayer(@ByVal CGRect var1, NSDictionary<?, ?> var2);

    @Bridge(symbol="CGContextEndTransparencyLayer", optional=true)
    public native void endTransparencyLayer();

    @Bridge(symbol="CGContextGetUserSpaceToDeviceSpaceTransform", optional=true)
    @ByVal
    public native CGAffineTransform getUserSpaceToDeviceSpaceTransform();

    @Bridge(symbol="CGContextConvertPointToDeviceSpace", optional=true)
    @ByVal
    public native CGPoint convertPointToDeviceSpace(@ByVal CGPoint var1);

    @Bridge(symbol="CGContextConvertPointToUserSpace", optional=true)
    @ByVal
    public native CGPoint convertPointToUserSpace(@ByVal CGPoint var1);

    @Bridge(symbol="CGContextConvertSizeToDeviceSpace", optional=true)
    @ByVal
    public native CGSize convertSizeToDeviceSpace(@ByVal CGSize var1);

    @Bridge(symbol="CGContextConvertSizeToUserSpace", optional=true)
    @ByVal
    public native CGSize convertSizeToUserSpace(@ByVal CGSize var1);

    @Bridge(symbol="CGContextConvertRectToDeviceSpace", optional=true)
    @ByVal
    public native CGRect convertRectToDeviceSpace(@ByVal CGRect var1);

    @Bridge(symbol="CGContextConvertRectToUserSpace", optional=true)
    @ByVal
    public native CGRect convertRectToUserSpace(@ByVal CGRect var1);

    @Deprecated
    @Bridge(symbol="CGContextSelectFont", optional=true)
    private native void selectFont(@Pointer long var1, @MachineSizedFloat double var3, CGTextEncoding var5);

    @Deprecated
    @Bridge(symbol="CGContextShowText", optional=true)
    private native void showText(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="CGContextShowTextAtPoint", optional=true)
    private native void showTextAtPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @Pointer long var5, @MachineSizedUInt long var7);

    @Deprecated
    @Bridge(symbol="CGContextShowGlyphs", optional=true)
    private native void showGlyphs(@Pointer long var1, @MachineSizedUInt long var3);

    @Deprecated
    @Bridge(symbol="CGContextShowGlyphsAtPoint", optional=true)
    private native void showGlyphsAtPoint(@MachineSizedFloat double var1, @MachineSizedFloat double var3, @Pointer long var5, @MachineSizedUInt long var7);

    @Deprecated
    @Bridge(symbol="CGContextShowGlyphsWithAdvances", optional=true)
    private native void showGlyphsWithAdvances(@Pointer long var1, CGSize var3, @MachineSizedUInt long var4);

    @Bridge(symbol="CGContextDrawLayerInRect", optional=true)
    public native void drawLayerInRect(@ByVal CGRect var1, CGLayer var2);

    @Bridge(symbol="CGContextDrawLayerAtPoint", optional=true)
    public native void drawLayerAtPoint(@ByVal CGPoint var1, CGLayer var2);

    static {
        Bro.bind(CGContext.class);
    }

    public static class CGContextPtr
    extends Ptr<CGContext, CGContextPtr> {
    }
}

