/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGPattern;
import org.robovm.apple.coregraphics.CoreGraphics;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreGraphics")
public class CGColor
extends CFType {
    protected CGColor() {
    }

    public static CGColor create(CGColorSpace space, float[] components) {
        return CGColor.create(space, components, components != null ? components.length : 0);
    }

    public static CGColor create(CGColorSpace space, double[] components) {
        return CGColor.create(space, components, components != null ? components.length : 0);
    }

    private static CGColor create(CGColorSpace space, Object components, int componentsLength) {
        if (space == null) {
            throw new NullPointerException("space == null");
        }
        if (components == null) {
            throw new NullPointerException("components == null");
        }
        if ((long)componentsLength != space.getNumberOfComponents() + 1L) {
            throw new IllegalArgumentException("components.length != space.numberOfComponents + 1");
        }
        return CGColor.create(space, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public static CGColor create(CGColorSpace space, CGPattern pattern, float[] components) {
        return CGColor.create(space, pattern, components, components != null ? components.length : 0);
    }

    public static CGColor create(CGColorSpace space, CGPattern pattern, double[] components) {
        return CGColor.create(space, pattern, components, components != null ? components.length : 0);
    }

    private static CGColor create(CGColorSpace space, CGPattern pattern, Object components, int componentsLength) {
        if (space == null) {
            throw new NullPointerException("space == null");
        }
        if (components == null) {
            throw new NullPointerException("components == null");
        }
        if ((long)componentsLength != space.getNumberOfComponents() + 1L) {
            throw new IllegalArgumentException("components.length != space.numberOfComponents + 1");
        }
        return CGColor.create(space, pattern, VM.getArrayValuesAddress((Object)CoreGraphics.toMachineSizedFloatArray(components)));
    }

    public double[] getComponentsD() {
        return CGColor.getComponents(this).toDoubleArray((int)this.getNumberOfComponents());
    }

    public float[] getComponentsF() {
        return CGColor.getComponents(this).toFloatArray((int)this.getNumberOfComponents());
    }

    @Bridge(symbol="CGColorCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColor create(CGColorSpace var0, @Pointer long var1);

    @Bridge(symbol="CGColorCreateWithPattern", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGColor create(CGColorSpace var0, CGPattern var1, @Pointer long var2);

    @Bridge(symbol="CGColorCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColor createCopy(CGColor var0);

    @Bridge(symbol="CGColorCreateCopyWithAlpha", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGColor createCopy(CGColor var0, @MachineSizedFloat double var1);

    @Bridge(symbol="CGColorEqualToColor", optional=true)
    public native boolean equalsTo(CGColor var1);

    @Bridge(symbol="CGColorGetNumberOfComponents", optional=true)
    @MachineSizedUInt
    public native long getNumberOfComponents();

    @Bridge(symbol="CGColorGetComponents", optional=true)
    private static native MachineSizedFloatPtr getComponents(CGColor var0);

    @Bridge(symbol="CGColorGetAlpha", optional=true)
    @MachineSizedFloat
    public native double getAlpha();

    @Bridge(symbol="CGColorGetColorSpace", optional=true)
    public native CGColorSpace getColorSpace();

    @Bridge(symbol="CGColorGetPattern", optional=true)
    public native CGPattern getPattern();

    @Bridge(symbol="CGColorGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    static {
        Bro.bind(CGColor.class);
    }

    public static class CGColorPtr
    extends Ptr<CGColor, CGColorPtr> {
    }
}

