/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coregraphics;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGContext;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGImageAlphaInfo;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;

@Library(value="CoreGraphics")
public class CGBitmapContext
extends CGContext {
    private static AtomicLong releaseInfo = new AtomicLong();
    private static final LongMap<ReleaseDataCallback> callbacks = new LongMap();
    private static final Method cbReleaseData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReleaseData(@Pointer long refcon, IntPtr data) {
        ReleaseDataCallback callback = null;
        LongMap<ReleaseDataCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (ReleaseDataCallback)callbacks.get(refcon);
        }
        callback.release(data);
    }

    public static CGBitmapContext create(long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        return CGBitmapContext.create((IntPtr)null, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    public static CGBitmapContext create(long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGImageAlphaInfo alphaInfo) {
        return CGBitmapContext.create((IntPtr)null, width, height, bitsPerComponent, bytesPerRow, space, new CGBitmapInfo(alphaInfo.value()));
    }

    public static CGBitmapContext create(byte[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo) {
        BytePtr ptr = new BytePtr();
        ptr.set(data);
        return CGBitmapContext.create((IntPtr)ptr.as(IntPtr.class), width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo);
    }

    public static CGBitmapContext create(byte[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGImageAlphaInfo alphaInfo) {
        BytePtr ptr = new BytePtr();
        ptr.set(data);
        return CGBitmapContext.create((IntPtr)ptr.as(IntPtr.class), width, height, bitsPerComponent, bytesPerRow, space, new CGBitmapInfo(alphaInfo.value()));
    }

    public static CGBitmapContext create(long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        return CGBitmapContext.create((IntPtr)null, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    public static CGBitmapContext create(byte[] data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        BytePtr ptr = new BytePtr();
        ptr.set(data);
        return CGBitmapContext.create((IntPtr)ptr.as(IntPtr.class), width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, releaseCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CGBitmapContext create(IntPtr data, long width, long height, long bitsPerComponent, long bytesPerRow, CGColorSpace space, CGBitmapInfo bitmapInfo, ReleaseDataCallback releaseCallback) {
        long releaseInfo = CGBitmapContext.releaseInfo.getAndIncrement();
        CGBitmapContext result = CGBitmapContext.create(data, width, height, bitsPerComponent, bytesPerRow, space, bitmapInfo, new FunctionPtr(cbReleaseData), releaseInfo);
        if (result != null) {
            LongMap<ReleaseDataCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(releaseInfo, (Object)releaseCallback);
            }
        }
        return result;
    }

    @Bridge(symbol="CGBitmapContextCreateWithData", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CGBitmapContext create(IntPtr var0, @MachineSizedUInt long var1, @MachineSizedUInt long var3, @MachineSizedUInt long var5, @MachineSizedUInt long var7, CGColorSpace var9, CGBitmapInfo var10, FunctionPtr var11, @Pointer long var12);

    @Bridge(symbol="CGBitmapContextCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CGBitmapContext create(IntPtr var0, @MachineSizedUInt long var1, @MachineSizedUInt long var3, @MachineSizedUInt long var5, @MachineSizedUInt long var7, CGColorSpace var9, CGBitmapInfo var10);

    @Bridge(symbol="CGBitmapContextGetData", optional=true)
    public native IntPtr getData();

    @Bridge(symbol="CGBitmapContextGetWidth", optional=true)
    @MachineSizedUInt
    public native long getWidth();

    @Bridge(symbol="CGBitmapContextGetHeight", optional=true)
    @MachineSizedUInt
    public native long getHeight();

    @Bridge(symbol="CGBitmapContextGetBitsPerComponent", optional=true)
    @MachineSizedUInt
    public native long getBitsPerComponent();

    @Bridge(symbol="CGBitmapContextGetBitsPerPixel", optional=true)
    @MachineSizedUInt
    public native long getBitsPerPixel();

    @Bridge(symbol="CGBitmapContextGetBytesPerRow", optional=true)
    @MachineSizedUInt
    public native long getBytesPerRow();

    @Bridge(symbol="CGBitmapContextGetColorSpace", optional=true)
    public native CGColorSpace getColorSpace();

    @Bridge(symbol="CGBitmapContextGetAlphaInfo", optional=true)
    public native CGImageAlphaInfo getAlphaInfo();

    @Bridge(symbol="CGBitmapContextGetBitmapInfo", optional=true)
    public native CGBitmapInfo getBitmapInfo();

    @Bridge(symbol="CGBitmapContextCreateImage", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CGImage toImage();

    static {
        try {
            cbReleaseData = CGBitmapContext.class.getDeclaredMethod("cbReleaseData", Long.TYPE, IntPtr.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CGBitmapContext.class);
    }

    public static interface ReleaseDataCallback {
        public void release(IntPtr var1);
    }
}

