/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFRunLoopSource;
import org.robovm.apple.corefoundation.CFSocketCallBackType;
import org.robovm.apple.corefoundation.CFSocketContext;
import org.robovm.apple.corefoundation.CFSocketError;
import org.robovm.apple.corefoundation.CFSocketFlags;
import org.robovm.apple.corefoundation.CFSocketSignature;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreFoundation")
public class CFSocket
extends CFType {
    private static final AtomicLong refconId = new AtomicLong();
    private static final LongMap<CFSocketCallback> callbacks = new LongMap();
    private static final Method cbInvoke;

    protected CFSocket() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInvoke(CFSocket socket, CFSocketCallBackType callBackType, CFData address, VoidPtr data, @Pointer long info) {
        CFSocketCallback callback = null;
        LongMap<CFSocketCallback> longMap = callbacks;
        synchronized (longMap) {
            callback = (CFSocketCallback)callbacks.get(info);
        }
        callback.invoke(socket, callBackType, address, data);
    }

    public static CFSocket create(int protocolFamily, int socketType, int protocol, CFSocketCallBackType callBackTypes, CFSocketCallback callback) {
        return CFSocket.create(null, protocolFamily, socketType, protocol, callBackTypes, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFSocket create(CFAllocator allocator, int protocolFamily, int socketType, int protocol, CFSocketCallBackType callBackTypes, CFSocketCallback callback) {
        long refconId = CFSocket.refconId.getAndIncrement();
        CFSocketContext context = new CFSocketContext();
        context.setInfo(refconId);
        CFSocket result = CFSocket.create(allocator, protocolFamily, socketType, protocol, callBackTypes, new FunctionPtr(cbInvoke), context);
        if (result != null) {
            LongMap<CFSocketCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
        }
        return result;
    }

    public static CFSocket create(int sock, CFSocketCallBackType callBackTypes, CFSocketCallback callback) {
        return CFSocket.create(null, sock, callBackTypes, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFSocket create(CFAllocator allocator, int sock, CFSocketCallBackType callBackTypes, CFSocketCallback callback) {
        long refconId = CFSocket.refconId.getAndIncrement();
        CFSocketContext context = new CFSocketContext();
        context.setInfo(refconId);
        CFSocket result = CFSocket.create(allocator, sock, callBackTypes, new FunctionPtr(cbInvoke), context);
        if (result != null) {
            LongMap<CFSocketCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
        }
        return result;
    }

    public static CFSocket create(CFSocketSignature signature, CFSocketCallBackType callBackTypes, CFSocketCallback callback) {
        return CFSocket.create(null, signature, callBackTypes, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFSocket create(CFAllocator allocator, CFSocketSignature signature, CFSocketCallBackType callBackTypes, CFSocketCallback callback) {
        long refconId = CFSocket.refconId.getAndIncrement();
        CFSocketContext context = new CFSocketContext();
        context.setInfo(refconId);
        CFSocket result = CFSocket.create(allocator, signature, callBackTypes, new FunctionPtr(cbInvoke), context);
        if (result != null) {
            LongMap<CFSocketCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
        }
        return result;
    }

    public static CFSocket createConnectedToSocketSignature(CFSocketSignature signature, CFSocketCallBackType callBackTypes, CFSocketCallback callback, double timeout) {
        return CFSocket.createConnectedToSocketSignature(null, signature, callBackTypes, callback, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFSocket createConnectedToSocketSignature(CFAllocator allocator, CFSocketSignature signature, CFSocketCallBackType callBackTypes, CFSocketCallback callback, double timeout) {
        long refconId = CFSocket.refconId.getAndIncrement();
        CFSocketContext context = new CFSocketContext();
        context.setInfo(refconId);
        CFSocket result = CFSocket.createConnectedToSocketSignature(allocator, signature, callBackTypes, new FunctionPtr(cbInvoke), context, timeout);
        if (result != null) {
            LongMap<CFSocketCallback> longMap = callbacks;
            synchronized (longMap) {
                callbacks.put(refconId, (Object)callback);
            }
        }
        return result;
    }

    public CFRunLoopSource createRunLoopSource(@MachineSizedSInt long order) {
        return CFSocket.createRunLoopSource(null, this, order);
    }

    public CFRunLoopSource createRunLoopSource(CFAllocator allocator, @MachineSizedSInt long order) {
        return CFSocket.createRunLoopSource(allocator, this, order);
    }

    @Bridge(symbol="CFSocketGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFSocketCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFSocket create(CFAllocator var0, int var1, int var2, int var3, CFSocketCallBackType var4, FunctionPtr var5, CFSocketContext var6);

    @Bridge(symbol="CFSocketCreateWithNative", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFSocket create(CFAllocator var0, int var1, CFSocketCallBackType var2, FunctionPtr var3, CFSocketContext var4);

    @Bridge(symbol="CFSocketCreateWithSocketSignature", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFSocket create(CFAllocator var0, CFSocketSignature var1, CFSocketCallBackType var2, FunctionPtr var3, CFSocketContext var4);

    @Bridge(symbol="CFSocketCreateConnectedToSocketSignature", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFSocket createConnectedToSocketSignature(CFAllocator var0, CFSocketSignature var1, CFSocketCallBackType var2, FunctionPtr var3, CFSocketContext var4, double var5);

    @Bridge(symbol="CFSocketSetAddress", optional=true)
    public native CFSocketError setAddress(CFData var1);

    @Bridge(symbol="CFSocketConnectToAddress", optional=true)
    public native CFSocketError connectToAddress(CFData var1, double var2);

    @Bridge(symbol="CFSocketInvalidate", optional=true)
    public native void invalidate();

    @Bridge(symbol="CFSocketIsValid", optional=true)
    public native boolean isValid();

    @Bridge(symbol="CFSocketCopyAddress", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFData getAddress();

    @Bridge(symbol="CFSocketCopyPeerAddress", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public native CFData getPeerAddress();

    @Bridge(symbol="CFSocketGetNative", optional=true)
    public native int getNative();

    @Bridge(symbol="CFSocketCreateRunLoopSource", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFRunLoopSource createRunLoopSource(CFAllocator var0, CFSocket var1, @MachineSizedSInt long var2);

    @Bridge(symbol="CFSocketGetSocketFlags", optional=true)
    public native CFSocketFlags getSocketFlags();

    @Bridge(symbol="CFSocketSetSocketFlags", optional=true)
    public native void setSocketFlags(CFSocketFlags var1);

    @Bridge(symbol="CFSocketDisableCallBacks", optional=true)
    public native void disableCallBacks(@MachineSizedUInt long var1);

    @Bridge(symbol="CFSocketEnableCallBacks", optional=true)
    public native void enableCallBacks(@MachineSizedUInt long var1);

    @Bridge(symbol="CFSocketSendData", optional=true)
    public native CFSocketError sendData(CFData var1, CFData var2, double var3);

    @Bridge(symbol="CFSocketRegisterValue", optional=true)
    public static native CFSocketError registerValue(CFSocketSignature var0, double var1, String var3, CFType var4);

    @Bridge(symbol="CFSocketCopyRegisteredValue", optional=true)
    public static native CFSocketError getRegisteredValue(CFSocketSignature var0, double var1, String var3, CFType.CFTypePtr var4, CFData.CFDataPtr var5);

    @Bridge(symbol="CFSocketRegisterSocketSignature", optional=true)
    public static native CFSocketError registerSocketSignature(CFSocketSignature var0, double var1, String var3, CFSocketSignature var4);

    @Bridge(symbol="CFSocketCopyRegisteredSocketSignature", optional=true)
    public static native CFSocketError getRegisteredSocketSignature(CFSocketSignature var0, double var1, String var3, CFSocketSignature var4, CFData.CFDataPtr var5);

    @Bridge(symbol="CFSocketUnregister", optional=true)
    public static native CFSocketError unregister(CFSocketSignature var0, double var1, String var3);

    @Bridge(symbol="CFSocketSetDefaultNameRegistryPortNumber", optional=true)
    public static native void setDefaultNameRegistryPortNumber(short var0);

    @Bridge(symbol="CFSocketGetDefaultNameRegistryPortNumber", optional=true)
    public static native short getDefaultNameRegistryPortNumber();

    static {
        try {
            cbInvoke = CFSocket.class.getDeclaredMethod("cbInvoke", CFSocket.class, CFSocketCallBackType.class, CFData.class, VoidPtr.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CFSocket.class);
    }

    public static class CFSocketPtr
    extends Ptr<CFSocket, CFSocketPtr> {
    }

    public static interface CFSocketCallback {
        public void invoke(CFSocket var1, CFSocketCallBackType var2, CFData var3, VoidPtr var4);
    }
}

