/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.util.List;
import java.util.Map;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFPreferencesDomain;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BooleanPtr;

@Library(value="CoreFoundation")
public class CFPreferences
extends CocoaUtility {
    private String applicationID;

    public CFPreferences(CFPreferencesDomain domain) {
        this(((CFString)domain.value()).toString());
    }

    public CFPreferences(String applicationID) {
        this.applicationID = applicationID;
    }

    public static CFPreferences create(CFPreferencesDomain domain) {
        return new CFPreferences(domain);
    }

    public static CFPreferences create(String applicationID) {
        return new CFPreferences(applicationID);
    }

    public CFType getValue(String key) {
        return CFPreferences.getAppValue(this.applicationID, key);
    }

    public boolean getBooleanValue(String key) {
        return CFPreferences.getAppBooleanValue(key, this.applicationID, new BooleanPtr());
    }

    public boolean hasBooleanValue(String key) {
        BooleanPtr ptr = new BooleanPtr();
        CFPreferences.getAppBooleanValue(key, this.applicationID, ptr);
        return ptr.get();
    }

    public long getLongValue(String key) {
        return CFPreferences.getAppIntegerValue(key, this.applicationID, new BooleanPtr());
    }

    public boolean hasLongValue(String key) {
        BooleanPtr ptr = new BooleanPtr();
        CFPreferences.getAppIntegerValue(key, this.applicationID, ptr);
        return ptr.get();
    }

    public void setValue(String key, CFType value) {
        CFPreferences.setAppValue(key, value, this.applicationID);
    }

    public void addSuitePreferences(String suiteID) {
        CFPreferences.addSuitePreferencesToApp(this.applicationID, suiteID);
    }

    public void removeSuitePreferences(String suiteID) {
        CFPreferences.removeSuitePreferencesFromApp(this.applicationID, suiteID);
    }

    public boolean synchronize() {
        return CFPreferences.appSynchronize(this.applicationID);
    }

    public CFType getValue(String key, CFPreferencesDomain userName, CFPreferencesDomain hostName) {
        return CFPreferences.getValue(key, this.applicationID, ((CFString)userName.value()).toString(), ((CFString)hostName.value()).toString());
    }

    public CFType getValue(String key, String userName, String hostName) {
        return CFPreferences.getValue(key, this.applicationID, userName, hostName);
    }

    public Map<String, ?> getMultipleValues(List<String> keysToFetch, CFPreferencesDomain userName, CFPreferencesDomain hostName) {
        return CFPreferences.getMultiple(keysToFetch, this.applicationID, ((CFString)userName.value()).toString(), ((CFString)hostName.value()).toString());
    }

    public Map<String, ?> getMultipleValues(List<String> keysToFetch, String userName, String hostName) {
        return CFPreferences.getMultiple(keysToFetch, this.applicationID, userName, hostName);
    }

    public void setValue(String key, CFType value, CFPreferencesDomain userName, CFPreferencesDomain hostName) {
        CFPreferences.setValue(key, value, this.applicationID, ((CFString)userName.value()).toString(), ((CFString)hostName.value()).toString());
    }

    public void setValue(String key, CFType value, String userName, String hostName) {
        CFPreferences.setValue(key, value, this.applicationID, userName, hostName);
    }

    public void setMultipleValues(Map<String, ?> keysToSet, List<String> keysToRemove, CFPreferencesDomain userName, CFPreferencesDomain hostName) {
        CFPreferences.setMultiple(keysToSet, keysToRemove, this.applicationID, ((CFString)userName.value()).toString(), ((CFString)hostName.value()).toString());
    }

    public void setMultipleValues(Map<String, ?> keysToSet, List<String> keysToRemove, String userName, String hostName) {
        CFPreferences.setMultiple(keysToSet, keysToRemove, this.applicationID, userName, hostName);
    }

    public boolean synchronize(CFPreferencesDomain userName, CFPreferencesDomain hostName) {
        return CFPreferences.synchronize(this.applicationID, ((CFString)userName.value()).toString(), ((CFString)hostName.value()).toString());
    }

    public boolean synchronize(String userName, String hostName) {
        return CFPreferences.synchronize(this.applicationID, userName, hostName);
    }

    public List<String> getKeyList(CFPreferencesDomain userName, CFPreferencesDomain hostName) {
        return CFPreferences.getKeyList(this.applicationID, ((CFString)userName.value()).toString(), ((CFString)hostName.value()).toString());
    }

    public List<String> getKeyList(String userName, String hostName) {
        return CFPreferences.getKeyList(this.applicationID, userName, hostName);
    }

    public boolean isValueForced(String key) {
        return CFPreferences.appValueIsForced(key, this.applicationID);
    }

    @Bridge(symbol="CFPreferencesCopyAppValue", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFType getAppValue(String var0, String var1);

    @Bridge(symbol="CFPreferencesGetAppBooleanValue", optional=true)
    protected static native boolean getAppBooleanValue(String var0, String var1, BooleanPtr var2);

    @Bridge(symbol="CFPreferencesGetAppIntegerValue", optional=true)
    @MachineSizedSInt
    protected static native long getAppIntegerValue(String var0, String var1, BooleanPtr var2);

    @Bridge(symbol="CFPreferencesSetAppValue", optional=true)
    protected static native void setAppValue(String var0, CFType var1, String var2);

    @Bridge(symbol="CFPreferencesAddSuitePreferencesToApp", optional=true)
    protected static native void addSuitePreferencesToApp(String var0, String var1);

    @Bridge(symbol="CFPreferencesRemoveSuitePreferencesFromApp", optional=true)
    protected static native void removeSuitePreferencesFromApp(String var0, String var1);

    @Bridge(symbol="CFPreferencesAppSynchronize", optional=true)
    protected static native boolean appSynchronize(String var0);

    @Bridge(symbol="CFPreferencesCopyValue", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFType getValue(String var0, String var1, String var2, String var3);

    @Bridge(symbol="CFPreferencesCopyMultiple", optional=true)
    @Marshaler(value=CFDictionary.AsStringMapMarshaler.class)
    protected static native Map<String, ?> getMultiple(@Marshaler(value=CFArray.AsStringListMarshaler.class) List<String> var0, String var1, String var2, String var3);

    @Bridge(symbol="CFPreferencesSetValue", optional=true)
    protected static native void setValue(String var0, CFType var1, String var2, String var3, String var4);

    @Bridge(symbol="CFPreferencesSetMultiple", optional=true)
    protected static native void setMultiple(@Marshaler(value=CFDictionary.AsStringMapMarshaler.class) Map<String, ?> var0, @Marshaler(value=CFArray.AsStringListMarshaler.class) List<String> var1, String var2, String var3, String var4);

    @Bridge(symbol="CFPreferencesSynchronize", optional=true)
    protected static native boolean synchronize(String var0, String var1, String var2);

    @Deprecated
    @Bridge(symbol="CFPreferencesCopyApplicationList", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    protected static native List<String> getApplicationList(String var0, String var1);

    @Bridge(symbol="CFPreferencesCopyKeyList", optional=true)
    @Marshaler(value=CFArray.AsStringListMarshaler.class)
    protected static native List<String> getKeyList(String var0, String var1, String var2);

    @Bridge(symbol="CFPreferencesAppValueIsForced", optional=true)
    protected static native boolean appValueIsForced(String var0, String var1);

    static {
        Bro.bind(CFPreferences.class);
    }
}

